/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.httpsoapbc.OutboundMessageProcessor;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBean;
import java.util.LinkedList;
import java.util.Map;

public class OutboundMessageProcessorPool {
    private final LinkedList<OutboundMessageProcessor> mOutboundMessageProcessors = new LinkedList();
    private final MessagingChannel mChannel;
    private final Map mEndpoints;
    private final Map mInboundExchanges;
    private final HTTPManagementMBean mManagementMBean;
    private int mActiveProcessors = 0;
    private int mMaxSize = 0;

    public OutboundMessageProcessorPool(MessagingChannel chnl, Map endpoints, Map inboundExchanges, HTTPManagementMBean managementMBean) {
        this.mChannel = chnl;
        this.mEndpoints = endpoints;
        this.mInboundExchanges = inboundExchanges;
        this.mManagementMBean = managementMBean;
    }

    public OutboundMessageProcessorPool(int initSize, int maxSize, MessagingChannel chnl, Map endpoints, Map inboundExchanges, HTTPManagementMBean managementMBean) {
        this(chnl, endpoints, inboundExchanges, managementMBean);
        for (int i = 0; i < initSize; ++i) {
            this.mOutboundMessageProcessors.addFirst(new OutboundMessageProcessor(this.mChannel, this.mEndpoints, this.mInboundExchanges, this.mManagementMBean));
        }
        this.mMaxSize = maxSize;
    }

    public synchronized OutboundMessageProcessor retrieve() {
        OutboundMessageProcessor transformer = null;
        transformer = !this.mOutboundMessageProcessors.isEmpty() ? this.mOutboundMessageProcessors.removeFirst() : new OutboundMessageProcessor(this.mChannel, this.mEndpoints, this.mInboundExchanges, this.mManagementMBean);
        ++this.mActiveProcessors;
        return transformer;
    }

    public synchronized boolean relinquish(OutboundMessageProcessor transformer) {
        boolean success = false;
        if (this.mActiveProcessors + this.mOutboundMessageProcessors.size() > this.mMaxSize) {
            success = true;
        } else if (transformer != null && !this.mOutboundMessageProcessors.contains(transformer)) {
            this.mOutboundMessageProcessors.addFirst(transformer);
            success = true;
        }
        --this.mActiveProcessors;
        return success;
    }

    public synchronized void setSize(int size) {
        if (size < this.mActiveProcessors + this.mOutboundMessageProcessors.size()) {
            int numToRemove = size < this.mOutboundMessageProcessors.size() ? size : this.mOutboundMessageProcessors.size();
            for (int i = 0; i < numToRemove; ++i) {
                this.mOutboundMessageProcessors.removeFirst();
            }
        }
    }
}

