/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.impl;

import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityManager;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.api.HttpBcSecurityException;
import com.sun.jbi.httpsoapbc.security.http.impl.HTTPSecurityContextHandler;
import javax.security.auth.Subject;

public class EndpointSecurityManagerImpl
implements EndpointSecurityManager {
    private EndpointSecurityConfig securityConfig;
    private HTTPSecurityContextHandler httpSecurityContextHandler;
    private boolean isSecurityConfigSet = false;
    private Subject securitySubject = null;

    public EndpointSecurityManagerImpl(EndpointSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        this.httpSecurityContextHandler = new HTTPSecurityContextHandler(securityConfig);
        this.isSecurityConfigSet = true;
    }

    public EndpointSecurityManagerImpl() {
    }

    public void initialize(EndpointSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        this.httpSecurityContextHandler = new HTTPSecurityContextHandler(securityConfig);
        this.isSecurityConfigSet = true;
    }

    public void handleSecurity(String authorizationHeader, Subject subject, boolean inbound, HTTPBasicAuthCredential bacredential) throws HttpBcSecurityException {
        if (inbound && this.securityConfig.isValidateHTTPBasicAuthCredential()) {
            this.httpSecurityContextHandler.validateMessage(authorizationHeader, subject, bacredential);
            this.setSubject(subject);
        }
    }

    public boolean isInitialized() {
        return this.isSecurityConfigSet;
    }

    public void setSubject(Subject sub) {
        this.securitySubject = sub;
    }

    public Subject getSubject() {
        return this.securitySubject;
    }
}

