/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistry {
    private ConcurrentHashMap endpoints = new ConcurrentHashMap(11, 0.75f, 4);
    private ConcurrentHashMap<String, DescriptorEndpointInfo> jbiProviders = new ConcurrentHashMap(11, 0.75f, 4);
    private ConcurrentHashMap<String, DescriptorEndpointInfo> jbiConsumers = new ConcurrentHashMap(11, 0.75f, 4);
    private ConcurrentHashMap<String, DescriptorEndpointInfo> wsdlEndpts = new ConcurrentHashMap(11, 0.75f, 4);
    private ConcurrentHashMap<String, DescriptorEndpointInfo> jbiEndpts = new ConcurrentHashMap(11, 0.75f, 4);
    private Set<String> compApps = new HashSet<String>();
    private Map<String, List<WebServiceEndpoint>> ws_endpoints = new HashMap<String, List<WebServiceEndpoint>>();
    private static EndpointRegistry store = new EndpointRegistry();

    private EndpointRegistry() {
    }

    public static EndpointRegistry getInstance() {
        return store;
    }

    public void put(QName service, String endpointName, ServiceEngineEndpoint endpoint) {
        Hashtable<String, ServiceEngineEndpoint> map = (Hashtable<String, ServiceEngineEndpoint>)this.endpoints.get(service);
        if (map == null) {
            map = new Hashtable<String, ServiceEngineEndpoint>();
            this.endpoints.put(service, map);
        }
        map.put(endpointName, endpoint);
    }

    public ServiceEngineEndpoint get(QName service, String endpointName) {
        Map map = (Map)this.endpoints.get(service);
        if (map != null) {
            return (ServiceEngineEndpoint)map.get(endpointName);
        }
        return null;
    }

    public void delete(QName service, String endpointName) {
        Map map = (Map)this.endpoints.get(service);
        map.remove(endpointName);
    }

    public List<ServiceEngineEndpoint> list() {
        LinkedList<ServiceEngineEndpoint> list = new LinkedList<ServiceEngineEndpoint>();
        for (Hashtable table : this.endpoints.values()) {
            list.addAll(table.values());
        }
        return list;
    }

    public Map<String, List<WebServiceEndpoint>> getWSEndpoints() {
        return this.ws_endpoints;
    }

    public boolean hasProviderEP(ServiceEngineEndpoint seEndpoint) {
        if (!this.compApps.contains(seEndpoint.getApplicationName())) {
            return false;
        }
        QName service = seEndpoint.getServiceName();
        String endpointName = seEndpoint.getEndpointName();
        DescriptorEndpointInfo ep = this.jbiProviders.get(service.getLocalPart() + endpointName);
        return ep != null && ep.isStarted();
    }

    public boolean hasConsumerEP(QName service, String endpointName) {
        DescriptorEndpointInfo ep = this.jbiConsumers.get(service.getLocalPart() + endpointName);
        return ep != null && ep.isStarted();
    }

    ConcurrentHashMap<String, DescriptorEndpointInfo> getProviders() {
        return this.jbiProviders;
    }

    ConcurrentHashMap<String, DescriptorEndpointInfo> getConsumers() {
        return this.jbiConsumers;
    }

    Set<String> getCompApps() {
        return this.compApps;
    }

    public ConcurrentHashMap<String, DescriptorEndpointInfo> getWSDLEndpts() {
        return this.wsdlEndpts;
    }

    public ConcurrentHashMap<String, DescriptorEndpointInfo> getJBIEndpts() {
        return this.jbiEndpts;
    }
}

