/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.servletsupport;

import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.SynchronousReplySupport;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletDenormalizer;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletNormalizer;
import com.sun.jbi.internationalization.Messages;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SynchronousServletRequestProcessor {
    private static final Messages mMessages = Messages.getMessages(SynchronousServletRequestProcessor.class);
    private static final Logger mLogger = Messages.getLogger(SynchronousServletRequestProcessor.class);
    static final String INIT_TARGET_DEPLOYMENT_ID = "TargetDeploymentId";
    Normalizer mNormalizer;
    Denormalizer mDenormalizer;
    SynchronousReplySupport mReplyListener;
    HttpSoapBindingLifeCycle lifeCycle;
    InboundMessageProcessor mInboundProcessor;

    public SynchronousServletRequestProcessor(HttpSoapBindingLifeCycle lifeCycle) throws MessagingException {
        this.lifeCycle = lifeCycle;
        this.initialize();
    }

    void initialize() throws MessagingException {
        this.mNormalizer = new HttpServletNormalizer();
        this.mDenormalizer = new HttpServletDenormalizer();
        this.mReplyListener = new SynchronousReplySupport();
        this.mInboundProcessor = new InboundMessageProcessor(this.mNormalizer, this.mReplyListener);
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block8: {
            response.setContentType("text/xml");
            String context = request.getContextPath() + request.getPathInfo();
            int port = request.getServerPort();
            Endpoint targetEndpoint = this.lifeCycle.getEndpointBeanForContext(context, port);
            OperationMetaData operationMetaData = null;
            if (targetEndpoint == null) {
                if (mLogger.isLoggable(Level.WARNING)) {
                    mLogger.log(Level.WARNING, "HTTPBC-W00600.No_webservice_mapping_for_url", new Object[]{context, new Integer(port)});
                }
            } else {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Web service mapping found for the requested URL, context " + context + " at port " + port);
                }
                this.mInboundProcessor.setInput(request);
                this.mInboundProcessor.setTargetEndpoint(targetEndpoint);
                try {
                    Map nameToMeta;
                    this.mInboundProcessor.execute(null);
                    MessageExchange exchange = this.mReplyListener.waitForReply();
                    NormalizedMessage outMsg = null;
                    if (exchange instanceof InOut) {
                        InOut inout = (InOut)exchange;
                        outMsg = inout.getOutMessage();
                    }
                    if ((operationMetaData = (OperationMetaData)(nameToMeta = targetEndpoint.getOperationNameToMetaData()).get(exchange.getOperation())) == null) {
                        throw new MessagingException(mMessages.getString("HTTPBC-E00667.No_opmeta_for_operation", (Object)exchange.getOperation()));
                    }
                    response = (HttpServletResponse)this.mDenormalizer.denormalize(outMsg, exchange, response, operationMetaData);
                }
                catch (MessagingException ex) {
                    if (!mLogger.isLoggable(Level.WARNING)) break block8;
                    mLogger.log(Level.WARNING, "HTTPBC-WOO605.Exception_during_request_processing", ex);
                }
            }
        }
    }
}

