/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.jaxwssupport;

import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.FaultException;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.SynchronousReplySupport;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSDenormalizer;
import com.sun.jbi.httpsoapbc.jaxwssupport.JAXWSNormalizer;
import com.sun.jbi.internationalization.Messages;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class JBIProvider
implements Provider<SOAPMessage> {
    @Resource
    protected WebServiceContext wsContext;
    private static final Messages mMessages = Messages.getMessages(JBIProvider.class);
    private static final Logger mLogger = Messages.getLogger(JBIProvider.class);
    private Endpoint targetEndpoint;
    private HttpSoapBindingLifeCycle lifeCycle = null;
    private SynchronousReplySupport replyListener = new SynchronousReplySupport();
    private static ThreadLocal processorSupport = new ThreadLocal();

    public JBIProvider(Endpoint endpoint) {
        this.targetEndpoint = endpoint;
        this.lifeCycle = (HttpSoapBindingLifeCycle)HttpSoapComponentContext.getInstance().getAssociatedLifeCycle();
        this.replyListener = new SynchronousReplySupport();
    }

    public SOAPMessage invoke(SOAPMessage request) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Processing SOAPMessage received.");
            mLogger.log(Level.FINE, "WebServiceContext: " + this.wsContext);
        }
        SOAPMessage response = null;
        try {
            try {
                InboundMessageProcessor anInboundProcessor = this.getProcessorSupport().inboundProcessor;
                anInboundProcessor.setInput(request);
                anInboundProcessor.setTargetEndpoint(this.targetEndpoint);
                String exchangeID = anInboundProcessor.execute(null);
                MessageExchange exchange = this.replyListener.waitForReply();
                NormalizedMessage outMsg = null;
                if (exchange instanceof InOut) {
                    String operation;
                    InOut inout = (InOut)exchange;
                    outMsg = inout.getOutMessage();
                    Map nameToMeta = this.targetEndpoint.getOperationNameToMetaData();
                    OperationMetaData operationMetaData = (OperationMetaData)nameToMeta.get(operation = exchange.getOperation().getLocalPart());
                    if (operationMetaData == null) {
                        throw new MessagingException(mMessages.getString("HTTPBC-E00667.No_opmeta_for_operation", (Object)exchange.getOperation()));
                    }
                    Denormalizer denormalizer = this.getProcessorSupport().denormalizer;
                    response = (SOAPMessage)denormalizer.denormalize(outMsg, exchange, response, operationMetaData);
                }
            }
            catch (MessagingException ex) {
                if (mLogger.isLoggable(Level.WARNING)) {
                    mLogger.log(Level.WARNING, "HTTPBC-W00625.Exception_during_request_processing", ex);
                }
                throw new FaultException(ex);
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "response: " + response);
            }
            Transformer transformer = null;
            try {
                TransformerFactory fact = TransformerFactory.newInstance();
                transformer = fact.newTransformer();
            }
            catch (Exception ex) {
                mLogger.log(Level.SEVERE, "failed", ex);
            }
            MessageFactory testFactory = MessageFactory.newInstance();
            SOAPMessage testMsg = testFactory.createMessage();
            StringWriter writer = new StringWriter();
            StreamResult dest = new StreamResult(writer);
            try {
                transformer.transform(response.getSOAPPart().getContent(), dest);
            }
            catch (Exception ex) {
                mLogger.log(Level.SEVERE, "transform failed", ex);
            }
            String asStr = writer.toString();
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Transformed: " + asStr);
            }
            testMsg.getSOAPPart().setContent((Source)new StreamSource(new StringReader(asStr)));
            return testMsg;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ProcessorSupport getProcessorSupport() throws MessagingException {
        ProcessorSupport currentProcSupport = (ProcessorSupport)processorSupport.get();
        if (currentProcSupport == null) {
            currentProcSupport = new ProcessorSupport();
            currentProcSupport.normalizer = new JAXWSNormalizer();
            currentProcSupport.denormalizer = new JAXWSDenormalizer();
            currentProcSupport.inboundProcessor = new InboundMessageProcessor(currentProcSupport.normalizer, this.replyListener);
            processorSupport.set(currentProcSupport);
        }
        return currentProcSupport;
    }

    static class ProcessorSupport {
        Normalizer normalizer;
        Denormalizer denormalizer;
        InboundMessageProcessor inboundProcessor;

        ProcessorSupport() {
        }
    }
}

