/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.DOMStreamReader;
import com.sun.enterprise.jbi.serviceengine.util.DOMUtil;
import com.sun.enterprise.jbi.serviceengine.util.JBIConstants;
import com.sun.enterprise.jbi.serviceengine.util.StAXSource;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPConstants;
import com.sun.enterprise.jbi.serviceengine.util.soap.StringTranslator;
import com.sun.logging.LogDomains;
import com.sun.xml.bind.api.Bridge;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.DOMHeader;
import com.sun.xml.ws.message.DataHandlerAttachment;
import com.sun.xml.ws.message.stream.StreamHeader11;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Part;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnWrappedMessage
extends Message
implements JBIConstants,
SOAPConstants {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");
    private String payloadLocalName;
    private String payloadNamespaceURI;
    private Source payLoadAsSource;
    private XMLStreamReader payLoadAsStreamReader;
    private ByteArrayOutputStream payLoadAsBaos;
    private HeaderList headers = new HeaderList();
    private boolean isFault;
    private boolean log = false;
    Source nmContent;
    NormalizedMessage normalizedMessage;
    QName wsdlMessageType;
    String wsdlBindingStyle;
    List<Part> wsdlOrderedParts;
    int[] wsdlPartBindings;

    private void setLog() {
        if (logger.isLoggable(Level.FINE)) {
            this.log = true;
        }
    }

    public UnWrappedMessage() {
        this.setLog();
    }

    public void setNormalizedMessage(NormalizedMessage normalizedMessage) {
        this.normalizedMessage = normalizedMessage;
        this.nmContent = normalizedMessage.getContent();
    }

    public void setWSDLMessageType(QName wsdlMessageType) {
        this.wsdlMessageType = wsdlMessageType;
    }

    public void setWSDLBindingStyle(String wsdlBindingStyle) {
        this.wsdlBindingStyle = wsdlBindingStyle;
    }

    public void setWSDLOrderedParts(List<Part> wsdlOrderedParts) {
        this.wsdlOrderedParts = wsdlOrderedParts;
    }

    public void setWSDLPartBindings(int[] wsdlPartBindings) {
        this.wsdlPartBindings = wsdlPartBindings;
    }

    public void unwrap() throws Exception {
        if (this.log) {
            String s = this.nmContent instanceof DOMSource ? UnWrappedMessage.toString(this.nmContent) : "StreamSource";
            logger.log(Level.FINE, "bindingStyle = " + this.wsdlBindingStyle + ", received message = " + s);
        }
        if (JavaEEServiceEngineContext.getInstance().isServiceMix()) {
            if (this.log) {
                logger.log(Level.FINE, "Skipping the unwrapping...");
            }
            this.setPayLoad(this.nmContent);
        } else if ("rpc".equalsIgnoreCase(this.wsdlBindingStyle)) {
            new RPCStyleUnWrapper().unwrap();
        } else {
            new DocumentStyleUnWrapper().unwrap();
        }
        this.processAttachments();
        if (this.payLoadAsStreamReader == null) {
            throw new Exception(StringTranslator.getDefaultInstance().getString("serviceengine.unwrapping_failed"));
        }
    }

    public void unwrapFault() throws Exception {
        if (this.log) {
            String s = this.nmContent instanceof DOMSource ? UnWrappedMessage.toString(this.nmContent) : "StreamSource";
            logger.log(Level.FINE, "bindingStyle = " + this.wsdlBindingStyle + ", received fault = " + s);
        }
        this.isFault = true;
        if (JavaEEServiceEngineContext.getInstance().isServiceMix()) {
            if (this.log) {
                logger.log(Level.FINE, "Skipping the unwrapping...");
            }
            this.setPayLoad(this.nmContent);
        } else {
            this.unWrapFault();
        }
        if (this.payLoadAsStreamReader == null) {
            throw new Exception(StringTranslator.getDefaultInstance().getString("serviceengine.unwrapping_failed"));
        }
    }

    public boolean isFault() {
        return this.isFault;
    }

    public String getPayloadLocalPart() {
        return this.payloadLocalName;
    }

    public String getPayloadNamespaceURI() {
        return this.payloadNamespaceURI;
    }

    public boolean hasPayload() {
        return this.payLoadAsStreamReader == null;
    }

    public boolean hasHeaders() {
        return this.headers.size() != 0;
    }

    public HeaderList getHeaders() {
        if (this.log) {
            logger.log(Level.FINE, "Headers = " + this.headers);
        }
        return this.headers;
    }

    public Message copy() {
        return null;
    }

    public Source readEnvelopeAsSource() {
        return null;
    }

    public XMLStreamReader readPayload() throws XMLStreamException {
        if (this.log) {
            logger.log(Level.FINE, "UnWrappedMessage :: readPayLoad()");
        }
        return this.payLoadAsStreamReader;
    }

    public Source readPayloadAsSource() {
        if (this.log) {
            logger.log(Level.FINE, "UnWrappedMessage :: readPayLoadAsSource()");
        }
        return this.payLoadAsSource;
    }

    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (System.getSecurityManager() == null) {
            return (T)unmarshaller.unmarshal(this.payLoadAsSource);
        }
        try {
            final Unmarshaller funmarshaller = unmarshaller;
            final Source fpayLoad = this.payLoadAsSource;
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return funmarshaller.unmarshal(fpayLoad);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getException();
        }
    }

    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        if (System.getSecurityManager() == null) {
            return (T)bridge.unmarshal(this.payLoadAsSource);
        }
        try {
            final Bridge<T> fbridge = bridge;
            final Source fpayLoad = this.payLoadAsSource;
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return fbridge.unmarshal(fpayLoad);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getException();
        }
    }

    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        throw new XMLStreamException("Operaion is not supported.");
    }

    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        throw new XMLStreamException("Operaion is not supported.");
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        throw new SAXException("Operaion is not supported.");
    }

    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        String methodSig = "\ncom.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage::readAsSOAPMessage()";
        String usedWith = System.getProperty("com.sun.enterprise.jbi.se.usedwith");
        if (usedWith == null || usedWith.indexOf("jmacprovider") == -1) {
            throw new SOAPException(methodSig + " operation is not supported." + "\nSet this system property to workaround this issue : " + "com.sun.enterprise.jbi.se.usedwith=jmacprovider");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter writer = XOF.createXMLStreamWriter(baos, "UTF-8");
            writer.writeStartDocument();
            writer.writeStartElement("Soap:Envelope");
            writer.writeAttribute("xmlns:Soap", "http://schemas.xmlsoap.org/soap/envelope/");
            writer.writeEmptyElement("Soap:Header");
            writer.writeStartElement("Soap:Body");
            if (this.payLoadAsBaos == null) {
                if (this.payLoadAsSource instanceof DOMSource) {
                    Node payLoadNode = ((DOMSource)this.payLoadAsSource).getNode();
                    DOMUtil.UTIL.writeNode(payLoadNode, writer);
                } else {
                    DOMUtil.UTIL.writeNode(this.payLoadAsStreamReader, writer);
                }
            } else {
                baos.write(">".getBytes());
                baos.write(this.payLoadAsBaos.toByteArray());
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            SOAPMessage message = MessageFactory.newInstance().createMessage(null, (InputStream)bais);
            if (this.log) {
                logger.log(Level.FINE, methodSig + " :: SOAPMessage = " + UnWrappedMessage.toString(message));
            }
            return message;
        }
        catch (Exception ex) {
            throw new SOAPException(methodSig + ex.getMessage());
        }
    }

    public void setPayLoad(Source s) throws Exception {
        if (s instanceof DOMSource) {
            this.setPayLoad(((DOMSource)s).getNode());
        } else if (s instanceof StreamSource) {
            XMLStreamReader reader = XIF.createXMLStreamReader(((StreamSource)s).getInputStream());
            this.setPayLoad(reader);
        } else if (s instanceof SAXSource) {
            InputSource source = ((SAXSource)s).getInputSource();
            XMLStreamReader reader = source.getCharacterStream() != null ? XIF.createXMLStreamReader(source.getCharacterStream()) : XIF.createXMLStreamReader(source.getByteStream());
            this.setPayLoad(reader);
        } else {
            logger.log(Level.WARNING, "UnWrappedMessage :: Transforming the input message to DOM");
            Transformer t = TF.newTransformer();
            DOMResult result = new DOMResult();
            t.transform(s, result);
            this.setPayLoad(result.getNode());
        }
    }

    public void setPayLoad(Node n) {
        if (n.getNodeType() == 9) {
            n = n.getFirstChild();
        }
        this.payloadLocalName = n.getLocalName();
        this.payloadNamespaceURI = n.getNamespaceURI();
        this.payLoadAsSource = new DOMSource(n);
        this.payLoadAsStreamReader = new DOMStreamReader(n);
        this.printPayLoad("");
    }

    public void setPayLoad(XMLStreamReader reader) throws Exception {
        if (reader.getEventType() == 7) {
            reader.next();
        }
        this.payloadLocalName = reader.getLocalName();
        this.payloadNamespaceURI = reader.getNamespaceURI();
        this.payLoadAsSource = new StAXSource(reader, true);
        this.payLoadAsStreamReader = reader;
        XMLStreamReader r = reader;
        this.printPayLoad("");
    }

    public void copyPayLoad(XMLStreamReader r) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XOF.createXMLStreamWriter(baos, "UTF-8");
        DOMUtil.UTIL.writeNode(r, writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        XMLStreamReader reader = XIF.createXMLStreamReader(bais);
        if (this.log) {
            logger.log(Level.FINE, "Payload = " + baos.toString());
        }
        this.setPayLoad(reader);
    }

    public static String toString(SOAPMessage soapMessage) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)baos);
            return baos.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static String toString(Node n) {
        return UnWrappedMessage.toString(new DOMSource(n));
    }

    public static String toString(XMLStreamReader reader) {
        return UnWrappedMessage.toString(new StAXSource(reader, true));
    }

    public static String toString(Source s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(baos);
            TF.newTransformer().transform(s, sr);
            return baos.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public StreamSource getStreamSource(Source src) {
        try {
            if (src instanceof StreamSource) {
                return (StreamSource)src;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            TF.newTransformer().transform(src, result);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            StreamSource ss = new StreamSource(bais);
            return ss;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void printPayLoad(String message) {
        if (!this.log) {
            return;
        }
        StringBuffer msg = new StringBuffer("\n\n");
        if (this.payLoadAsSource instanceof DOMSource) {
            Node n = ((DOMSource)this.payLoadAsSource).getNode();
            msg.append("Unwrapped message " + UnWrappedMessage.toString(n));
        }
        msg.append(message).append("\n\npayLoadLocalName = ").append(this.payloadLocalName).append("\npayLoadNamespaceURI = ").append(this.payloadNamespaceURI).append("\n\n");
        logger.log(Level.FINE, msg.toString());
    }

    private void addHeader(Node n) {
        if (this.log) {
            logger.log(Level.FINE, "Header = " + UnWrappedMessage.toString(n));
        }
        DOMHeader header = new DOMHeader((Element)n);
        this.headers.add((Header)header);
    }

    private void addHeader(XMLStreamReader r) {
        try {
            if (this.log) {
                logger.log(Level.FINE, "Header = " + r.getName());
            }
            StreamHeader11 header = new StreamHeader11(r);
            this.headers.add((Header)header);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void processAttachments() {
        for (String aName : this.normalizedMessage.getAttachmentNames()) {
            logger.log(Level.FINE, "Adding attachment with ID = " + aName);
            this.getAttachments().add((Attachment)new DataHandlerAttachment(aName, this.normalizedMessage.getAttachment(aName)));
        }
    }

    private boolean findJBINode(XMLStreamReader reader, String localName) throws Exception {
        while (reader.hasNext()) {
            if (this.isJBINode(reader, localName)) {
                return true;
            }
            reader.next();
        }
        return false;
    }

    private boolean isJBINode(Node node, String localName) {
        return "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equalsIgnoreCase(node.getNamespaceURI()) && localName.equalsIgnoreCase(node.getLocalName());
    }

    private boolean isJBINode(XMLStreamReader reader, String localName) {
        if (reader.getEventType() != 1) {
            return false;
        }
        return "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper".equalsIgnoreCase(reader.getNamespaceURI()) && localName.equalsIgnoreCase(reader.getLocalName());
    }

    public Node getOwnerDocument(Node n) {
        Document ownerDocument = n.getOwnerDocument();
        return ownerDocument != null ? ownerDocument : n;
    }

    private void unWrapFault() throws Exception {
        Node n;
        Source s = this.nmContent;
        if (s instanceof DOMSource) {
            n = ((DOMSource)s).getNode();
        } else {
            Transformer t = TF.newTransformer();
            DOMResult result = new DOMResult();
            t.transform(s, result);
            n = result.getNode();
        }
        Document d = n instanceof Document ? (Document)n : n.getOwnerDocument();
        NodeList nl = d.getElementsByTagNameNS("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", "part");
        Node jbiPart = nl != null && nl.getLength() > 0 ? nl.item(0).getFirstChild() : d.getFirstChild();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriter writer = XOF.createXMLStreamWriter(baos);
        writer.writeStartDocument();
        writer.writeStartElement("Soap:Fault");
        writer.writeAttribute("xmlns:Soap", "http://schemas.xmlsoap.org/soap/envelope/");
        String faultCode = jbiPart == null ? "Server" : "Client";
        String faultString = "Exception";
        writer.writeStartElement("faultcode");
        writer.writeCharacters("Soap:" + faultCode);
        writer.writeEndElement();
        writer.writeStartElement("faultstring");
        writer.writeCharacters(faultString);
        writer.writeEndElement();
        writer.writeStartElement("detail");
        if (jbiPart != null) {
            DOMUtil.UTIL.writeNode(jbiPart, writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        this.setPayLoad(baos.toByteArray());
        this.printPayLoad("\n\nUnwrapped fault = " + baos.toString());
    }

    public void setPayLoad(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        this.payLoadAsStreamReader = XIF.createXMLStreamReader(bais);
        this.payLoadAsStreamReader.next();
        this.payLoadAsSource = new StAXSource(this.payLoadAsStreamReader, true);
        this.payloadLocalName = this.payLoadAsStreamReader.getLocalName();
        this.payloadNamespaceURI = this.payLoadAsStreamReader.getNamespaceURI();
    }

    class RPCStyleUnWrapper {
        RPCStyleUnWrapper() {
        }

        void unwrap() throws Exception {
            if (UnWrappedMessage.this.nmContent instanceof DOMSource) {
                Node n = ((DOMSource)UnWrappedMessage.this.nmContent).getNode();
                this.unwrap(UnWrappedMessage.this.getOwnerDocument(n));
            } else if (UnWrappedMessage.this.nmContent instanceof StreamSource) {
                XMLStreamReader reader = JBIConstants.XIF.createXMLStreamReader(((StreamSource)UnWrappedMessage.this.nmContent).getInputStream());
                this.unwrap(reader);
            } else if (UnWrappedMessage.this.nmContent instanceof SAXSource) {
                InputSource source = ((SAXSource)UnWrappedMessage.this.nmContent).getInputSource();
                XMLStreamReader reader = source.getCharacterStream() != null ? JBIConstants.XIF.createXMLStreamReader(source.getCharacterStream()) : JBIConstants.XIF.createXMLStreamReader(source.getByteStream());
                this.unwrap(reader);
            } else {
                logger.log(Level.WARNING, "UnWrappedMessage :: Transforming the input message to DOM");
                Transformer t = JBIConstants.TF.newTransformer();
                DOMResult result = new DOMResult();
                t.transform(UnWrappedMessage.this.nmContent, result);
                this.unwrap(UnWrappedMessage.this.getOwnerDocument(result.getNode()));
            }
        }

        private void unwrap(Object wrappedDocument) {
            String methodSig = "UnWrappedMessage$RPCStyleUnwrapper :: unwrap(Object, String, String, ServiceEngineEndpoint) : ";
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter writer = JBIConstants.XOF.createXMLStreamWriter(baos, "UTF-8");
                writer.writeStartElement("ns208:" + UnWrappedMessage.this.wsdlMessageType.getLocalPart());
                writer.writeAttribute("xmlns:ns208", UnWrappedMessage.this.wsdlMessageType.getNamespaceURI());
                if (wrappedDocument instanceof Node) {
                    this.writeJBIParts((Node)wrappedDocument, writer);
                } else if (wrappedDocument instanceof XMLStreamReader) {
                    this.writeJBIParts((XMLStreamReader)wrappedDocument, writer);
                }
                writer.writeEndElement();
                writer.flush();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                UnWrappedMessage.this.payLoadAsBaos = baos;
                UnWrappedMessage.this.payloadLocalName = UnWrappedMessage.this.wsdlMessageType.getLocalPart();
                UnWrappedMessage.this.payloadNamespaceURI = UnWrappedMessage.this.wsdlMessageType.getNamespaceURI();
                UnWrappedMessage.this.payLoadAsStreamReader = JBIConstants.XIF.createXMLStreamReader(bais);
                UnWrappedMessage.this.payLoadAsStreamReader.next();
                UnWrappedMessage.this.payLoadAsSource = new StAXSource(UnWrappedMessage.this.payLoadAsStreamReader, true);
                UnWrappedMessage.this.printPayLoad("Unwrapped message = " + baos.toString());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }

        private boolean isSimpleType(Part part) {
            String s;
            QName parttype = part.getTypeName();
            return parttype != null && (s = parttype.getNamespaceURI()) != null && s.trim().equals("http://www.w3.org/2001/XMLSchema");
        }

        private void writeJBIParts(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
            long startTime = System.currentTimeMillis();
            if (!UnWrappedMessage.this.findJBINode(reader, "message")) {
                logger.log(Level.SEVERE, "Received message is not <jbi:message>");
                return;
            }
            block5: for (int k = 0; k < UnWrappedMessage.this.wsdlPartBindings.length; ++k) {
                switch (UnWrappedMessage.this.wsdlPartBindings[k]) {
                    case 1: {
                        if (!UnWrappedMessage.this.findJBINode(reader, "part")) {
                            logger.log(Level.SEVERE, "Required <jbi:part> is not found in the received message");
                            continue block5;
                        }
                        reader.next();
                        if (UnWrappedMessage.this.log) {
                            logger.log(Level.FINE, "Adding part number " + k + " to header");
                        }
                        UnWrappedMessage.this.addHeader(reader);
                        continue block5;
                    }
                    case 0: {
                        if (!UnWrappedMessage.this.findJBINode(reader, "part")) {
                            logger.log(Level.SEVERE, "Required <jbi:part> is not found in the received message");
                            continue block5;
                        }
                        if (UnWrappedMessage.this.log) {
                            logger.log(Level.FINE, "Adding part number " + k + " to payload");
                        }
                        Part part = UnWrappedMessage.this.wsdlOrderedParts.get(k);
                        writer.writeStartElement(part.getName());
                        DOMUtil.UTIL.writeChildren(reader, writer);
                        writer.writeEndElement();
                        continue block5;
                    }
                    case 2: {
                        if (!UnWrappedMessage.this.log) continue block5;
                        logger.log(Level.FINE, "Part number " + k + " is an attachment");
                    }
                }
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            if (UnWrappedMessage.this.log) {
                logger.log(Level.FINE, "TimeTaken to write JBI parts to payload = " + timeTaken);
            }
        }

        private void writeJBIParts(Node wrappedDocument, XMLStreamWriter writer) throws Exception {
            NodeList jbiMessages = wrappedDocument.getChildNodes();
            long startTime = System.currentTimeMillis();
            for (int i = 0; i < jbiMessages.getLength(); ++i) {
                Node jbiMessage = jbiMessages.item(i);
                if (!UnWrappedMessage.this.isJBINode(jbiMessage, "message")) continue;
                NodeList jbiParts = jbiMessage.getChildNodes();
                int k = 0;
                for (int j = 0; j < jbiParts.getLength(); ++j) {
                    Node jbiPart = jbiParts.item(j);
                    if (!UnWrappedMessage.this.isJBINode(jbiPart, "part")) continue;
                    switch (UnWrappedMessage.this.wsdlPartBindings[k]) {
                        case 1: {
                            if (UnWrappedMessage.this.log) {
                                logger.log(Level.FINE, "Adding part number " + k + " as header");
                            }
                            UnWrappedMessage.this.addHeader(jbiPart.getFirstChild());
                            break;
                        }
                        case 0: {
                            if (UnWrappedMessage.this.log) {
                                logger.log(Level.FINE, "Adding part number " + k + " to payload");
                            }
                            Part part = UnWrappedMessage.this.wsdlOrderedParts.get(k);
                            writer.writeStartElement(part.getName());
                            DOMUtil.UTIL.writeChildren(writer, jbiPart);
                            writer.writeEndElement();
                            break;
                        }
                        case 2: {
                            if (UnWrappedMessage.this.log) {
                                logger.log(Level.FINE, "Part number " + k + " is an attachment");
                            }
                            --j;
                        }
                    }
                    ++k;
                }
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            if (UnWrappedMessage.this.log) {
                logger.log(Level.FINE, "TimeTaken to write JBI parts to payload = " + timeTaken);
            }
        }
    }

    class DocumentStyleUnWrapper {
        DocumentStyleUnWrapper() {
        }

        void unwrap() throws Exception {
            if (UnWrappedMessage.this.nmContent instanceof DOMSource) {
                Node n = ((DOMSource)UnWrappedMessage.this.nmContent).getNode();
                this.unwrap(UnWrappedMessage.this.getOwnerDocument(n));
            } else if (UnWrappedMessage.this.nmContent instanceof StreamSource) {
                XMLStreamReader reader = JBIConstants.XIF.createXMLStreamReader(((StreamSource)UnWrappedMessage.this.nmContent).getInputStream());
                this.unwrap(reader);
            } else if (UnWrappedMessage.this.nmContent instanceof SAXSource) {
                InputSource source = ((SAXSource)UnWrappedMessage.this.nmContent).getInputSource();
                XMLStreamReader reader = source.getCharacterStream() != null ? JBIConstants.XIF.createXMLStreamReader(source.getCharacterStream()) : JBIConstants.XIF.createXMLStreamReader(source.getByteStream());
                this.unwrap(reader);
            } else {
                logger.log(Level.WARNING, "UnWrappedMessage :: Transforming the input message to DOM");
                Transformer t = JBIConstants.TF.newTransformer();
                DOMResult result = new DOMResult();
                t.transform(UnWrappedMessage.this.nmContent, result);
                this.unwrap(UnWrappedMessage.this.getOwnerDocument(result.getNode()));
            }
        }

        private void unwrap(Node n) {
            try {
                if (n.getNodeType() == 9) {
                    n = n.getFirstChild();
                }
                if (UnWrappedMessage.this.isJBINode(n, "message")) {
                    NodeList nl = n.getChildNodes();
                    int i = 0;
                    int partIndex = 0;
                    while (i < UnWrappedMessage.this.wsdlPartBindings.length) {
                        Node partValue = nl.item(partIndex).getFirstChild();
                        switch (UnWrappedMessage.this.wsdlPartBindings[i]) {
                            case 0: {
                                if (UnWrappedMessage.this.log) {
                                    logger.log(Level.FINE, "Setting part number " + i + " as payload");
                                }
                                UnWrappedMessage.this.setPayLoad(partValue);
                                break;
                            }
                            case 1: {
                                if (UnWrappedMessage.this.log) {
                                    logger.log(Level.FINE, "Adding part number " + i + " to header");
                                }
                                UnWrappedMessage.this.addHeader(partValue);
                                break;
                            }
                            case 2: {
                                if (UnWrappedMessage.this.log) {
                                    logger.log(Level.FINE, "Part number " + i + " is an attachment");
                                }
                                --partIndex;
                            }
                        }
                        ++i;
                        ++partIndex;
                    }
                } else {
                    logger.log(Level.SEVERE, "Received message is not <jbi:message>");
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }

        private void unwrap(XMLStreamReader reader) {
            String methodSig = "UnWrappedMessage$DocumentStyleUnwrapper :: unwrap(XMLStreamReader, QName) : ";
            try {
                if (!UnWrappedMessage.this.findJBINode(reader, "message")) {
                    logger.log(Level.SEVERE, "Received message is not <jbi:message>");
                    return;
                }
                block7: for (int i = 0; i < UnWrappedMessage.this.wsdlPartBindings.length; ++i) {
                    switch (UnWrappedMessage.this.wsdlPartBindings[i]) {
                        case 0: {
                            if (!UnWrappedMessage.this.findJBINode(reader, "part")) {
                                logger.log(Level.SEVERE, "Required <jbi:part> is not found in the received message");
                                continue block7;
                            }
                            reader.next();
                            if (UnWrappedMessage.this.wsdlPartBindings.length == 1) {
                                if (UnWrappedMessage.this.log) {
                                    logger.log(Level.FINE, "Setting part number " + i + " as payload");
                                }
                                UnWrappedMessage.this.setPayLoad(reader);
                                continue block7;
                            }
                            if (UnWrappedMessage.this.log) {
                                logger.log(Level.FINE, "Copying part number " + i + " to payload");
                            }
                            UnWrappedMessage.this.copyPayLoad(reader);
                            continue block7;
                        }
                        case 1: {
                            if (!UnWrappedMessage.this.findJBINode(reader, "part")) {
                                logger.log(Level.SEVERE, "Required <jbi:part> is not found in the received message");
                                continue block7;
                            }
                            reader.next();
                            if (UnWrappedMessage.this.log) {
                                logger.log(Level.FINE, "Adding part number " + i + " to header");
                            }
                            UnWrappedMessage.this.addHeader(reader);
                            continue block7;
                        }
                        case 2: {
                            if (!UnWrappedMessage.this.log) continue block7;
                            logger.log(Level.FINE, "Part number " + i + " is an attachment");
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }
}

