/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.http.impl;

import com.sun.jbi.httpsoapbc.security.am.impl.SunAccessManagerCredentialValidator;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.EndpointSecurityConfig;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.api.HttpBcSecurityException;
import com.sun.jbi.httpsoapbc.security.api.SecurityContextHandler;
import com.sun.jbi.httpsoapbc.security.impl.UserPrincipal;
import com.sun.jbi.httpsoapbc.security.util.api.Base64;
import com.sun.jbi.httpsoapbc.security.util.impl.Base64Impl;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPMessage;

public class HTTPSecurityContextHandler
implements SecurityContextHandler {
    private static final Messages mMessages = Messages.getMessages(HTTPSecurityContextHandler.class);
    private static final Logger mLog = Messages.getLogger(HTTPSecurityContextHandler.class);
    private Base64 base64 = new Base64Impl();
    private EndpointSecurityConfig securityConfig;
    private SunAccessManagerCredentialValidator sunAMValidator;

    public HTTPSecurityContextHandler(EndpointSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public void secureMessage(SOAPMessage soapMsg, Subject subject) throws HttpBcSecurityException {
        String username = this.securityConfig.getConfigProperty("http.basic.auth.username");
        String password = this.securityConfig.getConfigProperty("http.basic.auth.password");
        if (username != null && password != null) {
            String basic = new StringBuffer(username).append(':').append(password).toString();
            String authorization = new StringBuffer("Basic ").append(this.base64.encode(basic)).toString();
            soapMsg.getMimeHeaders().setHeader("Authorization", authorization);
        }
    }

    public void validateMessage(String authorizationHeader, Subject subject, HTTPBasicAuthCredential bacredential) throws HttpBcSecurityException {
        Object authorization = null;
        String decoded = "";
        if (authorizationHeader == null) {
            throw new HttpBcSecurityException(mMessages.getString("HTTPBC-E01023.NoAuthorizationHeader"));
        }
        if (!authorizationHeader.startsWith("Basic")) {
            throw new HttpBcSecurityException(mMessages.getString("HTTPBC-E01024.BasicAuthorizationHeaderRequired", authorization));
        }
        authorizationHeader = authorizationHeader.trim();
        try {
            decoded = this.base64.decode(authorizationHeader.substring(5).trim());
        }
        catch (Exception e) {
            throw new HttpBcSecurityException("Unable to decode the authorization string");
        }
        String username = null;
        String password = null;
        String[] credentials = decoded.split(":");
        if (credentials.length != 2) {
            throw new HttpBcSecurityException(mMessages.getString("HTTPSecurityContextHandler.InvalidAuthorizationHeader", (Object)authorizationHeader));
        }
        username = credentials[0];
        password = credentials[1];
        try {
            if (bacredential != null) {
                if (!bacredential.getName().equals(username) || !String.valueOf(bacredential.getPassword()).equals(password)) {
                    throw new HttpBcSecurityException("Invalid username and password");
                }
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Successfully authenticated user:" + username);
                }
                UserPrincipal userPrincipal = new UserPrincipal(username);
                HTTPBasicAuthCredential httpAuthCredential = new HTTPBasicAuthCredential(username, password.toCharArray());
                subject.getPrincipals().add(userPrincipal);
                subject.getPrivateCredentials().add(httpAuthCredential);
                return;
            }
            if (this.sunAMValidator != null) {
                subject = this.sunAMValidator.validateCredential(username, password.toCharArray());
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Successfully authenticated user:" + username);
                }
                return;
            }
        }
        catch (CredentialValidationException e) {
            throw new HttpBcSecurityException(e);
        }
    }
}

