/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.descriptor;

import com.sun.jbi.common.descriptor.JbiDescriptor;
import com.sun.jbi.common.descriptor.ServiceAssembly;
import com.sun.jbi.common.descriptor.parsers.AssemblyUnitParser;
import com.sun.jbi.common.descriptor.parsers.ConnectionParser;
import com.sun.jbi.common.descriptor.parsers.IdentificationParser;
import com.sun.jbi.common.descriptor.parsers.ServiceAssemblyParser;
import com.sun.jbi.common.util.I18n;
import com.sun.jbi.common.xml.StackableParser;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceAssemblyDescriptor
extends JbiDescriptor {
    private static SAXParserFactory mFactory = SAXParserFactory.newInstance();
    private static Logger mLogger = Logger.getLogger(ServiceAssemblyDescriptor.class.getName());

    public static ServiceAssembly parse(InputSource source) throws DeploymentException {
        try {
            StackableParser root = StackableParser.createRootParser();
            ServiceAssemblyParser saParser = new ServiceAssemblyParser();
            root.declareStackableParser(saParser, "http://java.sun.com/xml/ns/jbi", "service-assembly");
            root.declareStackableParser(new AssemblyUnitParser(), "http://java.sun.com/xml/ns/jbi", "service-unit", "target", "artifacts-zip", "component-name");
            ConnectionParser connParser = new ConnectionParser();
            root.declareStackableParser(connParser, "http://java.sun.com/xml/ns/jbi", "connection", "consumer", "provider");
            root.declareStackableParser(new IdentificationParser(), "http://java.sun.com/xml/ns/jbi", "identification", "name", "description");
            SAXParser parser = mFactory.newSAXParser();
            parser.parse(source, (DefaultHandler)root);
            return new ServiceAssembly(saParser.getIdentification(), saParser.getServiceUnits(), connParser.getConnections());
        }
        catch (ParserConfigurationException pce) {
            throw ServiceAssemblyDescriptor.error(I18n.loc("UTIL-6001: Failed to obtain SAX parser: {0}", pce.getMessage()), pce);
        }
        catch (SAXException se) {
            throw ServiceAssemblyDescriptor.error(I18n.loc("UTIL-6002: ailed to parse service unit descriptor: {0}", se.getMessage()), se);
        }
        catch (IOException ioe) {
            throw ServiceAssemblyDescriptor.error(I18n.loc("UTIL-6003: Unexpected I/O error parsing service unit descriptor: {0}", ioe.getMessage()), ioe);
        }
    }

    private static DeploymentException error(String message, Exception thrown) {
        if (thrown == null) {
            mLogger.warning(message);
            return new DeploymentException(message);
        }
        mLogger.log(Level.WARNING, message, thrown);
        return new DeploymentException(message, (Throwable)thrown);
    }
}

