/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.auth.login;

import com.sun.jbi.httpsoapbc.security.am.impl.SunAccessManagerCredentialValidator;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.HTTPBasicAuthCredential;
import com.sun.jbi.httpsoapbc.security.impl.UserPrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPAuthLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean loginSuccess;
    private boolean commitSuccess;
    private String name;
    private char[] pwd;
    private UserPrincipal userPrincipal;
    private HTTPBasicAuthCredential httpAuthCredential;
    private SunAccessManagerCredentialValidator credentialValidator;

    @Override
    public boolean abort() throws LoginException {
        if (this.commitSuccess) {
            this.logout();
        } else if (this.loginSuccess) {
            this.cleanLoginState();
            this.loginSuccess = false;
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.loginSuccess) {
            this.cleanLoginState();
            return false;
        }
        this.userPrincipal = new UserPrincipal(this.name);
        this.httpAuthCredential = new HTTPBasicAuthCredential(this.name, this.pwd);
        this.subject.getPrincipals().add(this.userPrincipal);
        this.subject.getPrivateCredentials().add(this.httpAuthCredential);
        this.commitSuccess = true;
        this.cleanLoginState();
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = handler;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.credentialValidator == null) {
            throw new LoginException("NoCredentialValidator");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("NoCallbackHandler");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Enter username: "), new PasswordCallback("Enter Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage());
        }
        String name = ((NameCallback)callbacks[0]).getName();
        char[] pwd = ((PasswordCallback)callbacks[1]).getPassword();
        try {
            this.credentialValidator.validateCredential(name, pwd);
        }
        catch (CredentialValidationException e) {
            throw new LoginException(e.getMessage());
        }
        this.loginSuccess = true;
        this.name = name;
        this.pwd = pwd;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.subject.getPrivateCredentials().remove(this.httpAuthCredential);
        this.userPrincipal = null;
        this.httpAuthCredential = null;
        this.cleanLoginState();
        this.loginSuccess = false;
        this.commitSuccess = false;
        return true;
    }

    private void cleanLoginState() {
        this.name = null;
        for (int i = 0; i < this.pwd.length; ++i) {
            this.pwd[i] = 32;
        }
    }
}

