/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator;

import com.ibm.wsdl.extensions.http.HTTPConstants;
import com.ibm.wsdl.extensions.soap.SOAPConstants;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.validator.httpvalidators.HttpAddressValidator;
import com.sun.jbi.httpsoapbc.validator.httpvalidators.HttpBindingValidator;
import com.sun.jbi.httpsoapbc.validator.httpvalidators.HttpOperationValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapAddressValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapBindingValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapBodyValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapFaultValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapHeaderValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapOperationValidator;
import com.sun.jbi.wsdlvalidator.Validator;
import com.sun.jbi.wsdlvalidator.ValidatorRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Port;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;

public class HttpSoapValidatorRegistry
implements ValidatorRegistry {
    protected Map mValidatorReg;
    protected RuntimeConfigurationMBean mRuntimeConfig;
    protected boolean mResolveTokens = false;

    public HttpSoapValidatorRegistry(RuntimeConfigurationMBean runtimeConfig, boolean resolveTokens) {
        this.mRuntimeConfig = runtimeConfig;
        this.mResolveTokens = resolveTokens;
        this.mValidatorReg = new HashMap();
        this.registerHttpSoapValidators();
        this.registerHttpValidators();
    }

    protected void registerHttpSoapValidators() {
        HttpSoapAddressValidator soapAddressValidator = new HttpSoapAddressValidator(this.mRuntimeConfig, this.mResolveTokens);
        this.registerValidator(Port.class, SOAPConstants.Q_ELEM_SOAP_ADDRESS, soapAddressValidator);
        HttpSoapBindingValidator soapBindingValidator = new HttpSoapBindingValidator();
        this.registerValidator(Binding.class, SOAPConstants.Q_ELEM_SOAP_BINDING, soapBindingValidator);
        HttpSoapHeaderValidator soapHeaderValidator = new HttpSoapHeaderValidator();
        this.registerValidator(BindingInput.class, SOAPConstants.Q_ELEM_SOAP_HEADER, soapHeaderValidator);
        this.registerValidator(BindingOutput.class, SOAPConstants.Q_ELEM_SOAP_HEADER, soapHeaderValidator);
        HttpSoapBodyValidator soapBodyValidator = new HttpSoapBodyValidator();
        this.registerValidator(BindingInput.class, SOAPConstants.Q_ELEM_SOAP_BODY, soapBodyValidator);
        this.registerValidator(BindingOutput.class, SOAPConstants.Q_ELEM_SOAP_BODY, soapBodyValidator);
        this.registerValidator(MIMEPart.class, SOAPConstants.Q_ELEM_SOAP_BODY, soapBodyValidator);
        HttpSoapFaultValidator soapFaultValidator = new HttpSoapFaultValidator();
        this.registerValidator(BindingFault.class, SOAPConstants.Q_ELEM_SOAP_FAULT, soapFaultValidator);
        HttpSoapOperationValidator soapOperationValidator = new HttpSoapOperationValidator();
        this.registerValidator(BindingOperation.class, SOAPConstants.Q_ELEM_SOAP_OPERATION, soapOperationValidator);
        soapHeaderValidator.attachObserver(soapBodyValidator);
        soapBodyValidator.attachObserver(soapHeaderValidator);
        soapHeaderValidator.getHeaderFaultValidator().attachObserver(soapBodyValidator);
        soapBodyValidator.attachObserver(soapHeaderValidator.getHeaderFaultValidator());
    }

    protected void registerHttpValidators() {
        HttpBindingValidator httpBindingValidator = new HttpBindingValidator();
        this.registerValidator(Binding.class, HTTPConstants.Q_ELEM_HTTP_BINDING, httpBindingValidator);
        HttpOperationValidator httpOperationValidator = new HttpOperationValidator();
        this.registerValidator(BindingOperation.class, HTTPConstants.Q_ELEM_HTTP_OPERATION, httpOperationValidator);
        HttpAddressValidator httpAddressValidator = new HttpAddressValidator(this.mRuntimeConfig, this.mResolveTokens);
        this.registerValidator(Port.class, HTTPConstants.Q_ELEM_HTTP_ADDRESS, httpAddressValidator);
    }

    public void registerValidator(Class parentType, QName elementType, Validator validator) {
        HashMap<QName, Validator> innerValidatorReg = (HashMap<QName, Validator>)this.mValidatorReg.get(parentType);
        if (innerValidatorReg == null) {
            innerValidatorReg = new HashMap<QName, Validator>();
            this.mValidatorReg.put(parentType, innerValidatorReg);
        }
        innerValidatorReg.put(elementType, validator);
    }

    public Validator queryValidator(Class parentType, QName elementType) {
        Map innerValidatorReg = (Map)this.mValidatorReg.get(parentType);
        Validator validator = null;
        if (innerValidatorReg != null) {
            validator = (Validator)innerValidatorReg.get(elementType);
        }
        return validator;
    }
}

