/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.descriptor;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.descriptor.ServiceAssembly;
import com.sun.jbi.common.descriptor.ServiceAssemblyDescriptor;
import com.sun.jbi.common.descriptor.ServiceUnit;
import com.sun.jbi.common.descriptor.ServicesDescriptor;
import com.sun.jbi.common.descriptor.model.AssemblyUnit;
import com.sun.jbi.common.descriptor.model.Connection;
import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.ServiceQuality;
import com.sun.jbi.common.qos.descriptor.QosAssemblyDescriptor;
import com.sun.jbi.common.qos.descriptor.QosConfig;
import com.sun.jbi.common.util.Util;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.DeploymentServiceMBean;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentLookup {
    private ComponentContext mCtx;
    private Logger mLogger;

    public DeploymentLookup(ComponentContext ctx) {
        this.mCtx = ctx;
        this.mLogger = Util.getLogger((ComponentContext)this.mCtx, (String)DeploymentLookup.class.getName());
    }

    public ServiceAssembly getServiceAssembly(String serviceUnitName) throws DeploymentException {
        try {
            String[] saNames;
            DeploymentServiceMBean mbean = this.createMBean();
            if (mbean == null) {
                this.log().warning(I18n.loc("QOS-6058: Failed to acquire DeploymentService when fetching ServiceAssembly for service unit: {0}", serviceUnitName));
                return null;
            }
            for (String name : saNames = mbean.getDeployedServiceAssembliesForComponent(this.mCtx.getComponentName())) {
                AssemblyUnit[] units;
                String saXml = mbean.getServiceAssemblyDescriptor(name);
                ServiceAssembly sa = ServiceAssemblyDescriptor.parse((InputSource)new InputSource(new StringReader(saXml)));
                for (AssemblyUnit su : units = sa.getServiceUnits()) {
                    if (!serviceUnitName.equals(su.getId().getName())) continue;
                    return sa;
                }
            }
            return null;
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.deployError(e, "QOS-6052: Failed to acquire Service Assembly for Service Unit {0}: {1}", serviceUnitName, e.getMessage());
        }
    }

    public EndpointInfo[] getConsumersByProvider(EndpointInfo provider) throws DeploymentException {
        try {
            String[] saNames;
            if (provider == null) {
                throw new IllegalArgumentException(I18n.loc("QOS-6018: Provider endpoint cannot be NULL!", new Object[0]));
            }
            DeploymentServiceMBean mbean = this.createMBean();
            if (mbean == null) {
                this.log().warning(I18n.loc("QOS-6059: Failed to acquire DeploymentService when fetching consumers for provider: {0}", String.valueOf(provider)));
                return new EndpointInfo[0];
            }
            ArrayList<EndpointInfo> consumers = new ArrayList<EndpointInfo>();
            for (String name : saNames = mbean.getDeployedServiceAssembliesForComponent(this.mCtx.getComponentName())) {
                String saXml = mbean.getServiceAssemblyDescriptor(name);
                ServiceAssembly sa = ServiceAssemblyDescriptor.parse((InputSource)new InputSource(new StringReader(saXml)));
                Object[] cons = sa.getConnections();
                if (this.mLogger.isLoggable(Level.FINEST)) {
                    this.mLogger.finest("QOS-1001: Connections for SA: \n\t" + Util.toString((Object[])cons, (String)"\n\t"));
                }
                for (Object con : cons) {
                    if (!provider.equals((Object)con.getProvider())) continue;
                    consumers.add(con.getConsumer());
                }
            }
            Object[] endpts = new EndpointInfo[consumers.size()];
            consumers.toArray(endpts);
            if (this.mLogger.isLoggable(Level.FINEST)) {
                this.mLogger.finest("QOS-1002: Provider(" + String.valueOf(provider) + ") has Consumers: \n\t" + Util.toString((Object[])endpts, (String)"\n\t"));
            }
            return endpts;
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.deployError(e, "QOS-6051: Failed to acquire Consumers for {0} Provider {1}: {2}", this.getContext().getComponentName(), provider.getEndpointName(), e.getMessage());
        }
    }

    public Map<EndpointInfo, List<ServiceQuality>> lookupServiceQualities(String serviceUnitRootPath) throws DeploymentException {
        try {
            ServiceUnit suDesc = ServicesDescriptor.parse((String)"testSU", (String)serviceUnitRootPath);
            EndpointInfo[] consumes = suDesc.getServices().getConsumes();
            return this.lookupServiceQualities(consumes);
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.deployError(e, "QOS-6050: Failed to lookup {0} Service Qualities: {1}", this.getContext().getComponentName(), e.getMessage());
        }
    }

    public Map<EndpointInfo, List<ServiceQuality>> lookupServiceQualities(EndpointInfo ... consumers) throws DeploymentException {
        try {
            String[] saNames;
            ArrayList<EndpointInfo> list = new ArrayList<EndpointInfo>();
            for (EndpointInfo ei : consumers) {
                list.add(ei);
            }
            HashMap<EndpointInfo, List<ServiceQuality>> map = new HashMap<EndpointInfo, List<ServiceQuality>>();
            DeploymentServiceMBean mbean = this.createMBean();
            if (mbean == null) {
                this.log().warning(I18n.loc("QOS-6060: Failed to acquire DeploymentService when fetching service qualities!", new Object[0]));
                return map;
            }
            for (String sa : saNames = mbean.getDeployedServiceAssembliesForComponent(this.mCtx.getComponentName())) {
                String saDesc = mbean.getServiceAssemblyDescriptor(sa);
                QosConfig config = QosAssemblyDescriptor.parse(new InputSource(new StringReader(saDesc)));
                Map<EndpointInfo, List<ServiceQuality>> qos = config.getServiceQualities();
                Connection[] cons = config.getConnections();
                int index = -1;
                for (Connection con : cons) {
                    index = list.indexOf(con.getConsumer());
                    if (index < 0) continue;
                    map.put((EndpointInfo)list.remove(index), qos.get(con.getConsumer()));
                }
            }
            return map;
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw this.deployError(e, "QOS-6050: Failed to lookup {0} Service Qualities: {1}", this.getContext().getComponentName(), e.getMessage());
        }
    }

    protected DeploymentServiceMBean createMBean() throws DeploymentException {
        try {
            ObjectName objName = new ObjectName("*:ControlType=DeploymentService,ServiceName=DeploymentService,*");
            MBeanServer mbs = this.mCtx.getMBeanServer();
            Set<ObjectName> mbeans = mbs.queryNames(objName, null);
            if (mbeans == null || mbeans.isEmpty()) {
                return null;
            }
            objName = (ObjectName)mbeans.toArray()[0];
            DeploymentServiceMBean ds = MBeanServerInvocationHandler.newProxyInstance(mbs, objName, DeploymentServiceMBean.class, false);
            return ds;
        }
        catch (MalformedObjectNameException mone) {
            throw this.deployError(mone, "QOS-6049: Failed to create DeploymentServiceMBean for {0}: {1}", this.getContext().getComponentName(), mone.getMessage());
        }
    }

    protected ComponentContext getContext() {
        return this.mCtx;
    }

    protected Logger log() {
        return this.mLogger;
    }

    private DeploymentException deployError(Exception e, String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        if (e == null) {
            this.log().warning(err);
            return new DeploymentException(err);
        }
        this.log().log(Level.WARNING, err, e);
        return new DeploymentException(err, (Throwable)e);
    }
}

