/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.nms.wsdl11wrapper.impl;

import com.sun.jbi.nms.wsdl11wrapper.WrapperParser;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import com.sun.jbi.nms.wsdl11wrapper.impl.WSDLInfo;
import com.sun.jbi.nms.wsdl11wrapper.util.WrapperUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WrapperParserImpl
implements WrapperParser {
    QName messageType;
    String messageName;
    Map wrappedParts = new HashMap();
    List partsOrder;
    boolean wrapperDetected;

    public void parse(Document wrappedDoc, Definition wsdlDefinition) throws WrapperProcessingException {
        QName wrapperMessageType;
        this.wrapperDetected = WrapperUtil.isMessageWrapped(wrappedDoc);
        Message wsdlMessageDefinition = null;
        if (this.wrapperDetected && (wsdlMessageDefinition = wsdlDefinition.getMessage(wrapperMessageType = WrapperParserImpl.extractMessageType(wrappedDoc, wsdlDefinition))) == null) {
            throw new WrapperProcessingException("The WSDL definition provided does not contain a definition for the normalized message " + wrapperMessageType.toString());
        }
        this.parse(wrappedDoc, wsdlMessageDefinition);
    }

    public void parse(Document wrappedDoc, Message wsdlMessageDefinition) throws WrapperProcessingException {
        this.wrappedParts.clear();
        this.messageType = null;
        this.messageName = null;
        this.wrapperDetected = WrapperUtil.isMessageWrapped(wrappedDoc);
        if (this.wrapperDetected) {
            Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
            QName unresolvedMessageType = WrapperParserImpl.extractMessageType(wrappedDoc, null);
            QName passedInDefQName = wsdlMessageDefinition.getQName();
            if (!passedInDefQName.getLocalPart().equals(unresolvedMessageType.getLocalPart())) {
                throw new WrapperProcessingException("The WSDL message definition " + passedInDefQName.getLocalPart() + " does not match the name of the message wrapper of the normalized message (" + unresolvedMessageType.getLocalPart() + ")");
            }
            this.messageType = passedInDefQName;
            this.messageName = WrapperParserImpl.extractMessageName(wrappedDoc);
            WSDLInfo info = WSDLInfo.getInstance(wsdlMessageDefinition);
            this.partsOrder = info.getPartsOrder();
            NodeList childNodes = jbiMessageWrapper.getChildNodes();
            for (int childCount = 0; childCount < childNodes.getLength(); ++childCount) {
                Node currNode = childNodes.item(childCount);
                if (currNode.getNodeType() != 1) continue;
                Element jbiPartWrapper = (Element)currNode;
                int partPos = this.wrappedParts.size();
                if (partPos >= this.partsOrder.size()) {
                    throw new WrapperProcessingException("The normalized message contains more parts than are defined in the WSDL message definition");
                }
                String partName = (String)this.partsOrder.get(partPos);
                this.wrappedParts.put(partName, jbiPartWrapper);
            }
            if (this.partsOrder.size() > this.wrappedParts.size()) {
                throw new WrapperProcessingException("The normalized message contains less parts than are defined in the WSDL message definition");
            }
        }
    }

    public boolean hasPart(String partName) {
        return this.wrappedParts.containsKey(partName);
    }

    public NodeList getPartNodes(String partName) throws WrapperProcessingException {
        Element wrappedPart = (Element)this.wrappedParts.get(partName);
        if (wrappedPart == null) {
            throw new WrapperProcessingException("The parsed message does not contain part " + partName);
        }
        NodeList allElements = WrapperParserImpl.removeJBIPartWrapper(wrappedPart);
        return allElements;
    }

    public Element getWrappedPart(String partName) throws WrapperProcessingException {
        Element wrappedPart = (Element)this.wrappedParts.get(partName);
        if (wrappedPart == null) {
            throw new WrapperProcessingException("The parsed message does not contain part " + partName);
        }
        return wrappedPart;
    }

    public int getNoOfParts() {
        return this.wrappedParts.size();
    }

    public String[] getPartNames() {
        return this.partsOrder.toArray(new String[0]);
    }

    public static NodeList removeJBIPartWrapper(Element wrappedPart) {
        NodeList childNodes = wrappedPart.getChildNodes();
        return childNodes;
    }

    public QName getMessageType() throws WrapperProcessingException {
        return this.messageType;
    }

    public String getMessageName() throws WrapperProcessingException {
        return this.messageName;
    }

    public boolean isMessageWrapped() {
        return this.wrapperDetected;
    }

    public static QName extractMessageType(Document wrappedDoc, Definition wsdlDefinition) throws WrapperProcessingException {
        QName msgTypeQName = null;
        Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
        if (jbiMessageWrapper == null) {
            throw new WrapperProcessingException("Could not get the wrapper message type, no message wrapper element is defined.");
        }
        String msgType = jbiMessageWrapper.getAttribute("type");
        if (msgType == null || msgType.equals("")) {
            throw new WrapperProcessingException("Failed to obtain type from JBI Message Wrapper.");
        }
        int colonPos = msgType.indexOf(58);
        String localName = msgType;
        String prefix = null;
        String namespace = null;
        if (colonPos > -1) {
            prefix = msgType.substring(0, colonPos);
            localName = msgType.substring(colonPos + 1);
            if (prefix.equals("msgns")) {
                namespace = jbiMessageWrapper.getAttribute("xmlns:msgns");
            } else if (wsdlDefinition != null) {
                namespace = wsdlDefinition.getNamespace(prefix);
            }
        }
        msgTypeQName = prefix != null ? new QName(namespace, localName, prefix) : new QName(namespace, localName);
        return msgTypeQName;
    }

    public static String extractMessageName(Document wrappedDoc) throws WrapperProcessingException {
        String messageName = null;
        Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
        if (jbiMessageWrapper == null) {
            throw new WrapperProcessingException("Could not get the wrapper message name, no message wrapper element is defined.");
        }
        messageName = jbiMessageWrapper.getAttribute("name");
        return messageName;
    }
}

