/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.v10.impl;

import com.sun.jbi.httpsoapbc.validation.conf.wsi.api.ValidationResult;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.api.WSIValidationException;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api.SOAPMsgValidator;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api.SOAPStatementValidator;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.v10.impl.R1011Validator;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.v10.impl.R1013Validator;
import com.sun.jbi.internationalization.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPMessage;

public class BPv10SOAPMsgValidatorImpl
implements SOAPMsgValidator {
    private static final Messages messages = Messages.getMessages(BPv10SOAPMsgValidatorImpl.class);
    private List wsiBP10Validators;
    private List errors = new ArrayList();
    private List warnings = new ArrayList();
    private String errorMsg;
    private String warnMsg;
    private String level;

    public BPv10SOAPMsgValidatorImpl(String level) {
        this.wsiBP10Validators = new ArrayList(2);
        this.wsiBP10Validators.add(new R1011Validator(level));
        this.wsiBP10Validators.add(new R1013Validator(level));
        this.level = level;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public List getErrors() {
        return this.errors;
    }

    public String getWarningMsg() {
        return this.warnMsg;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void setValidationLevel(String level) {
        this.level = level;
        for (int i = 0; i < this.wsiBP10Validators.size(); ++i) {
            ((SOAPStatementValidator)this.wsiBP10Validators.get(i)).setValidationLevel(level);
        }
    }

    public String getValidationLevel() {
        return this.level;
    }

    public List getValidators() {
        return this.wsiBP10Validators;
    }

    public void validate(SOAPMessage msg) throws WSIValidationException {
        int i;
        this.errors.clear();
        this.warnings.clear();
        this.errorMsg = null;
        this.warnMsg = null;
        SOAPStatementValidator validator = null;
        ValidationResult result = null;
        String valLevel = null;
        for (int i2 = 0; i2 < this.wsiBP10Validators.size(); ++i2) {
            validator = (SOAPStatementValidator)this.wsiBP10Validators.get(i2);
            valLevel = validator.getValidationLevel();
            if (valLevel.equalsIgnoreCase("Ignore") || (result = validator.validate(msg)).getStatus()) continue;
            if (valLevel.equalsIgnoreCase("Error")) {
                this.errors.add(result);
                continue;
            }
            if (!valLevel.equalsIgnoreCase("Warn")) continue;
            this.warnings.add(result);
        }
        if (this.errors.size() > 0) {
            StringBuffer errorBuf = new StringBuffer(messages.getString("WSI_BP_10_Error"));
            for (i = 0; i < this.errors.size(); ++i) {
                errorBuf.append("\n").append(((ValidationResult)this.errors.get(i)).getErrorMsg());
            }
            this.errorMsg = errorBuf.toString();
        }
        if (this.warnings.size() > 0) {
            StringBuffer warnBuf = new StringBuffer(messages.getString("WSI_BP_10_Warning"));
            for (i = 0; i < this.warnings.size(); ++i) {
                warnBuf.append("\n").append(((ValidationResult)this.warnings.get(i)).getErrorMsg());
            }
            this.warnMsg = warnBuf.toString();
        }
    }
}

