/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.FaultException;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.embedded.HttpException;
import com.sun.jbi.httpsoapbc.embedded.JAXWSGrizzlyHttpConnection;
import com.sun.jbi.httpsoapbc.embedded.JBIGrizzlyAsyncFilter;
import com.sun.jbi.httpsoapbc.security.api.HttpBcSecurityException;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletDenormalizer;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletNormalizer;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.security.auth.Subject;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Connector;
import org.apache.catalina.Request;
import org.apache.coyote.Adapter;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class JAXWSGrizzlyRequestProcessor
implements Adapter {
    private static final Messages mMessages = Messages.getMessages(JAXWSGrizzlyRequestProcessor.class);
    private static final Logger mLogger = Messages.getLogger(JAXWSGrizzlyRequestProcessor.class);
    static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    Map exchangeIDToContext = new ConcurrentHashMap();
    HttpSoapBindingLifeCycle lifeCycle;
    private static ThreadLocal processorSupport = new ThreadLocal();

    public JAXWSGrizzlyRequestProcessor(CoyoteConnector connector) throws MessagingException {
        this.connector = connector;
        this.initialize();
    }

    void initialize() throws MessagingException {
        this.lifeCycle = (HttpSoapBindingLifeCycle)HttpSoapComponentContext.getInstance().getAssociatedLifeCycle();
    }

    public void service(org.apache.coyote.Request req, Response res) {
        AsyncTask asyncTask = JBIGrizzlyAsyncFilter.removeTaskMapping(req);
        if (mLogger.isLoggable(Level.FINEST)) {
            mLogger.log(Level.FINEST, "Got task mapping for request " + req.toString() + ", asyncProcessorTask " + asyncTask);
        }
        int port = this.connector.getPort();
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Service async request for: " + req.requestURI());
        }
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (mLogger.isLoggable(Level.FINEST)) {
            mLogger.log(Level.FINEST, "Initializing servicing objects");
        }
        request = (CoyoteRequest)this.connector.createRequest();
        request.setCoyoteRequest(req);
        response = (CoyoteResponse)this.connector.createResponse();
        response.setCoyoteResponse(res);
        request.setResponse((org.apache.catalina.Response)response);
        response.setRequest((Request)request);
        req.setNote(1, (Object)request);
        res.setNote(1, (Object)response);
        req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Query string encoding: " + this.connector.getURIEncoding());
        }
        Context currentContext = new Context();
        currentContext.port = port;
        currentContext.anInputBuffer = (InternalInputBuffer)req.getInputBuffer();
        currentContext.anOutputBuffer = (InternalOutputBuffer)res.getOutputBuffer();
        currentContext.req = req;
        currentContext.res = res;
        currentContext.coyoteRequest = request;
        currentContext.coyoteResponse = response;
        currentContext.connector = this.connector;
        currentContext.asyncTask = asyncTask;
        currentContext.contextPath = "";
        currentContext.pathInfo = req.requestURI().toString();
        String context = currentContext.contextPath + currentContext.pathInfo;
        if ("WSDL".equalsIgnoreCase(request.getQueryString())) {
            this.processSynchronousQueryResource(currentContext);
        } else if (context.toLowerCase().endsWith(".xsd") || context.toLowerCase().endsWith(".wsdl")) {
            this.processSynchronousQueryResource(currentContext);
        } else {
            try {
                this.processAsynchRequest(currentContext);
            }
            catch (Exception ex) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Exception reported in processing synchronous request-reply", ex);
                }
                this.processSynchronousReply(currentContext, ex);
            }
        }
    }

    public void afterService(org.apache.coyote.Request req, Response res) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSynchronousQueryResource(Context reqContext) {
        CoyoteResponse response = reqContext.coyoteResponse;
        try {
            CoyoteRequest request = reqContext.coyoteRequest;
            String context = reqContext.contextPath + reqContext.pathInfo;
            int port = reqContext.port;
            response.setContentType("text/xml");
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Request query string: " + request.getQueryString());
            }
            if ("WSDL".equalsIgnoreCase(request.getQueryString())) {
                Endpoint targetEndpoint = this.lifeCycle.getEndpointBeanForContext(context, port);
                if (targetEndpoint == null) {
                    response.setStatus(503);
                    return;
                }
                try {
                    ByteBuffer mbb = targetEndpoint.getServiceDescriptorAsByteBuffer();
                    ServletOutputStream os = response.getOutputStream();
                    WritableByteChannel channel = Channels.newChannel((OutputStream)os);
                    channel.write(mbb);
                    os.flush();
                    response.setStatus(200);
                }
                catch (Exception e) {
                    mLogger.log(Level.WARNING, "HTTPBC-W00651.WSDL_retrieval_exception", e);
                    response.setStatus(500);
                }
            } else {
                ByteBuffer resource = this.lifeCycle.queryResource(context, null);
                if (resource != null) {
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "Request context " + context + " at port " + reqContext.port + " mapped to resource " + resource);
                    }
                    ByteBuffer mbb = resource;
                    ServletOutputStream os = response.getOutputStream();
                    WritableByteChannel channel = Channels.newChannel((OutputStream)os);
                    channel.write(mbb);
                    os.flush();
                    response.setStatus(200);
                } else {
                    mLogger.log(Level.SEVERE, "HTTPBC-S00670.Resource_not_available", context);
                    response.setStatus(500);
                }
            }
        }
        catch (Throwable ex) {
            mLogger.log(Level.SEVERE, "HTTPBC-E00669.Exception_during_query", ex);
            int statusCode = 500;
            response.setStatus(statusCode);
        }
        finally {
            try {
                response.finishResponse();
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "HTTPBC-E00654.Exception_during_reply_processing", ex);
            }
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Wrote response");
            }
        }
        JBIGrizzlyAsyncFilter.finishResponseSynchronously(reqContext.asyncTask);
    }

    public void processAsynchRequest(Context reqContext) throws FaultException, HttpException {
        int port;
        Object exchangeID = null;
        CoyoteRequest request = reqContext.coyoteRequest;
        String context = reqContext.contextPath + reqContext.pathInfo;
        Endpoint targetEndpoint = this.lifeCycle.getEndpointBeanForContext(context, port = reqContext.port);
        if (targetEndpoint == null) {
            mLogger.log(Level.WARNING, "HTTPBC-W00652.Web_service_mapping_failed", new Object[]{context, new Integer(port)});
            throw new HttpException(404, mMessages.getString("HTTPBC-W00652.Web_service_mapping_failed", new Object[]{context, new Integer(port)}));
        }
        if (targetEndpoint.isInbound() && targetEndpoint.isBasicAuthenticationEnabled()) {
            String authHeader = request.getHeader("authorization");
            if (authHeader == null) {
                reqContext.coyoteResponse.setHeader("WWW-Authenticate", "Basic realm=\"ANY\"");
                reqContext.coyoteResponse.setStatus(401);
                throw new HttpException(401, "Unauthorized");
            }
            try {
                Subject subj = targetEndpoint.handleSecurity(authHeader);
            }
            catch (HttpBcSecurityException se) {
                mLogger.log(Level.WARNING, mMessages.getString("HTTPBC-E01036.Authentication_failed", new Object[]{se.getLocalizedMessage()}), se);
                reqContext.coyoteResponse.setStatus(403);
                throw new HttpException(403, "Forbidden");
            }
        }
        JAXWSGrizzlyHttpConnection con = new JAXWSGrizzlyHttpConnection(reqContext.req, reqContext.res, reqContext.coyoteRequest, reqContext.coyoteResponse, reqContext.asyncTask, this.connector.getSecure());
        WSEndpoint wsEndpoint = targetEndpoint.getWSEndpoint();
        HttpAdapter httpAdapter = HttpAdapter.createAlone((WSEndpoint)wsEndpoint);
        try {
            httpAdapter.invokeAsync((WSHTTPConnection)con);
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Completed async invoke");
            }
        }
        catch (IOException ex) {
            throw new FaultException(new MessagingException(mMessages.getString("HTTPBC-W00653.Exception_during_request_processing"), (Throwable)ex));
        }
    }

    public void processSynchronousReply(Context reqContext, Exception requestFailedException) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Replying synchronously.  The request failed. Here's the exception.", requestFailedException);
        }
        this.processAsynchReply(reqContext, requestFailedException);
        JBIGrizzlyAsyncFilter.finishResponseSynchronously(reqContext.asyncTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAsynchReply(Context reqContext, Exception requestFailedException) {
        CoyoteResponse response = reqContext.coyoteResponse;
        try {
            CoyoteRequest request = reqContext.coyoteRequest;
            response.setContentType("text/xml");
            if (requestFailedException != null) {
                if (requestFailedException instanceof HttpException) {
                    response.setStatus(((HttpException)requestFailedException).getErrorCode());
                } else {
                    Denormalizer aDenormalizer = this.getProcessorSupport().denormalizer;
                    response = (CoyoteResponse)aDenormalizer.denormalizeException(requestFailedException, response);
                    int statusCode = 500;
                    response.setStatus(statusCode);
                }
            }
        }
        catch (Throwable ex) {
            mLogger.log(Level.SEVERE, "HTTPBC-E00654.Exception_during_reply_processing", ex);
            int statusCode = 500;
            response.setStatus(statusCode);
        }
        finally {
            try {
                response.finishResponse();
            }
            catch (IOException ex) {
                mLogger.log(Level.SEVERE, "HTTPBC-E00654.Exception_during_reply_processing", ex);
            }
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Wrote response");
            }
        }
    }

    public void fireAdapterEvent(String type, Object data) {
        mLogger.log(Level.FINE, "Not supported by this implementation");
    }

    ProcessorSupport getProcessorSupport() throws MessagingException {
        ProcessorSupport currentProcSupport = (ProcessorSupport)processorSupport.get();
        if (currentProcSupport == null) {
            currentProcSupport = new ProcessorSupport();
            currentProcSupport.normalizer = new HttpServletNormalizer();
            currentProcSupport.denormalizer = new HttpServletDenormalizer();
            processorSupport.set(currentProcSupport);
        }
        return currentProcSupport;
    }

    public static class Context {
        int port;
        InternalInputBuffer anInputBuffer;
        InternalOutputBuffer anOutputBuffer;
        org.apache.coyote.Request req;
        Response res;
        CoyoteRequest coyoteRequest;
        CoyoteResponse coyoteResponse;
        Connector connector;
        String contextPath;
        String pathInfo;
        AsyncTask asyncTask;
    }

    static class ProcessorSupport {
        Normalizer normalizer;
        Denormalizer denormalizer;

        ProcessorSupport() {
        }
    }
}

