/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator;

import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.util.HttpUrlResolverUtil;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;

public abstract class AbstractValidator
implements Validator {
    private static final Messages mMessages = Messages.getMessages(AbstractValidator.class);
    protected static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    protected static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    protected RuntimeConfigurationMBean mRuntimeConfig;
    protected HttpUrlResolverUtil mUrlResolverUtil;
    protected Map mApplicationVariables;
    protected boolean mResolveTokens = false;

    public AbstractValidator() {
    }

    public AbstractValidator(RuntimeConfigurationMBean runtimeConfig, boolean resolveTokens) {
        this.mRuntimeConfig = runtimeConfig;
        this.mApplicationVariables = runtimeConfig.retrieveApplicationVariablesMap();
        this.mUrlResolverUtil = new HttpUrlResolverUtil(this.mApplicationVariables);
        this.mResolveTokens = resolveTokens;
    }

    public abstract void validate(ExtensibilityElement var1) throws ValidationException;

    protected boolean isAToken(String name) throws Exception {
        return HttpUrlResolverUtil.isAToken(name);
    }

    protected String resolveTokens(String url) throws Exception {
        return this.mUrlResolverUtil.resolveEmbeddedTokens(url);
    }

    protected String resolveEmbeddedTokens(String aString) throws Exception {
        return this.mUrlResolverUtil.resolveEmbeddedTokens(aString);
    }

    protected String resolveEmbeddedTokensInURL(String aString) throws Exception {
        return this.mUrlResolverUtil.resolveEmbeddedTokensInURL(aString, this.mRuntimeConfig.getHttpDefaultPort(), this.mRuntimeConfig.getHttpsDefaultPort());
    }

    protected String resolveHostNameInUrl(String aLocation) throws Exception {
        return this.mUrlResolverUtil.resolveHostNameInUrl(aLocation);
    }

    protected void validateLocationURI(String aLocation) throws Exception {
        this.mUrlResolverUtil.validateLocationURI(aLocation);
    }

    protected void updateAppVariableMap(String aString, String type) throws Exception {
        HttpUrlResolverUtil.TokenData tokenData = this.mUrlResolverUtil.findNextToken(aString, 0);
        if (tokenData == null) {
            return;
        }
        while (tokenData != null) {
            String tokenName = tokenData.getTokenName();
            String appVariableName = this.mUrlResolverUtil.getApplicationVariableName(tokenName);
            if (!(tokenName.equals(HTTP_DEFAULT_PORT_TOKEN) || tokenName.equals(HTTPS_DEFAULT_PORT_TOKEN) || this.mApplicationVariables.containsKey(appVariableName))) {
                String[] metadata = new String[]{null, type};
                this.mApplicationVariables.put(appVariableName, metadata);
            }
            if (tokenData.getEndIndex() >= aString.length()) break;
            tokenData = this.mUrlResolverUtil.findNextToken(aString, tokenData.getEndIndex());
        }
    }
}

