/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.istack.NotNull;
import com.sun.jbi.httpsoapbc.embedded.JBIGrizzlyAsyncFilter;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXWSGrizzlyHttpConnection
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private static final Messages mMessages = Messages.getMessages(JAXWSGrizzlyHttpConnection.class);
    private static final Logger mLogger = Messages.getLogger(JAXWSGrizzlyHttpConnection.class);
    private Request req;
    private Response res;
    private CoyoteRequest coyoteRequest;
    private CoyoteResponse coyoteResponse;
    private int status;
    private int responseContentLength = 0;
    private boolean outputWritten;
    private boolean isSecure;
    private AsyncTask grizzlyAsyncTask;
    private static final PropertySet.PropertyMap model = JAXWSGrizzlyHttpConnection.parse(JAXWSGrizzlyHttpConnection.class);

    public JAXWSGrizzlyHttpConnection(@NotNull Request request, @NotNull Response response, @NotNull CoyoteRequest coyoteRequest, @NotNull CoyoteResponse coyoteResponse, AsyncTask grizzlyAsyncTask, boolean isSecure) {
        this.req = request;
        this.res = response;
        this.coyoteRequest = coyoteRequest;
        this.coyoteResponse = coyoteResponse;
        this.grizzlyAsyncTask = grizzlyAsyncTask;
        this.isSecure = isSecure;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        MimeHeaders mimeHeaders = this.req.getMimeHeaders();
        Map<String, List<String>> jaxWSHeaders = this.convertHeaders(mimeHeaders);
        return jaxWSHeaders;
    }

    public String getRequestHeader(String headerName) {
        return this.req.getHeader(headerName);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                if (values.size() == 1) {
                    this.res.setHeader(key, values.get(1));
                    continue;
                }
                StringBuffer concat = new StringBuffer();
                boolean firstTime = true;
                for (String aValue : values) {
                    if (!firstTime) {
                        concat.append(',');
                    }
                    concat.append(aValue);
                    firstTime = false;
                }
                this.res.setHeader(key, concat.toString());
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        MimeHeaders mimeHeaders = this.res.getMimeHeaders();
        Map<String, List<String>> jaxWSHeaders = this.convertHeaders(mimeHeaders);
        return jaxWSHeaders;
    }

    public void setContentTypeResponseHeader(@NotNull String value) {
        this.res.setHeader("Content-Type", value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    @NotNull
    public InputStream getInput() throws IOException {
        return this.coyoteRequest.getInputStream();
    }

    @NotNull
    public OutputStream getOutput() throws IOException {
        assert (!this.outputWritten);
        this.outputWritten = true;
        this.res.setStatus(this.getStatus());
        return this.coyoteResponse.getOutputStream();
    }

    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    public Principal getUserPrincipal(Packet request) {
        return this.coyoteRequest.getUserPrincipal();
    }

    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    @NotNull
    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        return this.coyoteRequest.getRequestURL().toString();
    }

    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        String eprAddress = this.getEPRAddress(request, endpoint);
        String wsdlAddress = eprAddress + "?wsdl";
        return wsdlAddress;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.coyoteRequest.getMethod();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.coyoteRequest.getQueryString();
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return this.coyoteRequest.getRequestURI();
    }

    public void close() {
        this.finishGrizzlyResponse();
        super.close();
    }

    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    void finishGrizzlyResponse() {
        if (this.grizzlyAsyncTask != null) {
            JBIGrizzlyAsyncFilter.finishResponse(this.grizzlyAsyncTask);
            this.grizzlyAsyncTask = null;
        }
    }

    Map<String, List<String>> convertHeaders(MimeHeaders mimeHeaders) {
        HashMap<String, List<String>> jaxWSHeaders = new HashMap<String, List<String>>();
        Enumeration names = mimeHeaders.names();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList<String> jaxWSHeaderValues = new ArrayList<String>();
            Enumeration values = mimeHeaders.values(name);
            while (values.hasMoreElements()) {
                String aValue = (String)values.nextElement();
                jaxWSHeaderValues.add(aValue);
            }
            jaxWSHeaders.put(name, jaxWSHeaderValues);
        }
        return jaxWSHeaders;
    }
}

