/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.bootstrap;

import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.ConfigPersistence;
import com.sun.jbi.httpsoapbc.bootstrap.InstallerExt;
import com.sun.jbi.httpsoapbc.bootstrap.InstallerExtMBean;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.MBeanNames;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class HttpSoapBindingBootstrap
implements Bootstrap {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingBootstrap.class);
    private Logger mLogger;
    private InstallationContext mContext;
    private ObjectName mInstallerExtName;
    private InstallerExtMBean mInstallerMBean;

    public ObjectName getExtensionMBeanName() {
        return this.mInstallerExtName;
    }

    public void init(InstallationContext installContext) throws JBIException {
        this.mContext = installContext;
        ComponentContext ctx = installContext.getContext();
        Messages.registerContext((ComponentContext)ctx);
        this.mLogger = Messages.getLogger(HttpSoapBindingBootstrap.class);
        if (this.mLogger.isLoggable(Level.FINEST)) {
            this.mLogger.log(Level.FINEST, "Init method has been called");
        }
        MBeanServer mbServer = ctx.getMBeanServer();
        MBeanNames mbNames = ctx.getMBeanNames();
        this.mInstallerExtName = mbNames.createCustomComponentMBeanName("BootstrapExtension");
        this.mInstallerMBean = new InstallerExt();
        try {
            if (!mbServer.isRegistered(this.mInstallerExtName)) {
                StandardMBean installerExtMBean = new StandardMBean(this.mInstallerMBean, InstallerExtMBean.class);
                mbServer.registerMBean(installerExtMBean, this.mInstallerExtName);
            }
            ComponentConfig defaultProperties = ComponentConfig.parse((String)this.mContext.getInstallRoot());
            this.mInstallerMBean.setInitialConfigurations(defaultProperties);
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00110.InstallerMBean_registration_failed");
            throw new JBIException(text, (Throwable)ex);
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Registered InstallerExtMBean " + this.mInstallerExtName);
        }
    }

    public void onInstall() throws JBIException {
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "onInstall running");
        }
        ComponentContext ctx = this.mContext.getContext();
        MBeanServer mbServer = ctx.getMBeanServer();
        ComponentConfig installProperties = this.mInstallerMBean.getInstallationConfigurationProperties();
        ConfigPersistence.persistConfig((ComponentConfig)installProperties, (String)ctx.getWorkspaceRoot());
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Completed installation");
        }
    }

    public void onUninstall() throws JBIException {
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "onUninstall running");
            this.mLogger.log(Level.FINE, "Completed uninstallation");
        }
    }

    public void cleanUp() throws JBIException {
        try {
            ComponentContext ctx;
            if (this.mInstallerExtName != null && (ctx = this.mContext.getContext()) != null && ctx.getMBeanServer().isRegistered(this.mInstallerExtName)) {
                ctx.getMBeanServer().unregisterMBean(this.mInstallerExtName);
                if (this.mLogger.isLoggable(Level.FINE)) {
                    this.mLogger.log(Level.FINE, "Unregistered MBean " + this.mInstallerExtName);
                }
            }
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-W00111.InstallerMBean_deregistration_failed", (Object)this.mInstallerExtName);
            throw new JBIException(text, (Throwable)ex);
        }
    }
}

