/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.xml;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.util.Util;
import java.io.CharArrayWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StackableParser
extends DefaultHandler {
    private static Logger mLogger = Logger.getLogger(StackableParser.class.getName());
    private Map<String, String> mNamespaceMap;
    private StackableParser mParent;
    private Map<QName, StackableParser> mParserMap;
    private Stack<StackableParser> mStack;
    private Object mValue;
    private CharArrayWriter mContent = new CharArrayWriter();
    private String mCurrentContent;
    private String mNamespaceDecl;

    public static StackableParser createRootParser() {
        return new RootParser();
    }

    protected StackableParser() {
        this(null);
        this.mStack = new Stack();
        this.mParserMap = new HashMap<QName, StackableParser>();
    }

    protected StackableParser(StackableParser parent) {
        this.mParent = parent;
        this.mNamespaceMap = new HashMap<String, String>();
    }

    public void declareStackableParser(StackableParser parser, String nsURI, String ... tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            return;
        }
        Map<QName, StackableParser> map = this.getParserMap();
        if (parser != null && tagNames != null) {
            for (String tag : tagNames) {
                map.put(new QName(nsURI, tag), parser);
            }
        }
    }

    protected String lookupNS(String prefix) {
        String ns = this.getNS().get(prefix);
        if (ns == null) {
            return this.getParent() == null ? null : this.getParent().lookupNS(prefix);
        }
        return ns;
    }

    protected String getCurrentNS() {
        return this.getStack().isEmpty() ? this.getNSDecl() : this.getStack().peek().getNSDecl();
    }

    protected String getNSDecl() {
        if (this.mNamespaceDecl == null) {
            return this.getParent() == null ? null : this.getParent().getNSDecl();
        }
        return this.mNamespaceDecl;
    }

    protected void setNSDecl(String ns) {
        this.mNamespaceDecl = ns;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        StackableParser parent;
        QName nm = null;
        String decl = attributes.getValue("xmlns");
        if (!Util.isEmpty(decl)) {
            nm = new QName(decl, qName);
        } else {
            int ix = qName.indexOf(":");
            if (ix > 0) {
                String prefix = qName.substring(0, ix);
                String nsUri = attributes.getValue("xmlns:" + prefix);
                if (nsUri == null) {
                    nsUri = this.getStack().peek().lookupNS(prefix);
                }
                nm = new QName(nsUri, qName.substring(ix + 1), prefix);
            } else {
                decl = this.getCurrentNS();
                if (Util.isEmpty(decl)) {
                    decl = "http://java.sun.com/xml/ns/jbi";
                }
                nm = new QName(decl, qName, "jbi");
            }
        }
        StackableParser parser = this.getParserMap().get(nm);
        StackableParser stackableParser = parent = this.getStack().isEmpty() ? this : this.getStack().peek();
        if (parser == null) {
            parser = new NSParser(parent, nm);
            this.getStack().push(parser);
            parser.addNamespaceDecls(attributes);
        } else {
            parser = parser.newInstance(parent);
            this.getStack().push(parser);
            parser.addNamespaceDecls(attributes);
            parser.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        StackableParser parser = this.getStack().pop();
        if (parser != null) {
            this.updateContent(parser);
            parser.endElement(uri, localName, qName);
            if (!this.getStack().isEmpty()) {
                this.getStack().peek().acceptValue(parser.getValue());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mContent.write(ch, start, length);
    }

    protected String getContent() {
        return this.mCurrentContent;
    }

    protected void setContent(String str) {
        this.mCurrentContent = str;
    }

    protected void updateContent(StackableParser parser) {
        parser.setContent(this.mContent.toString());
        this.mContent.reset();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.log().isLoggable(Level.FINE)) {
            this.log().log(Level.FINE, "UTIL-3002: SAX Error Generated: " + e.getMessage(), e);
        }
        throw new SAXException(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.log().isLoggable(Level.FINE)) {
            this.log().log(Level.FINE, "UTIL-3003: SAX Fatal Error Generated: " + e.getMessage(), e);
        }
        throw new SAXException(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.log().isLoggable(Level.FINE)) {
            this.log().log(Level.FINE, "UTIL-3004: AX Warning Generated: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "Stackable-" + this.getClass().getSimpleName();
    }

    protected void addNamespaceDecls(Attributes attr) {
        int n = attr.getLength();
        for (int i = 0; i < n; ++i) {
            String attrQName = attr.getQName(i);
            if (!attrQName.startsWith("xmlns")) continue;
            int index = attrQName.indexOf(":");
            String prefix = null;
            String ns = attr.getValue(i);
            if (index < 0) {
                prefix = "";
                this.setNSDecl(ns);
            } else {
                prefix = attrQName.substring(index + 1);
            }
            this.getNS().put(prefix, ns);
        }
    }

    protected String stripPrefix(String qName) {
        int index = qName.indexOf(":");
        return index > 0 ? qName.substring(index + 1) : qName;
    }

    protected Object getValue() {
        return this.mValue;
    }

    protected final void setValue(Object obj) {
        this.mValue = obj;
    }

    protected void acceptValue(Object obj) {
        if (obj != null && this.getParent() != null) {
            this.getParent().acceptValue(obj);
        }
    }

    protected StackableParser newInstance(StackableParser parent) {
        this.setParent(parent);
        this.getNS().clear();
        return this;
    }

    protected EndpointInfo resolveEndpoint(Attributes attr, boolean isProvides) {
        String endptNm = attr.getValue("endpoint-name");
        QName interfaceNm = this.resolveQName(attr.getValue("interface-name"));
        QName serviceNm = this.resolveQName(attr.getValue("service-name"));
        EndpointInfo.LinkType linkType = null;
        String value = attr.getValue("link-type");
        if (!isProvides && !Util.isEmpty(value)) {
            linkType = EndpointInfo.LinkType.valueOf(value);
        }
        return new EndpointInfo(isProvides, endptNm, interfaceNm, serviceNm, linkType);
    }

    protected QName resolveQName(String qname) {
        if (qname == null) {
            return null;
        }
        String nsURI = null;
        String localPart = null;
        String prefix = null;
        int index = qname.indexOf(":");
        if (index < 0) {
            localPart = qname;
        } else {
            prefix = qname.substring(0, index);
            localPart = qname.substring(index + 1);
            nsURI = this.lookupNS(prefix);
        }
        return new QName(nsURI, localPart, prefix);
    }

    protected StackableParser getParent() {
        return this.mParent;
    }

    protected void setParent(StackableParser parser) {
        this.mParent = parser;
    }

    protected Map<String, String> getNS() {
        return this.mNamespaceMap;
    }

    protected Map<QName, StackableParser> getParserMap() {
        return this.mParserMap == null ? this.getParent().getParserMap() : this.mParserMap;
    }

    protected Stack<StackableParser> getStack() {
        return this.mStack == null ? this.getParent().getStack() : this.mStack;
    }

    protected Logger log() {
        return mLogger;
    }

    private static class NSParser
    extends StackableParser {
        private QName mQName;

        protected NSParser(StackableParser parent, QName qname) {
            super(parent);
            this.mQName = qname;
        }

        public StackableParser newInstance(StackableParser parent) {
            return new NSParser(parent, null);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addNamespaceDecls(attributes);
        }

        public String toString() {
            return "Stackable-NSParser-" + String.valueOf(this.mQName);
        }
    }

    private static class RootParser
    extends StackableParser {
        protected RootParser() {
            this.getStack().push(this);
        }
    }
}

