/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.OutputJarArchive;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.jbi.serviceengine.core.JBIEndpointManager;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.util.JBIConstants;
import com.sun.enterprise.jbi.serviceengine.util.Util;
import com.sun.enterprise.jbi.serviceengine.util.soap.WSDLConverter;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.management.ObjectName;

public class JavaEEServiceEngineSUManager
implements ServiceUnitManager,
JBIConstants {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");
    private String className = "JavaEEServiceEngineSUManager :: ";
    private DeploymentFacility deployer;
    private String target = "server";
    private JBIEndpointManager epManager;
    private Set<String> dummyCompApps;

    public JavaEEServiceEngineSUManager() {
        this.createDeployer();
        this.epManager = new JBIEndpointManager();
        this.dummyCompApps = new HashSet<String>();
    }

    public void init(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "init(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        try {
            if (this.isDummyApp(suPath)) {
                this.dummyCompApps.add(suId);
            }
            this.epManager.storeAllEndpoints(suPath, suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        if (this.isDAS() && !this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or start is done through" + " private MBean, hence skipping start.");
            this.doStart(suId, this.target);
        }
        try {
            this.epManager.startAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void shutDown(String suId) throws DeploymentException {
        String methodSig = this.className + "shutDown(String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
        try {
            this.dummyCompApps.remove(suId);
            this.epManager.removeAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public String deploy(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "deploy(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        if (!this.isDAS() || this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or deployment is done " + "through private MBean, hence skipping deploy.");
            return Util.buildManagementMessage("STATUS_MSG", "deploy", "SUCCESS", null, suId, null, null);
        }
        return this.doDeploy(suId, suPath, this.target);
    }

    public String undeploy(String suId, String suPath) throws DeploymentException {
        String methodSig = this.className + "undeploy(String, String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId + ". suPath = " + suPath);
        if (!this.isDAS() || this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or undeployment is done" + " through private MBean, hence skipping undeploy.");
            return Util.buildManagementMessage("STATUS_MSG", "undeploy", "SUCCESS", null, suId, null, null);
        }
        return this.doUnDeploy(suId, this.target);
    }

    public void start(String suId) throws DeploymentException {
        String methodSig = this.className + "start(String) :: NO-OP";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
    }

    public void stop(String suId) throws DeploymentException {
        String methodSig = this.className + "stop(String)";
        logger.log(Level.FINE, methodSig + " suId = " + suId);
        if (this.isDAS() && !this.isPrivateMBeanRegistered()) {
            logger.log(Level.FINE, methodSig + " either a non-DAS instance or deployment is done " + "through private MBean, hence skipping stop.");
            this.doStop(suId, this.target);
        }
        try {
            this.epManager.stopAllEndpoints(suId);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doDeploy(String serviceUnitName, String appLocation, String target) {
        String methodSig = this.className + "doDeploy(String,String,String,String) ";
        boolean deploymentSuccessful = true;
        String deploymentError = null;
        Throwable deploymentException = null;
        String archivePath = null;
        AbstractArchive arch = null;
        try {
            if (!this.isDummyApp(appLocation)) {
                if (!"nonsoapwsdl".equalsIgnoreCase(System.getProperty("com.sun.enterprise.jbi.se.usedwith"))) {
                    appLocation = this.processWSDLs(appLocation);
                }
                archivePath = new File(appLocation).isDirectory() ? this.createArchive(appLocation, serviceUnitName) : appLocation;
                logger.log(Level.FINE, methodSig + " appName = " + serviceUnitName + ", archivePath = " + archivePath + ", target = " + target);
                Map deployOptions = this.getDefaultDeploymentOptions(archivePath, serviceUnitName, target);
                arch = new ArchiveFactory().openArchive(archivePath);
                Archive plan = null;
                Target[] targets = this.deployer.createTargets(new String[]{target});
                logger.log(Level.FINE, methodSig + " calling backend deploy");
                JESProgressObject progressObject = this.deployer.deploy(targets, (Archive)arch, plan, deployOptions);
                DeploymentStatus status = this.deployer.waitFor(progressObject);
                logger.log(Level.FINE, methodSig + " deployment complete. status = " + status.getStatus());
                if (status.getStatus() != 2) {
                    deploymentSuccessful = false;
                    deploymentError = methodSig + status.toString();
                    deploymentException = status.getStageException();
                }
            } else {
                this.dummyCompApps.add(serviceUnitName);
            }
        }
        catch (Exception ex) {
            deploymentSuccessful = false;
            deploymentError = methodSig + ex.getMessage();
            deploymentException = ex;
        }
        finally {
            if (arch != null) {
                try {
                    arch.close();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        if (archivePath != null && new File(appLocation).isDirectory()) {
            try {
                boolean deleteSuccessful = new File(archivePath).delete();
                if (!deleteSuccessful) {
                    logger.log(Level.SEVERE, "Unable to delete the archive " + archivePath);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (deploymentSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully deployed " + serviceUnitName);
            return Util.buildManagementMessage("STATUS_MSG", "deploy", "SUCCESS", null, serviceUnitName, null, null);
        }
        logger.log(Level.SEVERE, deploymentError, deploymentException);
        return Util.buildManagementMessage("EXCEPTION_MSG", "deploy", "FAILED", null, serviceUnitName, deploymentError, deploymentException);
    }

    protected String doUnDeploy(String serviceUnitName, String target) {
        String methodSig = this.className + "doUnDeploy(String,String,String) ";
        boolean undeploymentSuccessful = true;
        String undeploymentError = null;
        Throwable undeploymentException = null;
        try {
            Target[] targets;
            JESProgressObject progressObject;
            DeploymentStatus status;
            if (!this.dummyCompApps.remove(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.undeploy(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName, this.getUnDeploymentOptions()))).getStatus() != 2) {
                undeploymentSuccessful = false;
                undeploymentError = methodSig + status.toString();
                undeploymentException = status.getStageException();
            }
        }
        catch (Exception ex) {
            undeploymentSuccessful = false;
            undeploymentError = methodSig + ex.getMessage();
            undeploymentException = ex;
        }
        if (undeploymentSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully undeployed " + serviceUnitName);
            return Util.buildManagementMessage("STATUS_MSG", "undeploy", "SUCCESS", null, serviceUnitName, null, null);
        }
        logger.log(Level.SEVERE, undeploymentError, undeploymentException);
        return Util.buildManagementMessage("EXCEPTION_MSG", "undeploy", "FAILED", null, serviceUnitName, undeploymentError, undeploymentException);
    }

    protected void doStart(String serviceUnitName, String target) {
        String methodSig = this.className + "doStart(String,String) ";
        boolean startSuccessful = true;
        String startError = null;
        Throwable startException = null;
        try {
            Target[] targets;
            JESProgressObject progressObject;
            DeploymentStatus status;
            if (!this.dummyCompApps.contains(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.enable(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName))).getStatus() != 2) {
                startSuccessful = false;
                startError = methodSig + status.toString();
                startException = status.getStageException();
            }
        }
        catch (Exception ex) {
            startSuccessful = false;
            startError = methodSig + ex.getMessage();
            startException = ex;
        }
        if (startSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully started " + serviceUnitName);
        } else {
            logger.log(Level.SEVERE, startError, startException);
        }
    }

    protected void doStop(String serviceUnitName, String target) {
        String methodSig = this.className + "doStop(String,String) ";
        boolean stopSuccessful = true;
        String stopError = null;
        Throwable stopException = null;
        try {
            Target[] targets;
            JESProgressObject progressObject;
            DeploymentStatus status;
            if (!this.dummyCompApps.contains(serviceUnitName) && (status = this.deployer.waitFor(progressObject = this.deployer.disable(targets = this.deployer.createTargets(new String[]{target}), serviceUnitName))).getStatus() != 2) {
                stopSuccessful = false;
                stopError = methodSig + status.toString();
                stopException = status.getStageException();
            }
        }
        catch (Exception ex) {
            stopSuccessful = false;
            stopError = methodSig + ex.getMessage();
            stopException = ex;
        }
        if (stopSuccessful) {
            logger.log(Level.FINE, methodSig + " successfully stopped " + serviceUnitName);
        } else {
            logger.log(Level.SEVERE, stopError, stopException);
        }
    }

    private String createArchive(String dir, String archiveName) {
        String archivePath;
        try {
            Archivist archivist = ArchivistFactory.getArchivistForArchive((String)dir);
            ModuleType moduleType = archivist.getModuleType();
            String pathExtn = ".jar";
            if (ModuleType.EAR.equals(moduleType)) {
                pathExtn = ".ear";
            } else if (ModuleType.WAR.equals(moduleType)) {
                pathExtn = ".war";
            } else if (ModuleType.RAR.equals(moduleType)) {
                pathExtn = ".rar";
            }
            String workspaceDir = JavaEEServiceEngineContext.getInstance().getJBIContext().getWorkspaceRoot();
            archivePath = workspaceDir + File.separator + archiveName + pathExtn;
            if (ModuleType.EAR.equals(moduleType)) {
                this.createEar(dir, archivePath);
            } else {
                this.createJar(dir, archivePath);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            archivePath = null;
        }
        return archivePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(String sourcePath, String destinationPath) throws IOException {
        FileArchive source = new FileArchive();
        OutputJarArchive destination = new OutputJarArchive();
        try {
            source.open(sourcePath);
            Enumeration entries = source.entries();
            destination.create(destinationPath);
            while (entries.hasMoreElements()) {
                String entry = (String)String.class.cast(entries.nextElement());
                InputStream is = null;
                OutputStream os = null;
                try {
                    is = source.getEntry(entry);
                    os = destination.putNextEntry(entry);
                    ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    destination.closeEntry();
                }
            }
        }
        finally {
            source.close();
            destination.close();
        }
    }

    private void createEar(String explodedDir, String earFilePath) throws Exception {
        ApplicationArchivist archivist = new ApplicationArchivist();
        FileArchive appArchive = new FileArchive();
        appArchive.open(new File(explodedDir).getAbsolutePath());
        archivist.setManifest(appArchive.getManifest());
        Application application = null;
        application = archivist.hasStandardDeploymentDescriptor((AbstractArchive)appArchive) ? (Application)archivist.readStandardDeploymentDescriptor((AbstractArchive)appArchive) : Application.createApplication((AbstractArchive)appArchive, (boolean)true, (boolean)true);
        archivist.setDescriptor((Descriptor)application);
        Iterator bundles = application.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor bundle = (ModuleDescriptor)bundles.next();
            String moduleName = bundle.getArchiveUri();
            String massagedModuleName = FileUtils.makeFriendlyFilename((String)moduleName);
            String explodedModulePath = explodedDir + File.separator + massagedModuleName;
            String moduleArhivePath = explodedDir + File.separator + moduleName;
            this.createJar(explodedModulePath, moduleArhivePath);
            DeploymentContext.deleteDirectory((File)new File(explodedModulePath));
        }
        this.createJar(explodedDir, earFilePath);
    }

    private void explodeArchive(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        if (destFile.exists()) {
            DeploymentContext.deleteDirectory((File)destFile);
            destFile.mkdir();
        }
        Archivist archivist = ArchivistFactory.getArchivistForArchive((File)srcFile);
        try {
            ModuleType moduleType = archivist.getModuleType();
            if (ModuleType.EAR.equals(moduleType)) {
                J2EEModuleExploder.explodeEar((File)srcFile, (File)destFile);
            } else if (ModuleType.EJB.equals(moduleType) || ModuleType.CAR.equals(moduleType) || ModuleType.RAR.equals(moduleType) || ModuleType.WAR.equals(moduleType)) {
                J2EEModuleExploder.explodeJar((File)srcFile, (File)destFile);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    private Map getDefaultDeploymentOptions(String archivePath, String appName, String target) {
        DeploymentProperties deploymentOptions = new DeploymentProperties();
        deploymentOptions.setName(appName);
        deploymentOptions.setForce(true);
        deploymentOptions.setArchiveName(archivePath);
        deploymentOptions.setEnable(false);
        deploymentOptions.setTarget(target);
        deploymentOptions.setExternallyManaged(true);
        return deploymentOptions;
    }

    private Map getUnDeploymentOptions() {
        DeploymentProperties undeploymentOptions = new DeploymentProperties();
        undeploymentOptions.setExternallyManaged(true);
        return undeploymentOptions;
    }

    private boolean isPrivateMBeanRegistered() {
        try {
            ComponentContext jbiContext = JavaEEServiceEngineContext.getInstance().getJBIContext();
            ObjectName privateMBeanName = jbiContext.getMBeanNames().createCustomComponentMBeanName("JavaEEDeployer");
            boolean isPrivateMBeanRegistered = jbiContext.getMBeanServer().isRegistered(privateMBeanName);
            logger.log(Level.FINE, "isPrivateMBeanRegistered = " + isPrivateMBeanRegistered);
            return isPrivateMBeanRegistered;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    private void createDeployer() {
        this.deployer = DeploymentFacilityFactory.getLocalDeploymentFacility();
    }

    private boolean isDAS() {
        try {
            return ServerHelper.isDAS((ConfigContext)AdminService.getAdminService().getAdminContext().getAdminConfigContext(), (String)ApplicationServer.getServerContext().getInstanceName());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, this.className + ex.getMessage(), ex);
            return false;
        }
    }

    private boolean isDummyApp(String appLocation) throws IOException {
        File app = new File(appLocation);
        if (app.isDirectory()) {
            for (Object fileObj : FileUtil.getAllFilesAndDirectoriesUnder((File)app)) {
                String path = ((File)fileObj).getPath();
                if (("META-INF" + File.separator + "jbi.xml").equalsIgnoreCase(path) || ("META-INF" + File.separator + "MANIFEST.MF").equalsIgnoreCase(path) || "META-INF".equalsIgnoreCase(path)) continue;
                return false;
            }
        } else {
            ZipFile zipFile = new ZipFile(appLocation);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                String entryName = e.nextElement().getName();
                if ("META-INF/jbi.xml".equalsIgnoreCase(entryName) || "META-INF/MANIFEST.MF".equalsIgnoreCase(entryName) || "META-INF/".equalsIgnoreCase(entryName)) continue;
                return false;
            }
        }
        return true;
    }

    private String processWSDLs(String appLocation) {
        String newAppLocation;
        if (!new File(appLocation).isDirectory()) {
            try {
                String workspaceDir = JavaEEServiceEngineContext.getInstance().getJBIContext().getWorkspaceRoot();
                newAppLocation = workspaceDir + File.separator + "exploded";
                this.explodeArchive(appLocation, newAppLocation);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return appLocation;
            }
        } else {
            newAppLocation = appLocation;
        }
        return WSDLConverter.convertWSDLs(newAppLocation).isEmpty() ? appLocation : newAppLocation;
    }
}

