/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.eManager.provider;

import com.sun.jbi.eManager.provider.PerformanceMeasurement;
import com.sun.jbi.eManager.provider.StatusProvider;
import com.sun.jbi.eManager.provider.StatusReporting;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class StatusProviderHelper {
    public static final String PROVISIONING_ID = "Provider";
    public static final String CONSUMING_ID = "Consumer";
    String shortDisplayName;
    ObjectName objectName;
    MBeanServer connection;
    static Map providers = new HashMap();

    public StatusProviderHelper(String componentType, String componentName, MBeanServer mbeanServer) throws MalformedObjectNameException {
        this(null, componentType, componentName, mbeanServer);
    }

    public StatusProviderHelper(String shortDisplayNm, String componentType, String componentName, MBeanServer mbeanServer) throws MalformedObjectNameException {
        this.shortDisplayName = shortDisplayNm;
        this.objectName = StatusProvider.constructObjectName(componentType, componentName);
        this.connection = mbeanServer;
    }

    public StatusProviderHelper(String shortDisplayNm, String componentType, String componentName) throws MalformedObjectNameException {
        this.shortDisplayName = shortDisplayNm;
        this.objectName = StatusProvider.constructObjectName(componentType, componentName);
        this.connection = MBeanServerFactory.findMBeanServer(null).get(0);
    }

    public StatusProviderHelper(String shortDisplayNm, ObjectName objectName, MBeanServer mbeanServer) {
        this.shortDisplayName = shortDisplayNm;
        this.objectName = objectName;
        this.connection = mbeanServer;
    }

    public StatusProviderHelper(String shortDisplayNm, ObjectName objectName) {
        this.shortDisplayName = shortDisplayNm;
        this.objectName = objectName;
        this.connection = MBeanServerFactory.findMBeanServer(null).get(0);
    }

    public void registerMBean() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.connection != null && !this.connection.isRegistered(this.objectName)) {
            StatusProvider provider = new StatusProvider(this.shortDisplayName);
            providers.put(this.objectName, provider);
            this.connection.registerMBean(provider, this.objectName);
        }
    }

    public void registerMBean(String[] categories, PerformanceMeasurement callback) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.registerMBean();
        ((StatusProvider)providers.get(this.objectName)).setPerformanceMeasurementCategories(categories);
        ((StatusProvider)providers.get(this.objectName)).setPeformanceMeasurementCallback(callback);
    }

    public void unregisterMBean() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.connection != null && this.connection.isRegistered(this.objectName)) {
            this.connection.unregisterMBean(this.objectName);
            providers.remove(this.objectName);
        }
    }

    public StatusReporting getStatusReporter() {
        return (StatusReporting)providers.get(this.objectName);
    }

    public String createEndpointIdentifier(QName serviceName, String portName) {
        return serviceName.getNamespaceURI() + "," + serviceName.getLocalPart() + "," + portName;
    }

    public String createProvisioningEndpointIdentifier(QName serviceName, String portName) {
        return serviceName.getNamespaceURI() + "," + serviceName.getLocalPart() + "," + portName + "," + PROVISIONING_ID;
    }

    public String createConsumingEndpointIdentifier(QName serviceName, String portName) {
        return serviceName.getNamespaceURI() + "," + serviceName.getLocalPart() + "," + portName + "," + CONSUMING_ID;
    }

    private String[] getSignatures(Object[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        String[] signatures = new String[params.length];
        for (int index = 0; index < params.length; ++index) {
            signatures[index] = params[index] == null ? "java.lang.Object" : params[index].getClass().getName();
        }
        return signatures;
    }

    private Object invokeWithParameters(ObjectName objName, String operationName, Object[] parameters) throws Exception {
        Object result = null;
        String[] signature = this.getSignatures(parameters);
        if (this.connection != null) {
            result = this.connection.invoke(objName, operationName, parameters, signature);
        }
        return result;
    }

    private Object getAttribute(ObjectName objName, String attributeName) throws Exception {
        Object result = null;
        if (this.connection != null) {
            result = this.connection.getAttribute(objName, attributeName);
        }
        return result;
    }

    public String[] getProvisioningEndpoints() throws Exception {
        String[] result = null;
        result = (String[])this.getAttribute(this.objectName, "ProvisioningEndpoints");
        return result;
    }

    public String[] getConsumingEndpoints() throws Exception {
        String[] result = null;
        result = (String[])this.getAttribute(this.objectName, "ConsumingEndpoints");
        return result;
    }

    public long getTotalRequests() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalRequests");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalReplies() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalReplies");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalErrors() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalErrors");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalDone() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalDone");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalSentRequests() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalSentRequests");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalSentReplies() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalSentReplies");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalSentErrors() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalSentErrors");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalSentDones() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalSentDones");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalReceivedRequests() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalReceivedRequests");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalReceivedReplies() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalReceivedReplies");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalReceivedErrors() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalReceivedErrors");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getTotalReceivedDones() throws Exception {
        Long result = null;
        result = (Long)this.getAttribute(this.objectName, "TotalReceivedDones");
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getSentRequests(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getSentRequests", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getSentReplies(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getSentReplies", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getSentErrors(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getSentErrors", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getSentDones(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getSentDones", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getReceivedRequests(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getReceivedRequests", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getReceivedReplies(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getReceivedReplies", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getReceivedErrors(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getReceivedErrors", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }

    public long getReceivedDones(String endpoint) throws Exception {
        Long result = null;
        Object[] parameters = new String[]{endpoint};
        result = (Long)this.invokeWithParameters(this.objectName, "getReceivedDones", parameters);
        if (result != null) {
            return result;
        }
        return 0L;
    }
}

