/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator.soapvalidators;

import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.validator.AbstractValidator;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;

public class HttpSoapAddressValidator
extends AbstractValidator
implements Validator {
    private static final Messages mMessages = Messages.getMessages(HttpSoapAddressValidator.class);

    public HttpSoapAddressValidator() {
    }

    public HttpSoapAddressValidator(RuntimeConfigurationMBean runtimeConfig, boolean resolveTokens) {
        super(runtimeConfig, resolveTokens);
    }

    public void validate(ExtensibilityElement element) throws ValidationException {
        int contextStartIndex;
        int colonIndex;
        SOAPAddress address = (SOAPAddress)element;
        String location = address.getLocationURI();
        if (location == null || "".equals(location)) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00290.Location_missing", (Object)"<soap:address>"));
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(location)) {
            return;
        }
        if (location.indexOf("${HttpDefaultPort}", 6) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("https://")) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00293.Address_protocol_mismatch", new Object[]{"${HttpDefaultPort}", location, "https"}));
            }
            if (location.startsWith("http://") && !"${HttpDefaultPort}".equals(location.substring((colonIndex = location.indexOf(":", 6)) + 1, contextStartIndex = location.indexOf("/", 7)))) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00294.Token_wrong_position", new Object[]{"${HttpDefaultPort}", location}));
            }
        }
        if (location.indexOf("${HttpsDefaultPort}", 7) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("http://")) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00293.Address_protocol_mismatch", new Object[]{"${HttpsDefaultPort}", location, "http"}));
            }
            if (location.startsWith("https://") && !"${HttpsDefaultPort}".equals(location.substring((colonIndex = location.indexOf(":", 7)) + 1, contextStartIndex = location.indexOf("/", 8)))) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00294.Token_wrong_position", new Object[]{"${HttpsDefaultPort}", location}));
            }
        }
        try {
            if (!this.mResolveTokens) {
                this.updateAppVariableMap(location, "STRING");
            } else {
                String newLocation = this.resolveEmbeddedTokensInURL(location);
                newLocation = this.resolveHostNameInUrl(newLocation);
                this.validateLocationURI(newLocation);
                address.setLocationURI(newLocation);
            }
        }
        catch (Exception ex) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00291.Location_unsupported", new Object[]{"<soap:address>", location, ex.getLocalizedMessage()}));
        }
    }
}

