/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.descriptor;

import com.sun.jbi.management.descriptor.ConfigurationException;
import com.sun.jbi.management.descriptor.Consumes;
import com.sun.jbi.management.descriptor.EndpointIdentifier;
import com.sun.jbi.management.descriptor.Provides;
import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SUDescriptorSupport {
    public static final boolean TEMP_SWITCH_ENABLE_JBI_ROUTING = true;
    public static final String META_INF_DIR = "META-INF";
    public static final String JBI_DESC_FILE_NAME = "jbi.xml";
    public static final String SERVICES_TAG_NAME = "services";
    public static final String BC_TAG_NAME = "binding-component";
    public static final String PROVIDES_TAG_NAME = "provides";
    public static final String CONSUMES_TAG_NAME = "consumes";
    public static final String INTERFACE_TAG_NAME = "interface-name";
    public static final String SERVICE_TAG_NAME = "service-name";
    public static final String ENDPOINT_TAG_NAME = "endpoint-name";
    public static final String LINK_TYPE_TAG_NAME = "link-type";
    public static final String SUN_CONFIG_OBJECT_EXTENSION_NAMESPACE = "http://www.sun.com/jbi/descriptor/configuration";
    public static final String SUN_CONFIG_OBJECT_EXTENSION_ELEMENT_NAME = "application-config";
    public static final String SUN_CONFIG_OBJECT_ATTRIBUTE_NAME = "name";
    boolean descriptorExists;
    Provides[] provides;
    Consumes[] consumes;
    boolean bindingComponentAttr;

    public SUDescriptorSupport(String serviceUnitRootPath) throws ConfigurationException {
        File jbiDescriptorFile = new File(serviceUnitRootPath + File.separator + META_INF_DIR, JBI_DESC_FILE_NAME);
        this.descriptorExists = jbiDescriptorFile.exists();
        if (this.descriptorExists) {
            DocumentBuilder builder = null;
            try {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                fact.setNamespaceAware(true);
                builder = fact.newDocumentBuilder();
            }
            catch (Exception ex) {
                throw new ConfigurationException("Failure in initalizing parser " + ex.getMessage(), ex);
            }
            try {
                NodeList nl2;
                NodeList nl;
                Document doc = builder.parse(jbiDescriptorFile);
                Element root = doc.getDocumentElement();
                NodeList serviceNL = root.getElementsByTagName(SERVICES_TAG_NAME);
                if (serviceNL != null && serviceNL.getLength() > 0) {
                    Element serviceElem = (Element)serviceNL.item(0);
                    String bcTagString = serviceElem.getAttribute(BC_TAG_NAME);
                    this.bindingComponentAttr = Boolean.valueOf(bcTagString);
                }
                if ((nl = root.getElementsByTagName(PROVIDES_TAG_NAME)) != null) {
                    int providesNoOfItems = nl.getLength();
                    this.provides = new Provides[providesNoOfItems];
                    for (int providesCount = 0; providesCount < providesNoOfItems; ++providesCount) {
                        Node n = nl.item(providesCount);
                        Element e = (Element)n;
                        String ifLocalName = e.getAttribute(INTERFACE_TAG_NAME);
                        String serviceLocalName = e.getAttribute(SERVICE_TAG_NAME);
                        String endpointName = e.getAttribute(ENDPOINT_TAG_NAME);
                        String configName = null;
                        QName ifName = this.resolveAttrQName(ifLocalName, e);
                        QName serviceName = this.resolveAttrQName(serviceLocalName, e);
                        NodeList childNodes = e.getChildNodes();
                        for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                            Element child;
                            Node aNode = childNodes.item(ii);
                            if (!(aNode instanceof Element) || !SUN_CONFIG_OBJECT_EXTENSION_NAMESPACE.equals((child = (Element)aNode).getNamespaceURI()) || !SUN_CONFIG_OBJECT_EXTENSION_ELEMENT_NAME.equals(child.getLocalName())) continue;
                            configName = child.getAttribute(SUN_CONFIG_OBJECT_ATTRIBUTE_NAME);
                            break;
                        }
                        this.provides[providesCount] = new Provides(ifName, serviceName, endpointName, configName);
                    }
                }
                if ((nl2 = root.getElementsByTagName(CONSUMES_TAG_NAME)) != null) {
                    int consumesNoOfItems = nl2.getLength();
                    this.consumes = new Consumes[consumesNoOfItems];
                    for (int consumesCount = 0; consumesCount < consumesNoOfItems; ++consumesCount) {
                        Node n = nl2.item(consumesCount);
                        Element e = (Element)n;
                        String ifLocalName = e.getAttribute(INTERFACE_TAG_NAME);
                        String serviceLocalName = e.getAttribute(SERVICE_TAG_NAME);
                        String endpointName = e.getAttribute(ENDPOINT_TAG_NAME);
                        String configName = null;
                        String linkType = null;
                        if (e.hasAttribute(LINK_TYPE_TAG_NAME)) {
                            linkType = e.getAttribute(LINK_TYPE_TAG_NAME);
                        }
                        QName ifName = this.resolveAttrQName(ifLocalName, e);
                        QName serviceName = this.resolveAttrQName(serviceLocalName, e);
                        NodeList childNodes = e.getChildNodes();
                        for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                            Element child;
                            Node aNode = childNodes.item(ii);
                            if (!(aNode instanceof Element) || !SUN_CONFIG_OBJECT_EXTENSION_NAMESPACE.equals((child = (Element)aNode).getNamespaceURI()) || !SUN_CONFIG_OBJECT_EXTENSION_ELEMENT_NAME.equals(child.getLocalName())) continue;
                            configName = child.getAttribute(SUN_CONFIG_OBJECT_ATTRIBUTE_NAME);
                            break;
                        }
                        this.consumes[consumesCount] = new Consumes(ifName, serviceName, endpointName, linkType, configName);
                    }
                }
            }
            catch (SAXException ex) {
                throw new ConfigurationException("Failure in parsing descriptor " + ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new ConfigurationException("IO failure in parsing descriptor " + ex.getMessage(), ex);
            }
        }
    }

    public Provides[] getProvides() {
        if (this.provides == null) {
            return this.provides;
        }
        int len = this.provides.length;
        Provides[] dest = new Provides[len];
        System.arraycopy(this.provides, 0, dest, 0, len);
        return dest;
    }

    public Consumes[] getConsumes() {
        if (this.consumes == null) {
            return this.consumes;
        }
        int len = this.consumes.length;
        Consumes[] dest = new Consumes[len];
        System.arraycopy(this.consumes, 0, dest, 0, len);
        return dest;
    }

    public EndpointIdentifier[] getServices() {
        int providesLen = this.provides != null ? this.provides.length : 0;
        int consumesLen = this.consumes != null ? this.consumes.length : 0;
        int len = consumesLen + providesLen;
        EndpointIdentifier[] svcs = new EndpointIdentifier[len];
        if (this.provides != null) {
            System.arraycopy(this.provides, 0, svcs, 0, providesLen);
        }
        if (this.consumes != null) {
            System.arraycopy(this.consumes, 0, svcs, providesLen, consumesLen);
        }
        return svcs;
    }

    public boolean isBindingComponentDescriptor() {
        return this.bindingComponentAttr;
    }

    public boolean isDescriptorPresent() {
        return this.descriptorExists;
    }

    QName resolveAttrQName(String attrValue, Element element) {
        int aColonLoc = attrValue.indexOf(":");
        String aLocalName = attrValue;
        String aPrefix = null;
        String aNS = null;
        if (aColonLoc > -1) {
            aPrefix = attrValue.substring(0, aColonLoc);
            aLocalName = attrValue.substring(aColonLoc + 1);
            for (Node currNode = element; (aNS == null || aNS.equals("")) && currNode != null; currNode = currNode.getParentNode()) {
                if (currNode.getNodeType() != 1) continue;
                aNS = currNode.getAttribute("xmlns:" + aPrefix);
            }
        }
        QName qName = new QName(aNS, aLocalName, aPrefix);
        return qName;
    }
}

