/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryRegistry<K, E> {
    private volatile Map<K, E> mReadMap = null;
    private Map<K, E> mWriteMap = null;

    public EntryRegistry() {
        this.clear();
    }

    public void clear() {
        this.mReadMap = new HashMap<K, E>();
        this.mWriteMap = new HashMap<K, E>();
    }

    public boolean containsKey(K key) {
        return this.mReadMap.containsKey(key);
    }

    public boolean containsEntry(E entry) {
        return this.mReadMap.containsValue(entry);
    }

    public boolean isEmpty() {
        return this.mReadMap.isEmpty();
    }

    public E lookup(K key) {
        return this.mReadMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAll(Map<K, E> map) {
        if (map != null) {
            Map<K, E> map2 = this.mWriteMap;
            synchronized (map2) {
                this.mWriteMap.putAll(map);
            }
            this.mReadMap = new HashMap<K, E>(this.mWriteMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(K key, E entry) {
        if (key != null) {
            Map<K, E> map = this.mWriteMap;
            synchronized (map) {
                this.mWriteMap.put(key, entry);
            }
            this.mReadMap = new HashMap<K, E>(this.mWriteMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(K key) {
        E prev = null;
        Map<K, E> map = this.mWriteMap;
        synchronized (map) {
            prev = this.mWriteMap.remove(key);
        }
        this.mReadMap = new HashMap<K, E>(this.mWriteMap);
        return prev;
    }

    public Set<K> keySet() {
        return this.mReadMap.keySet();
    }

    public String toString() {
        return String.valueOf(this.mReadMap);
    }
}

