/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.DOMDataSourceImpl;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.StringDataSourceImpl;
import com.sun.jbi.httpsoapbc.util.Util;
import com.sun.jbi.httpsoapbc.util.WSDLUtilities;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperParser;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDenormalizer {
    private static Messages mMessages = Messages.getMessages(XmlDenormalizer.class);
    private static Logger mLog = Messages.getLogger(XmlDenormalizer.class);
    private DocumentBuilderFactory mBuilderFactory;
    private DocumentBuilder builder;

    public XmlDenormalizer() {
        try {
            this.mBuilderFactory = DocumentBuilderFactory.newInstance();
            this.builder = this.mBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            mLog.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public DataSource denormalize(NormalizedMessage normalizedMessage, MessageExchange exchange, OperationMetaData meta, boolean inMsg) throws MessagingException {
        try {
            Node node = Util.messageAsDom(normalizedMessage);
            Document normalDoc = null;
            if (node != null) {
                normalDoc = node instanceof Document ? (Document)node : ((Element)node).getOwnerDocument();
            }
            WrapperParser wrapperParser = HelperFactory.createParser();
            if (Fault.class.isInstance(normalizedMessage)) {
                wrapperParser.parse(normalDoc, meta.getFullDefinition());
            } else {
                Message msgDef = null;
                msgDef = inMsg ? meta.getInputMessage() : meta.getOutputMessage();
                wrapperParser.parse(normalDoc, msgDef);
            }
            return this.processMessage(wrapperParser, meta.getFullDefinition());
        }
        catch (TransformerException tex) {
            throw new MessagingException("Unable to obtain normalized message as DOM", (Throwable)tex);
        }
        catch (WrapperProcessingException ex) {
            String msg = mMessages.getString("HTTPBC-E00799.Denormalize_fail");
            throw new MessagingException(msg, (Throwable)ex);
        }
    }

    private DataSource processMessage(WrapperParser wrapperParser, Definition wsDef) throws MessagingException, WrapperProcessingException {
        Object result = null;
        Message msgDef = wsDef.getMessage(wrapperParser.getMessageType());
        if (this.isSimpleMessageType(msgDef)) {
            String[] partNames = wrapperParser.getPartNames();
            StringBuffer contentBuffer = new StringBuffer();
            for (int i = 0; i < partNames.length; ++i) {
                NodeList nodeList = wrapperParser.getPartNodes(partNames[i]);
                int N = nodeList.getLength();
                for (int n = 0; n < N; ++n) {
                    Node node = nodeList.item(n);
                    contentBuffer.append(node.getTextContent());
                }
            }
            result = new StringDataSourceImpl(msgDef.getQName(), contentBuffer.toString());
        } else {
            Document document = this.builder.newDocument();
            String[] partNames = wrapperParser.getPartNames();
            for (int i = 0; i < partNames.length; ++i) {
                NodeList nodeList = wrapperParser.getPartNodes(partNames[i]);
                int N = nodeList.getLength();
                for (int n = 0; n < N; ++n) {
                    Node node = nodeList.item(n);
                    if (node == null) continue;
                    this.copyNode(document, node);
                }
            }
            result = new DOMDataSourceImpl(msgDef.getQName(), document);
        }
        return result;
    }

    private boolean isSimpleMessageType(Message msgDef) {
        boolean isSimple = true;
        List partsList = msgDef.getOrderedParts(null);
        ListIterator iter = partsList.listIterator();
        do {
            Part p;
            boolean bl = isSimple = (p = (Part)iter.next()).getElementName() == null && WSDLUtilities.isBuiltInType(p.getTypeName().getNamespaceURI());
        } while (isSimple && iter.hasNext());
        return isSimple;
    }

    private void copyNode(Document document, Node node) {
        node = document.importNode(node, true);
        document.appendChild(node);
        NamedNodeMap attrs = node.getAttributes();
        NamedNodeMap destAttrs = document.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                Node n = document.importNode(attr, true);
                if (destAttrs == null) continue;
                destAttrs.setNamedItemNS(n);
            }
        }
    }
}

