/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.internationalization.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class SynchronousReplySupport
implements ReplyListener {
    private static final Messages mMessages = Messages.getMessages(SynchronousReplySupport.class);
    private static final Logger mLogger = Messages.getLogger(SynchronousReplySupport.class);
    private static Map pendingRequests = Collections.synchronizedMap(new HashMap());
    String messageExchangeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchange waitForReply() throws MessagingException {
        if (this.messageExchangeId == null) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00790.No_message_exchange_set"));
        }
        Request request = (Request)pendingRequests.get(this.messageExchangeId);
        try {
            Request request2 = request;
            synchronized (request2) {
                while (request.response == null) {
                    try {
                        request.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            pendingRequests.remove(this.messageExchangeId);
        }
        return request.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void returnResponse(String messageExchangeId, MessageExchange response) throws MessagingException {
        Request request = (Request)pendingRequests.get(messageExchangeId);
        if (request == null) {
            if (mLogger.isLoggable(Level.WARNING)) {
                mLogger.log(Level.WARNING, "HTTPBC-W00645.No_request_for_response", messageExchangeId);
            }
        } else {
            Request request2 = request;
            synchronized (request2) {
                request.response = response;
                request.notify();
            }
        }
    }

    public void onReply(MessageExchange exchange) throws MessagingException {
        SynchronousReplySupport.returnResponse(exchange.getExchangeId(), exchange);
    }

    public void setMessageExchangeId(String messageExchangeId, Object clientContext) {
        this.messageExchangeId = messageExchangeId;
        Request request = new Request();
        request.messageExchangeId = messageExchangeId;
        pendingRequests.put(messageExchangeId, request);
    }

    public void removeMessageExchangeId(String messageExchangeId) {
        pendingRequests.remove(messageExchangeId);
    }

    static class Request {
        String messageExchangeId;
        MessageExchange response;

        Request() {
        }
    }
}

