/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.internationalization.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

class DOMDataSourceImpl
implements DataSource {
    private static Messages cMessages = Messages.getMessages(DOMDataSourceImpl.class);
    private final TransformerFactory mTransformerFactory = TransformerFactory.newInstance();
    private final Document mDocument;
    private final QName mName;

    public DOMDataSourceImpl(QName name, Document data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.mDocument = data;
        this.mName = name;
    }

    public String getContentType() {
        return "text/xml";
    }

    public InputStream getInputStream() throws UnsupportedEncodingException {
        ByteArrayInputStream inStream = null;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DOMSource source = new DOMSource(this.mDocument);
            StreamResult result = new StreamResult(outStream);
            Transformer transformer = this.mTransformerFactory.newTransformer();
            transformer.transform(source, result);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return inStream;
    }

    public String getName() {
        return this.mName.toString();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("This DataSource implementation is read-only; output stream not supported.");
    }
}

