/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import com.sun.enterprise.jbi.serviceengine.util.soap.MessageDenormalizer;
import com.sun.enterprise.jbi.serviceengine.util.soap.Operation;
import com.sun.enterprise.jbi.serviceengine.util.soap.SOAPWrapper;
import com.sun.enterprise.jbi.serviceengine.util.soap.StringTranslator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class MessageDenormalizerImpl
implements MessageDenormalizer {
    private static final String PAYLOAD_NAMESPACE_PREFIX = "jbisb0";
    private static final String SOAP_NAMESPACE_PREFIX = "soap";
    private static final String XML_SCHEMA_INSTANCE_NAMESPACE_PREFIX = "xsi";
    private MessageFactory mMessageFactory;
    private Logger mLogger;
    private StringTranslator mStringTranslator;
    private Transformer mTransformer;

    public MessageDenormalizerImpl() {
        try {
            this.mLogger = Logger.getLogger(this.getClass().getPackage().getName());
            this.mStringTranslator = new StringTranslator(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
            this.mMessageFactory = MessageFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.mTransformer = transformerFactory.newTransformer();
            this.mTransformer.setOutputProperty("method", "xml");
            this.mTransformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception exception) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_MESSAGE_FACTORY_CREATION_FAILURE"));
            this.mLogger.severe(this.mStringTranslator.getString("SBC_ERROR_DETAILS", exception.toString()));
            this.mMessageFactory = null;
            this.mTransformer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPWrapper denormalizeMessage(NormalizedMessage normalizedMessage, Operation operation, boolean isResponse) {
        OutputStreamWriter writer;
        SOAPWrapper wrapper;
        block8: {
            wrapper = null;
            writer = null;
            this.mLogger.fine(this.mStringTranslator.getString("SBC_DENORMALIZE_JBI_MESSAGE"));
            try {
                ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
                writer = new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8");
                this.writeEnvelopeHeader(writer);
                if (normalizedMessage != null) {
                    this.writeHeader(normalizedMessage, writer);
                }
                this.writeBody(normalizedMessage, operation, isResponse, writer);
                this.writeEnvelopeFooter(writer);
                ((Writer)writer).flush();
                SOAPMessage soapMessage = this.createSOAPMessage(bufferedStream);
                this.denormalizeAttachments(soapMessage, normalizedMessage);
                wrapper = new SOAPWrapper(soapMessage);
                if (normalizedMessage instanceof Fault) {
                    wrapper.setStatus(102);
                    break block8;
                }
                wrapper.setStatus(101);
            }
            catch (RuntimeException runtimeException) {
                this.mLogger.severe(this.mStringTranslator.getString("SBC_DENORMALIZE_JBI_MESSAGE_FAILURE_RT_EXP"));
                wrapper = this.denormalizeMessage(runtimeException);
                this.closeWriter(writer);
            }
            catch (Exception exception) {
                this.mLogger.warning(this.mStringTranslator.getString("SBC_DENORMALIZE_JBI_MESSAGE_FAILURE_EXP"));
                this.mLogger.warning(this.mStringTranslator.getString("SBC_ERROR_DETAILS", exception.toString()));
                this.mLogger.warning(this.mStringTranslator.getString("SBC_CREATE_SOAP_FAULT"));
                wrapper = this.denormalizeMessage(exception);
                this.closeWriter(writer);
                {
                    catch (Throwable throwable) {
                        this.closeWriter(writer);
                        throw throwable;
                    }
                }
            }
        }
        this.closeWriter(writer);
        this.mLogger.fine(this.mStringTranslator.getString("SBC_SUCCESS_DENORMALIZE_JBI_MESSAGE"));
        return wrapper;
    }

    public SOAPWrapper denormalizeMessage(Exception exception) {
        return this.denormalizeMessage(exception, "Server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPWrapper denormalizeMessage(Exception exception, String faultCode) {
        SOAPWrapper wrapper = null;
        OutputStreamWriter writer = null;
        this.mLogger.fine(this.mStringTranslator.getString("SBC_DENORMALIZE_EXCEPTION"));
        try {
            ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8");
            if (exception == null) {
                this.mLogger.warning(this.mStringTranslator.getString("SBC_NULL_OBJECT_DENORMALIZATION"));
            }
            this.writeEnvelopeHeader(writer);
            writer.write("<soap:Body>");
            this.writeFault(exception, faultCode, writer);
            writer.write("</soap:Body>");
            this.writeEnvelopeFooter(writer);
            ((Writer)writer).flush();
            SOAPMessage soapMessage = this.createSOAPMessage(bufferedStream);
            wrapper = new SOAPWrapper(soapMessage);
            wrapper.setStatus(103);
        }
        catch (RuntimeException runtimeException) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_SOAP_FAULT_GENERATION_FAILURE_RT_EXP"));
            this.closeWriter(writer);
        }
        catch (Exception denormalizationException) {
            this.mLogger.severe(this.mStringTranslator.getString("SBC_SOAP_FAULT_GENERATION_FAILURE"));
            this.closeWriter(writer);
            {
                catch (Throwable throwable) {
                    this.closeWriter(writer);
                    throw throwable;
                }
            }
        }
        this.closeWriter(writer);
        this.mLogger.fine(this.mStringTranslator.getString("SBC_SUCCESS_DENORMALIZE_EXCEPTION"));
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBody(NormalizedMessage normalizedMessage, Operation operation, boolean isResponse, Writer writer) throws Exception {
        StringWriter stringWriter = null;
        try {
            boolean isEmptyResponse = isResponse && normalizedMessage == null;
            this.writeBodyHeader(operation, writer, isEmptyResponse);
            if (normalizedMessage != null) {
                stringWriter = new StringWriter();
                StreamResult result = new StreamResult(stringWriter);
                this.mTransformer.transform(normalizedMessage.getContent(), result);
                writer.write(stringWriter.toString());
            }
            this.writeBodyFooter(operation, writer, isEmptyResponse);
            writer.flush();
            this.closeWriter(stringWriter);
        }
        catch (Throwable throwable) {
            this.closeWriter(stringWriter);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader(NormalizedMessage normalizedMessage, Writer writer) throws Exception {
        SOAPHeader soapHeader = (SOAPHeader)normalizedMessage.getProperty("SoapHeader");
        StringWriter stringWriter = null;
        if (soapHeader != null) {
            try {
                stringWriter = new StringWriter();
                DOMSource source = new DOMSource((Node)soapHeader);
                StreamResult result = new StreamResult(stringWriter);
                this.mTransformer.transform(source, result);
                writer.write("<soap:Header>");
                writer.write(stringWriter.toString());
                writer.write("</soap:Header>");
                writer.flush();
            }
            finally {
                this.closeWriter(stringWriter);
            }
        } else {
            this.mLogger.fine(this.mStringTranslator.getString("SBC_NO_HEADER"));
        }
    }

    protected void writeBodyHeader(Operation operation, Writer writer, boolean isEmptyResponse) throws Exception {
        writer.write("<soap:Body>");
        if (isEmptyResponse) {
            writer.write("<jbisb0:");
            writer.write(operation.getName() + "Response");
            writer.write(" xmlns:jbisb0=\"");
            writer.write(operation.getOutputNamespace() + "\"");
            writer.write(">");
        }
        writer.flush();
    }

    protected void writeBodyFooter(Operation operation, Writer writer, boolean isEmptyResponse) throws Exception {
        if (isEmptyResponse) {
            writer.write("</jbisb0:");
            writer.write(operation.getName() + "Response>");
        }
        writer.write("</soap:Body>");
        writer.flush();
    }

    protected SOAPMessage createSOAPMessage(ByteArrayOutputStream byteStream) throws SOAPException, IOException {
        if (this.mLogger.isLoggable(Level.FINEST)) {
            this.mLogger.finest(this.mStringTranslator.getString("SBC_DEONRMALIZED_MESSAGE_DETAILS", byteStream.toString()));
        }
        SOAPMessage soapMessage = this.mMessageFactory.createMessage();
        byte[] data = byteStream.toByteArray();
        ByteArrayInputStream soapInputStream = new ByteArrayInputStream(data);
        StreamSource streamSource = new StreamSource(soapInputStream);
        soapMessage.getSOAPPart().setContent((Source)streamSource);
        soapInputStream.close();
        return soapMessage;
    }

    protected void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception ioException) {
                this.mLogger.warning(this.mStringTranslator.getString("SBC_CLOSE_OUTPUT_STREAM"));
                this.mLogger.warning(this.mStringTranslator.getString("SBC_ERROR_DETAILS", ioException.toString()));
            }
        }
    }

    protected void writeEnvelopeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        writer.flush();
    }

    protected void writeEnvelopeFooter(Writer writer) throws IOException {
        writer.write("</soap:Envelope>");
        writer.flush();
    }

    protected void writeFault(Exception exception, String faultCode, Writer writer) throws IOException {
        writer.write("<soap:Fault><faultcode>soap:" + faultCode + "</faultcode>");
        if (exception != null) {
            writer.write("<faultstring>" + this.sanitizeMessage(exception.getMessage()) + "</faultstring>");
        }
        writer.write("</soap:Fault>");
        writer.flush();
    }

    public SOAPWrapper denormalizeFaultMessage(Fault faultMessage) {
        return this.denormalizeFaultMessage(faultMessage, "Server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SOAPWrapper denormalizeFaultMessage(Fault faultMessage, String faultCode) {
        SOAPWrapper wrapper;
        block9: {
            wrapper = null;
            OutputStreamWriter writer = null;
            this.mLogger.fine(this.mStringTranslator.getString("SBC_DENORMALIZE_FAULT_MESSAGE"));
            try {
                ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();
                String messageFaultCode = (String)faultMessage.getProperty("FAULT_ACTOR");
                String faultString = (String)faultMessage.getProperty("FAULT_STRING");
                if (messageFaultCode != null) {
                    faultCode = messageFaultCode;
                }
                if (faultString == null) {
                    faultString = this.mStringTranslator.getString("SBC_DEFAULT_FAULT_STRING");
                }
                writer = new OutputStreamWriter((OutputStream)bufferedStream, "UTF-8");
                this.writeEnvelopeHeader(writer);
                writer.write("<soap:Body>");
                writer.write("<soap:Fault xsi:type=\"soap:Fault\"><faultcode>soap:" + faultCode + "</faultcode>");
                writer.write("<faultstring>" + faultString + "</faultstring>");
                this.writeFaultDetail(faultMessage, writer);
                writer.write("</soap:Fault>");
                writer.write("</soap:Body>");
                this.writeEnvelopeFooter(writer);
                ((Writer)writer).flush();
                SOAPMessage soapMessage = this.createSOAPMessage(bufferedStream);
                wrapper = new SOAPWrapper(soapMessage);
                wrapper.setStatus(102);
                this.closeWriter(writer);
            }
            catch (RuntimeException runtimeException) {
                this.mLogger.severe(this.mStringTranslator.getString("SBC_SOAP_FAULT_GENERATION_FAILURE_RT_EXP"));
            }
            catch (Exception exception) {
                this.mLogger.severe(this.mStringTranslator.getString("SBC_SOAP_FAULT_GENERATION_FAILURE"));
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeWriter(writer);
            }
        }
        this.mLogger.fine(this.mStringTranslator.getString("SBC_SUCCESS_DENORMALIZE_FAULT"));
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFaultDetail(Fault faultMessage, Writer writer) throws Exception {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            this.mTransformer.transform(faultMessage.getContent(), result);
            String detailString = stringWriter.toString().trim();
            if (!detailString.equals("")) {
                writer.write("<detail>");
                writer.write(detailString);
                writer.write("</detail>");
                writer.flush();
            }
        }
        finally {
            this.closeWriter(stringWriter);
        }
    }

    protected String sanitizeMessage(String errorMessage) {
        StringBuffer sanitizedBuffer = new StringBuffer();
        block6: for (int i = 0; errorMessage != null && i < errorMessage.length(); ++i) {
            char currentChar = errorMessage.charAt(i);
            switch (currentChar) {
                case '\"': {
                    sanitizedBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    sanitizedBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sanitizedBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sanitizedBuffer.append("&gt;");
                    continue block6;
                }
                default: {
                    sanitizedBuffer.append(currentChar);
                }
            }
        }
        if (errorMessage == null) {
            return "INTERNAL SERVER ERROR";
        }
        return sanitizedBuffer.toString();
    }

    private void denormalizeAttachments(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) {
        if (normalizedMessage != null) {
            for (String attachmentIdentifier : normalizedMessage.getAttachmentNames()) {
                DataHandler dataHandler = normalizedMessage.getAttachment(attachmentIdentifier);
                AttachmentPart attachment = soapMessage.createAttachmentPart(dataHandler);
                attachment.setContentId(attachmentIdentifier);
                attachment.setContentType(dataHandler.getContentType());
                soapMessage.addAttachmentPart(attachment);
            }
        }
    }
}

