/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;
import com.sun.enterprise.jbi.serviceengine.comm.MessageSender;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandler;
import com.sun.enterprise.jbi.serviceengine.handlers.JBIHandlerFactory;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageExchangeTransportImpl
implements MessageExchangeTransport {
    MessageExchange me;
    protected NormalizedMessage msg = null;
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    protected MessageExchangeTransportImpl(MessageExchange me) {
        this.me = me;
    }

    @Override
    public void sendStatus(ExchangeStatus status) {
        try {
            this.me.setStatus(status);
            MessageSender messageSender = new MessageSender();
            messageSender.setMessageExchange(this.me);
            messageSender.send();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void sendError(Exception exception) {
        try {
            logger.log(Level.SEVERE, "Sending error to the consumer - " + exception);
            if (exception != null) {
                this.me.setError(exception);
            }
            this.me.setStatus(ExchangeStatus.ERROR);
            this.send();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public MessageExchange getMessageExchange() {
        return this.me;
    }

    @Override
    public NormalizedMessage getMessage() {
        return this.msg;
    }

    @Override
    public Map<String, Object> getMessageProperties() {
        Set propNames;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.msg != null && (propNames = this.msg.getPropertyNames()) != null) {
            for (Object o : propNames) {
                if (!(o instanceof String)) continue;
                String propName = (String)o;
                props.put(propName, this.msg.getProperty(propName));
            }
        }
        return props;
    }

    @Override
    public void setMessageProperties(Map<String, Object> props) {
        Set<String> propNames;
        if (props != null && this.msg != null && (propNames = props.keySet()) != null) {
            for (String propName : propNames) {
                this.msg.setProperty(propName, props.get(propName));
            }
        }
    }

    protected void send() throws Exception {
        this.preSend();
        MessageSender messageSender = new MessageSender();
        messageSender.setMessageExchange(this.me);
        messageSender.send();
        Exception exception = messageSender.getException();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public Exception receiveError() {
        this.preReceive();
        return this.me.getError();
    }

    protected String extractFaultCode(String completeFaultCode) {
        StringTokenizer tokenizer = new StringTokenizer(completeFaultCode, ":");
        if (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
        }
        return tokenizer.nextToken();
    }

    protected void preReceive() {
        this.invokeHandlersForOutbound();
    }

    protected void preSend() throws Exception {
        this.invokeHandlersForInbound();
    }

    protected void invokeHandlersForInbound() throws ServiceEngineException {
        for (JBIHandler handler : JBIHandlerFactory.getInstance().getHandlers()) {
            try {
                handler.handleInbound(this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new ServiceEngineException((Throwable)e);
            }
        }
    }

    protected void invokeHandlersForOutbound() {
        for (JBIHandler handler : JBIHandlerFactory.getInstance().getHandlers()) {
            try {
                handler.handleOutbound(this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

