/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.auth;

import com.sun.jbi.httpsoapbc.proxy.HttpProxy;
import com.sun.jbi.httpsoapbc.security.http.impl.BasicAuthenticator;
import com.sun.jbi.internationalization.Messages;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpAuthenticator
extends Authenticator {
    private static final Messages mMessages = Messages.getMessages(HttpAuthenticator.class);
    private static final Logger mLog = Messages.getLogger(HttpAuthenticator.class);
    private static boolean registered = false;
    private static HttpProxy hp = null;
    private static BasicAuthenticator basicAuth = null;

    public HttpAuthenticator() {
        this.register();
    }

    public static void registerHttpProxy(HttpProxy proxy) {
        hp = proxy;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "HttpProxy registered");
        }
    }

    public static void unregisterHttpProxy() {
        hp = null;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "HttpProxy unregistered");
        }
    }

    public static void registerBasicAuthenticator(BasicAuthenticator ba) {
        basicAuth = ba;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "BasicAuthenticator registered");
        }
    }

    public static void unregisterBasicAuthenticator() {
        basicAuth = null;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "BasicAuthenticator unregistered");
        }
    }

    public void register() {
        block6: {
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "Registering HttpAuthenticator...");
            }
            if (registered) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HttpAuthenticator already registered");
                }
                return;
            }
            try {
                Authenticator.setDefault(this);
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HttpAuthenticator registered");
                }
            }
            catch (Throwable t) {
                if (!mLog.isLoggable(Level.WARNING)) break block6;
                mLog.log(Level.WARNING, "HTTPBC-W01005.Self_registration_failed", t);
            }
        }
        registered = true;
    }

    public static void unregister() {
        registered = false;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "HttpAuthenticator unregistered");
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (!registered) {
            return super.getPasswordAuthentication();
        }
        if (null != hp && hp.getProxyPort() == this.getRequestingPort() && ("SOCKS5".equalsIgnoreCase(this.getRequestingProtocol()) && Proxy.Type.SOCKS.equals((Object)hp.getProxyType()) || "http".equalsIgnoreCase(this.getRequestingProtocol()) && Proxy.Type.HTTP.equals((Object)hp.getProxyType()) && Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType()))) {
            InetSocketAddress isa = (InetSocketAddress)hp.getProxy().address();
            if (isa.getAddress().equals(this.getRequestingSite()) || hp.getProxyHost().equalsIgnoreCase(this.getRequestingHost())) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Proxy auth. RequestingProtocol [" + this.getRequestingProtocol() + "], RequestorType [" + (Object)((Object)this.getRequestorType()) + "], RequestingHost [" + this.getRequestingHost() + "], RequestingPort [" + this.getRequestingPort() + "], RequestingSite [" + this.getRequestingSite() + "], RequestingURL [" + this.getRequestingURL() + "], RequestingScheme [" + this.getRequestingScheme() + "], RequestingPrompt [" + this.getRequestingPrompt() + "].");
                }
                return new PasswordAuthentication(hp.getProxyUserName(), hp.getProxyPassword());
            }
        }
        return super.getPasswordAuthentication();
    }
}

