/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.proxy;

import com.sun.jbi.httpsoapbc.proxy.HttpProxy;
import com.sun.jbi.httpsoapbc.proxy.HttpProxyURLStreamHandler;
import com.sun.jbi.internationalization.Messages;
import java.net.Proxy;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Messages mMessages = Messages.getMessages(HttpProxyURLStreamHandlerFactory.class);
    private static final Logger mLog = Messages.getLogger(HttpProxyURLStreamHandlerFactory.class);
    private HttpProxy hp;
    private static boolean registerAlready = false;
    private static boolean registerSucceed = false;
    private static String propertyHttpProxyHost = null;
    private static String propertyHttpProxyPort = null;
    private static String propertyHttpNonProxyHosts = null;
    private static String propertySocksProxyHost = null;
    private static String propertySocksProxyPort = null;
    private static String propertySocksNonProxyHosts = null;

    public HttpProxyURLStreamHandlerFactory(HttpProxy hp) {
        this.hp = hp;
    }

    public synchronized void register() {
        if (registerAlready) {
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "HttpProxyURLStreamHandlerFactory already registered. Register success flag: " + registerSucceed);
            }
            return;
        }
        try {
            if (!this.hp.isUseJVMProxySettings()) {
                URL.setURLStreamHandlerFactory(this);
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HttpProxyURLStreamHandlerFactory registered");
                }
            }
            registerSucceed = true;
        }
        catch (Error e) {
            if (mLog.isLoggable(Level.WARNING)) {
                mLog.log(Level.WARNING, "HTTPBC-W01105.URLStreamHandlerFactory_already_set");
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HTTPBC-W01105.URLStreamHandlerFactory_already_set", e);
                }
            }
            this.setProperties();
        }
        catch (Throwable t) {
            if (mLog.isLoggable(Level.WARNING)) {
                mLog.log(Level.WARNING, "HTTPBC-W01106.URLStreamHandlerFactory_registration_security_error");
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HTTPBC-W01106.URLStreamHandlerFactory_registration_security_error", t);
                }
            }
            this.setProperties();
        }
        registerAlready = true;
    }

    public static boolean isRegisterSucceed() {
        return registerSucceed;
    }

    public static void unregister() {
        if (!registerSucceed) {
            if (null != propertyHttpProxyHost) {
                System.setProperty("http.proxyHost", propertyHttpProxyHost);
            }
            if (null != propertyHttpProxyPort) {
                System.setProperty("http.proxyPort", propertyHttpProxyPort);
            }
            if (null != propertyHttpNonProxyHosts) {
                System.setProperty("http.nonProxyHosts", propertyHttpNonProxyHosts);
            }
            if (null != propertySocksProxyHost) {
                System.setProperty("socksProxyHost", propertySocksProxyHost);
            }
            if (null != propertySocksProxyPort) {
                System.setProperty("socksProxyPort", propertySocksProxyPort);
            }
            if (null != propertySocksNonProxyHosts) {
                System.setProperty("socksNonProxyHosts", propertySocksNonProxyHosts);
            }
        }
        registerAlready = false;
        registerSucceed = false;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "HttpProxyURLStreamHandlerFactory unregistered");
        }
    }

    private void setProperties() {
        if (Proxy.Type.HTTP.equals((Object)this.hp.getProxyType())) {
            propertyHttpProxyHost = System.getProperty("http.proxyHost", "");
            propertyHttpProxyPort = System.getProperty("http.proxyPort", "");
            propertyHttpNonProxyHosts = System.getProperty("http.nonProxyHosts", "");
            System.setProperty("http.proxyHost", this.hp.getProxyHost());
            System.setProperty("http.proxyPort", "" + this.hp.getProxyPort());
            System.setProperty("http.nonProxyHosts", this.hp.getNonProxyHosts());
        } else if (Proxy.Type.SOCKS.equals((Object)this.hp.getProxyType())) {
            propertySocksProxyHost = System.getProperty("socksProxyHost", "");
            propertySocksProxyPort = System.getProperty("socksProxyPort", "");
            propertySocksNonProxyHosts = System.getProperty("socksNonProxyHosts", "");
            System.setProperty("socksProxyHost", this.hp.getProxyHost());
            System.setProperty("socksProxyPort", "" + this.hp.getProxyPort());
            System.setProperty("socksNonProxyHosts", this.hp.getNonProxyHosts());
        }
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("http".equalsIgnoreCase(protocol) && registerSucceed) {
            return new HttpProxyURLStreamHandler(this.hp);
        }
        return null;
    }
}

