/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.proxy;

import com.sun.jbi.httpsoapbc.proxy.HttpProxy;
import com.sun.jbi.internationalization.Messages;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProxySelector
extends ProxySelector {
    private static final Messages mMessages = Messages.getMessages(HttpProxySelector.class);
    private static final Logger mLog = Messages.getLogger(HttpProxySelector.class);
    private HttpProxy hp;
    private static ProxySelector oldDefault = ProxySelector.getDefault();
    private static boolean registerAlready = false;

    public HttpProxySelector(HttpProxy hp) {
        this.hp = hp;
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "The current ProxySelector is [" + oldDefault + "]");
        }
    }

    public void register() {
        block7: {
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "Registering HttpProxySelector...");
            }
            if (registerAlready) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "HttpProxySelector registered already: " + oldDefault);
                }
                return;
            }
            try {
                if (!this.hp.isUseJVMProxySettings()) {
                    ProxySelector.setDefault(this);
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.log(Level.FINE, "HttpProxySelector registered");
                    }
                }
            }
            catch (Throwable t) {
                if (!mLog.isLoggable(Level.WARNING)) break block7;
                mLog.log(Level.WARNING, "HTTPBC-W01120.Self_registration_failed", t);
            }
        }
        registerAlready = true;
    }

    public static void unregister() {
        ProxySelector.setDefault(oldDefault);
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "Unregistering HttpProxySelector...");
        }
        registerAlready = false;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E01103.Null_uri"));
        }
        String host = uri.getHost();
        if (null == host) {
            return oldDefault.select(uri);
        }
        String protocol = uri.getScheme();
        if ("socket".equalsIgnoreCase(protocol) && Proxy.Type.HTTP.equals((Object)this.hp.getProxyType())) {
            return oldDefault.select(uri);
        }
        if (!("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol) || "ftp".equalsIgnoreCase(protocol) || "gopher".equalsIgnoreCase(protocol) || "socket".equalsIgnoreCase(protocol))) {
            return oldDefault.select(uri);
        }
        ArrayList<Proxy> list = new ArrayList<Proxy>(1);
        String nonProxyHosts = this.hp.getNonProxyHosts();
        if (null == nonProxyHosts || 0 == nonProxyHosts.length()) {
            list.add(this.hp.getProxy());
            return list;
        }
        if ((nonProxyHosts = nonProxyHosts.replaceAll(" ", "").toLowerCase()).startsWith((host = host.toLowerCase()) + "|") || nonProxyHosts.endsWith("|" + host) || nonProxyHosts.contains("|" + host + "|")) {
            list.add(Proxy.NO_PROXY);
        } else {
            list.add(this.hp.getProxy());
        }
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException(mMessages.getString("HTTPBC-E01102.Null_arguments"));
        }
        if (this.hp.getProxy().address().equals(sa)) {
            if (mLog.isLoggable(Level.WARNING)) {
                String logMsg = mMessages.getString("HTTPBC-W01125.Proxy_connection_failed", new Object[]{this.hp.getProxy(), uri});
                if (mLog.isLoggable(Level.WARNING)) {
                    mLog.log(Level.WARNING, logMsg, ioe);
                } else {
                    mLog.log(Level.WARNING, logMsg);
                }
            }
        } else {
            oldDefault.connectFailed(uri, sa, ioe);
        }
    }
}

