/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.qos.ServiceQuality;
import com.sun.jbi.common.qos.descriptor.DeploymentLookup;
import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.throttling.ThrottlingConfig;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.EndpointChangeListener;
import com.sun.jbi.httpsoapbc.EndpointFactory;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.ResourceLocator;
import com.sun.jbi.httpsoapbc.ServiceUnit;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.extensions.SOAPExtSerializer;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.httpsoapbc.security.impl.ServiceUnitSecurityConfigImpl;
import com.sun.jbi.httpsoapbc.util.HttpUrlResolverUtil;
import com.sun.jbi.httpsoapbc.util.TransformerPool;
import com.sun.jbi.httpsoapbc.validator.HttpSoapValidatorRegistry;
import com.sun.jbi.httpsoapbc.validator.WSDLExtensionValidator;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.management.descriptor.EndpointIdentifier;
import com.sun.jbi.management.descriptor.SUDescriptorSupport;
import com.sun.jbi.wsdlvalidator.ValidatingWSDLReader;
import com.sun.jbi.wsdlvalidator.ValidatorRegistry;
import com.sun.jbi.wsdlvalidator.factory.ValidatingWSDLFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUnitImpl
implements ServiceUnit {
    private static final Logger mLogger = Messages.getLogger(ServiceUnitImpl.class);
    private static final Messages mMessages = Messages.getMessages(ServiceUnitImpl.class);
    private String mId;
    private String mComponentName;
    private ComponentContext mContext;
    private RuntimeConfigurationMBean mRuntimeConfig;
    private boolean endpointsCreated;
    private String mRootPath;
    private Map mEndpoints;
    private Collection mEndpointChangeListeners;
    private Map mModifiedWSDLs;
    private Map mModifiedWSDLNamespacesMap;
    private Map mModifiedSchemas;
    private Map mModifiedXSDNamespacesMap;
    private Map mDefs;
    private TransformerPool mTransformerPool;
    private CredentialValidatorManager mCredValidatorMgr;
    private MessagingChannel mChannel;
    private Map<EndpointInfo, List<ServiceQuality>> mEndpointQos;
    private CatalogManager mCatalogManager;
    private EntityResolver mResolver;

    public ServiceUnitImpl(String id, ComponentContext context, RuntimeConfigurationMBean runtimeConfig, Collection endpointChangeListeners, CredentialValidatorManager credValidatorMgr) {
        this.mId = id;
        this.mContext = context;
        this.mRuntimeConfig = runtimeConfig;
        this.mEndpoints = new HashMap();
        this.mEndpointChangeListeners = endpointChangeListeners;
        this.mModifiedWSDLs = new HashMap();
        this.mModifiedWSDLNamespacesMap = new HashMap();
        this.mModifiedSchemas = new HashMap();
        this.mModifiedXSDNamespacesMap = new HashMap();
        this.mTransformerPool = new TransformerPool();
        this.mComponentName = context.getComponentName();
        this.mCredValidatorMgr = credValidatorMgr;
        this.mChannel = HttpSoapComponentContext.getInstance().getBindingChannel();
    }

    ServiceUnitImpl(String id, ComponentContext context, RuntimeConfigurationMBean runtimeConfig, Collection endpointChangeListeners, CredentialValidatorManager credValidatorMgr, Map endpoints) {
        this(id, context, runtimeConfig, endpointChangeListeners, credValidatorMgr);
        this.mEndpoints = endpoints;
    }

    @Override
    public String getServiceUnitId() {
        return this.mId;
    }

    @Override
    public void deploy(String serviceUnitRootPath) throws JBIException {
        this.createEndpoints(serviceUnitRootPath, false);
    }

    @Override
    public void init(String serviceUnitRootPath) throws JBIException {
        File catalog;
        this.mRootPath = serviceUnitRootPath;
        DeploymentLookup lookUpUtil = new DeploymentLookup(this.mContext);
        this.mEndpointQos = lookUpUtil.lookupServiceQualities(serviceUnitRootPath);
        if (this.mEndpointQos != null && this.mEndpointQos.size() > 0) {
            for (EndpointInfo endpointInfo : this.mEndpointQos.keySet()) {
                ServiceQuality[] qos = this.mEndpointQos.get(endpointInfo).toArray(new ServiceQuality[0]);
                this.mChannel.addServiceQualityToEndpoint(endpointInfo, qos);
            }
        }
        if ((catalog = new File(this.mRootPath + File.separator + "meta-inf" + File.separator + "catalog.xml")).exists()) {
            this.mCatalogManager = new CatalogManager();
            this.mCatalogManager.setCatalogFiles(catalog.getAbsolutePath());
            this.mCatalogManager.setRelativeCatalogs(true);
            this.mCatalogManager.setUseStaticCatalog(false);
            this.mResolver = new CatalogResolver(this.mCatalogManager);
        }
        if (!this.endpointsCreated) {
            this.createEndpoints(serviceUnitRootPath, true);
        }
        Iterator it = this.mEndpoints.values().iterator();
        Endpoint currEndpoint = null;
        Iterator it2 = null;
        try {
            while (it.hasNext()) {
                currEndpoint = (Endpoint)it.next();
                currEndpoint.activate(this.mContext);
                for (EndpointChangeListener listener : this.mEndpointChangeListeners) {
                    listener.endpointInitialized(currEndpoint);
                }
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void start() throws JBIException {
        HashSet<Endpoint> activatedEndpoints = new HashSet<Endpoint>();
        Iterator it = this.mEndpoints.values().iterator();
        Endpoint currEndpoint = null;
        try {
            while (it.hasNext()) {
                String aNamespace;
                int ii;
                currEndpoint = (Endpoint)it.next();
                List wsdlNamespaces = currEndpoint.getImportedWSDLNamespaces();
                List xsdNamespaces = currEndpoint.getImportedXSDNamespaces();
                for (ii = 0; ii < wsdlNamespaces.size(); ++ii) {
                    aNamespace = (String)wsdlNamespaces.get(ii);
                    if (this.mModifiedWSDLNamespacesMap.get(aNamespace) == null) continue;
                    currEndpoint.addImportedWSDLDefinition(aNamespace, (Definition)this.mModifiedWSDLNamespacesMap.get(aNamespace));
                }
                for (ii = 0; ii < xsdNamespaces.size(); ++ii) {
                    aNamespace = (String)xsdNamespaces.get(ii);
                    if (this.mModifiedXSDNamespacesMap.get(aNamespace) == null) continue;
                    currEndpoint.addImportedXSDSchema(aNamespace, (Element)this.mModifiedXSDNamespacesMap.get(aNamespace));
                }
                activatedEndpoints.add(currEndpoint);
                for (EndpointChangeListener listener : this.mEndpointChangeListeners) {
                    listener.endpointActivated(currEndpoint);
                }
            }
        }
        catch (Exception ex) {
            if (currEndpoint != null) {
                String text = mMessages.getString("HTTPBC-E00301.Endpoint_activate_failed", new Object[]{currEndpoint.getUniqueName(), ex.getLocalizedMessage()});
                mLogger.log(Level.SEVERE, text, ex);
                this.mEndpoints.remove(currEndpoint.getUniqueName());
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "HTTPBC-R00305.Deactivating_endpoints_incomplete_activation");
            }
            Iterator it2 = activatedEndpoints.iterator();
            while (it2.hasNext()) {
                ((Endpoint)it2.next()).deactivate(this.mContext);
            }
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void stop() throws JBIException {
        try {
            for (Endpoint endpoint : this.mEndpoints.values()) {
                for (EndpointChangeListener listener : this.mEndpointChangeListeners) {
                    listener.endpointDeactivated(endpoint);
                }
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void shutdown() throws JBIException {
        try {
            if (this.mEndpointQos != null && this.mEndpointQos.size() > 0) {
                for (EndpointInfo endpointInfo : this.mEndpointQos.keySet()) {
                    ServiceQuality[] qos = this.mEndpointQos.get(endpointInfo).toArray(new ServiceQuality[0]);
                    this.mChannel.removeServiceQualityFromEndpoint(endpointInfo, qos);
                }
            }
            for (Endpoint currEndpoint : this.mEndpoints.values()) {
                currEndpoint.deactivate(this.mContext);
                for (EndpointChangeListener listener : this.mEndpointChangeListeners) {
                    listener.endpointShutdown(currEndpoint);
                }
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        finally {
            this.endpointsCreated = false;
            this.mEndpoints.clear();
        }
    }

    @Override
    public void undeploy(String serviceUnitRootPath) throws JBIException {
    }

    @Override
    public Map getEndpoints() {
        return this.mEndpoints;
    }

    private void createEndpoints(String serviceUnitRootPath, boolean resolveTokens) throws JBIException {
        try {
            SUDescriptorSupport descSupport = new SUDescriptorSupport(serviceUnitRootPath);
            EndpointIdentifier[] svcs = descSupport.getServices();
            if (svcs.length == 0) {
                mLogger.log(Level.WARNING, "HTTPBC-W00306.No_endpoints_to_create", new Object[]{this.mComponentName, this.mId});
                return;
            }
            Map appConfigObjectMap = this.mRuntimeConfig.retrieveApplicationConfigurationsMap();
            File dir = new File(serviceUnitRootPath);
            ValidatingWSDLFactory wsdlFactory = new ValidatingWSDLFactory();
            ValidatingWSDLReader reader = (ValidatingWSDLReader)wsdlFactory.newWSDLReader(dir);
            if (mLogger.isLoggable(Level.FINE)) {
                reader.setFeature("javax.wsdl.verbose", true);
            } else {
                reader.setFeature("javax.wsdl.verbose", false);
            }
            ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
            SOAPExtSerializer serializer = new SOAPExtSerializer(this.mRuntimeConfig, resolveTokens);
            serializer.registerSerializer(registry);
            reader.setExtensionRegistry(registry);
            reader.setValidatorRegistry((ValidatorRegistry)new HttpSoapValidatorRegistry(this.mRuntimeConfig, resolveTokens));
            this.mDefs = reader.readWSDL(dir);
            WSDLExtensionValidator extValidator = new WSDLExtensionValidator(this.mDefs, svcs);
            extValidator.validate();
            if (!resolveTokens) {
                for (int ii = 0; ii < svcs.length; ++ii) {
                    EndpointIdentifier epDesc = svcs[ii];
                    String configName = epDesc.getApplicationConfigurationName();
                    if (configName == null || "".equals(configName) || appConfigObjectMap.containsKey(configName)) continue;
                    appConfigObjectMap.put(configName, "");
                }
                return;
            }
            ServiceUnitSecurityConfigImpl suSecurityConfig = new ServiceUnitSecurityConfigImpl(serviceUnitRootPath, this.mId);
            HttpUrlResolverUtil urlResolverUtil = new HttpUrlResolverUtil(this.mRuntimeConfig.retrieveApplicationVariablesMap());
            for (Map.Entry entry : this.mDefs.entrySet()) {
                String path = (String)entry.getKey();
                Definition def = (Definition)entry.getValue();
                for (int ii = 0; ii < svcs.length; ++ii) {
                    Endpoint bcEndpoint;
                    boolean hasAppObject = false;
                    EndpointIdentifier epDesc = svcs[ii];
                    if (epDesc == null) continue;
                    String configName = epDesc.getApplicationConfigurationName();
                    URL urlLocation = null;
                    if (configName != null && !"".equals(configName)) {
                        hasAppObject = true;
                        String location = (String)appConfigObjectMap.get(configName);
                        if (location == null) {
                            throw new JBIException(mMessages.getString("HTTPBC-E00360.Application_config_object_not_defined", (Object)configName));
                        }
                        try {
                            String newLocation = urlResolverUtil.resolveEmbeddedTokensInURL(location, this.mRuntimeConfig.getHttpDefaultPort(), this.mRuntimeConfig.getHttpsDefaultPort());
                            newLocation = urlResolverUtil.resolveHostNameInUrl(newLocation);
                            urlResolverUtil.validateLocationURI(newLocation);
                            urlLocation = new URL(newLocation);
                        }
                        catch (Exception e) {
                            throw new JBIException(mMessages.getString("HTTPBC-E00361.Invalid_url_defined_in_application_config_object", new Object[]{configName, location, e.getLocalizedMessage()}));
                        }
                    }
                    if ((bcEndpoint = EndpointFactory.createEndpoint(def, epDesc.getServiceName(), epDesc.getEndpointName(), epDesc.getInterfaceName(), epDesc.isProvider(), path, suSecurityConfig.getEndpointSecurityConfig(epDesc.getEndpointName()), this.mId, serviceUnitRootPath, this.mCredValidatorMgr)) == null) continue;
                    this.getQOSConfigurations(bcEndpoint, epDesc, this.mEndpointQos);
                    bcEndpoint.init();
                    for (EndpointChangeListener listener : this.mEndpointChangeListeners) {
                        listener.endpointDeployed(bcEndpoint);
                    }
                    bcEndpoint.setOriginalWSDL(new File(serviceUnitRootPath + File.separatorChar + path));
                    if (hasAppObject) {
                        bcEndpoint.setEndpointUrl(urlLocation);
                    }
                    this.mEndpoints.put(bcEndpoint.getUniqueName(), bcEndpoint);
                    if (this.mModifiedWSDLs.get(path) == null) {
                        path = path.replace(File.separatorChar, '/');
                        String dirPath = "";
                        if (path.contains("/")) {
                            dirPath = path.substring(0, path.lastIndexOf("/"));
                        }
                        this.modifyWSDL(bcEndpoint.getEndpointUrl().getProtocol(), bcEndpoint.getEndpointUrl().getPort(), dirPath, def, bcEndpoint);
                        this.mModifiedWSDLs.put(path, def);
                        this.mModifiedWSDLNamespacesMap.put(def.getTargetNamespace(), def);
                    }
                    svcs[ii] = null;
                }
            }
            this.endpointsCreated = true;
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer getResource(String resourcePath, Endpoint endpoint) {
        Transformer transformer = null;
        ByteBuffer result = null;
        try {
            Element schema;
            ByteArrayOutputStream baos;
            Definition def = (Definition)this.mModifiedWSDLs.get(resourcePath);
            if (def != null) {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter writer = wsdlFactory.newWSDLWriter();
                baos = new ByteArrayOutputStream();
                writer.writeWSDL(def, (OutputStream)baos);
                result = ByteBuffer.wrap(baos.toByteArray());
            }
            if ((schema = (Element)this.mModifiedSchemas.get(resourcePath)) != null) {
                transformer = this.mTransformerPool.retrieve();
                DOMSource src = new DOMSource(schema);
                baos = new ByteArrayOutputStream();
                StreamResult dest = new StreamResult(baos);
                transformer.transform(src, dest);
                result = ByteBuffer.wrap(baos.toByteArray());
            }
            this.mTransformerPool.relinquish(transformer);
            return result;
        }
        catch (Exception ex) {
            return result;
        }
        finally {
            this.mTransformerPool.relinquish(transformer);
        }
    }

    public void modifyWSDL(String protocol, int port, String path, Definition def, Endpoint endpoint) throws Exception {
        Iterator importLists = def.getImports().values().iterator();
        while (importLists.hasNext()) {
            for (Import anImport : (List)importLists.next()) {
                String relativeLoc = anImport.getLocationURI();
                if (relativeLoc != null && !relativeLoc.toLowerCase().startsWith("http://") && !relativeLoc.toLowerCase().startsWith("https://")) {
                    URL locationURL;
                    String updatedLocationURI = relativeLoc;
                    if (!path.equals("")) {
                        updatedLocationURI = path + "/" + relativeLoc;
                    }
                    ResourceLocator locator = new ResourceLocator(protocol, port, this.mId, updatedLocationURI);
                    anImport.setLocationURI(locator.toString());
                    File importedWSDL = new File(this.mRootPath, updatedLocationURI);
                    if (!importedWSDL.exists() && (locationURL = new URL(updatedLocationURI = this.mCatalogManager.getCatalog().resolveSystem(relativeLoc))) != null && locationURL.getProtocol().equals("file")) {
                        importedWSDL = new File(locationURL.getPath());
                    }
                    endpoint.addWSDLImport(importedWSDL.toURL());
                    endpoint.addImportedWSDLNamespace(anImport.getNamespaceURI());
                    this.addNewWSDL(protocol, port, path, relativeLoc, endpoint);
                    continue;
                }
                endpoint.addWSDLImport(new URL(relativeLoc));
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement element : types.getExtensibilityElements()) {
                if (!(element instanceof Schema)) continue;
                Schema schema = (Schema)element;
                this.updateSchemaWSDL(protocol, port, path, schema, endpoint);
                this.updateSchemaDom(protocol, port, path, schema.getElement());
            }
        }
    }

    private void updateSchemaWSDL(String protocol, int port, String path, Schema schema, Endpoint endpoint) throws Exception {
        Iterator importURIList = schema.getImports().keySet().iterator();
        while (importURIList.hasNext()) {
            endpoint.addImportedXSDNamespace((String)importURIList.next());
        }
        Iterator importList = schema.getImports().values().iterator();
        while (importList.hasNext()) {
            this.updateSchemaReferences(protocol, port, path, schema, (Collection)importList.next());
        }
        this.updateSchemaReferences(protocol, port, path, schema, schema.getIncludes());
        this.updateSchemaReferences(protocol, port, path, schema, schema.getRedefines());
    }

    private void updateSchemaReferences(String protocol, int port, String path, Schema schema, Collection references) throws Exception {
        for (SchemaReference schemaref : references) {
            String locationURI = schemaref.getSchemaLocationURI();
            if (locationURI == null || locationURI.toLowerCase().startsWith("http://") || locationURI.toLowerCase().startsWith("https://")) continue;
            String updatedLocationURI = locationURI;
            if (!path.equals("")) {
                updatedLocationURI = path + "/" + locationURI;
            }
            ResourceLocator locator = new ResourceLocator(protocol, port, this.mId, updatedLocationURI);
            schemaref.setSchemaLocationURI(locator.toString());
        }
    }

    private void updateSchemaDom(String protocol, int port, String path, Element el) throws Exception {
        Element tempEl = DOMUtils.getFirstChildElement((Element)el);
        while (tempEl != null) {
            QName tempElType = QNameUtils.newQName((Node)tempEl);
            if (SchemaConstants.XSD_IMPORT_QNAME_LIST.contains(tempElType) || SchemaConstants.XSD_INCLUDE_QNAME_LIST.contains(tempElType) || SchemaConstants.XSD_REDEFINE_QNAME_LIST.contains(tempElType)) {
                this.updateSchemaDomReference(protocol, port, path, tempEl);
            }
            tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
        }
    }

    private void updateSchemaDomReference(String protocol, int port, String path, Element tempEl) throws Exception {
        String locationURI = DOMUtils.getAttribute((Element)tempEl, (String)"schemaLocation");
        if (locationURI != null && !locationURI.toLowerCase().startsWith("http://") && !locationURI.toLowerCase().startsWith("https://")) {
            String updatedLocationURI = locationURI;
            if (!path.equals("")) {
                updatedLocationURI = path + "/" + locationURI;
            }
            ResourceLocator locator = new ResourceLocator(protocol, port, this.mId, updatedLocationURI);
            this.setAttribute(tempEl, "schemaLocation", locator.toString());
            this.addNewSchema(protocol, port, path, locationURI);
        }
    }

    private void addNewWSDL(String protocol, int port, String path, String locationURI, Endpoint endpoint) throws Exception {
        String filePath = path.replace('/', File.separatorChar);
        String fileLocationURI = locationURI.replace('/', File.separatorChar);
        String relativePath = filePath + File.separator + fileLocationURI;
        File wsdlFile = new File(this.mRootPath, filePath + File.separator + fileLocationURI);
        File root = new File(this.mRootPath);
        String normalizedRoot = root.getCanonicalPath();
        String completePath = wsdlFile.getCanonicalPath();
        Definition wsdlDef = null;
        String normalizedRelativePath = null;
        if (completePath.startsWith(normalizedRoot)) {
            normalizedRelativePath = completePath.substring(normalizedRoot.length(), completePath.length());
            while (normalizedRelativePath.startsWith(File.separator)) {
                normalizedRelativePath = normalizedRelativePath.substring(1, normalizedRelativePath.length());
            }
            wsdlDef = (Definition)this.mDefs.get(normalizedRelativePath);
            if (wsdlDef == null) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "WARNING: Service Unit " + this.mId + " deployment unable to find an internal map entry for the WSDL object " + normalizedRelativePath + ". Ignoring it.");
                }
                return;
            }
        } else {
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Service Unit " + this.mId + " deployment encountered a WSDL object (" + completePath + ") outside its jurisdiction (" + null + ").  Ignoring it.");
            }
            return;
        }
        String locatorPath = normalizedRelativePath.replace(File.separatorChar, '/');
        if (this.mModifiedWSDLs.get(locatorPath) == null) {
            String currentPath = null;
            if (locationURI.indexOf("/") != -1) {
                currentPath = locationURI.substring(0, locationURI.lastIndexOf("/"));
            }
            if (currentPath == null || currentPath.equals("")) {
                currentPath = path;
            } else if (!path.equals("")) {
                currentPath = path + "/" + currentPath;
            }
            this.modifyWSDL(protocol, port, currentPath, wsdlDef, endpoint);
            this.mModifiedWSDLs.put(locatorPath, wsdlDef);
            this.mModifiedWSDLNamespacesMap.put(wsdlDef.getTargetNamespace(), wsdlDef);
        }
    }

    private void addNewSchema(String protocol, int port, String path, String locationURI) throws Exception {
        String filePath = path.replace('/', File.separatorChar);
        String fileLocationURI = locationURI.replace('/', File.separatorChar);
        File schemaFile = new File(this.mRootPath, filePath + File.separator + fileLocationURI);
        Document schema = null;
        if (schemaFile.exists()) {
            schema = this.getDocument(schemaFile);
        } else if (this.mResolver != null) {
            schema = this.getDocument(this.mResolver.resolveEntity(null, locationURI));
        }
        if (schema == null) {
            throw new Exception(mMessages.getString("HTTPBC-E00362.Cannot_resolve_schema", (Object)locationURI));
        }
        String currentPath = null;
        if (locationURI.indexOf("/") != -1) {
            currentPath = locationURI.substring(0, locationURI.lastIndexOf("/"));
        }
        if (currentPath == null || currentPath.equals("")) {
            currentPath = path;
        } else if (!path.equals("")) {
            currentPath = path + "/" + currentPath;
        }
        if (currentPath.equals("")) {
            if (!this.mModifiedSchemas.containsKey(schemaFile.getName())) {
                this.mModifiedSchemas.put(schemaFile.getName(), schema.getDocumentElement());
                this.mModifiedXSDNamespacesMap.put(schema.getDocumentElement().getAttribute("targetNamespace"), schema.getDocumentElement());
                this.updateSchemaDom(protocol, port, currentPath, schema.getDocumentElement());
            }
        } else if (!this.mModifiedSchemas.containsKey(currentPath + "/" + schemaFile.getName())) {
            this.mModifiedSchemas.put(currentPath + "/" + schemaFile.getName(), schema.getDocumentElement());
            this.mModifiedXSDNamespacesMap.put(schema.getDocumentElement().getAttribute("targetNamespace"), schema.getDocumentElement());
            this.updateSchemaDom(protocol, port, currentPath, schema.getDocumentElement());
        }
    }

    private Document getDocument(File input) throws Exception {
        if (input == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        File updatedFile = new File(input.getCanonicalPath());
        if (this.mResolver != null) {
            builder.setEntityResolver(this.mResolver);
        }
        return builder.parse(updatedFile);
    }

    private Document getDocument(InputSource input) throws Exception {
        if (input == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (this.mResolver != null) {
            builder.setEntityResolver(this.mResolver);
        }
        return builder.parse(input);
    }

    private void setAttribute(Element el, String attrName, String attrValue) {
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            attr.setValue(attrValue);
        }
    }

    private void getQOSConfigurations(Endpoint httpbcEndpoint, EndpointIdentifier endpointIdentifier, Map<EndpointInfo, List<ServiceQuality>> qosMap) {
        if (qosMap != null && qosMap.size() > 0) {
            EndpointInfo endpointInfo = new EndpointInfo(false, endpointIdentifier.getEndpointName(), null, endpointIdentifier.getServiceName(), null);
            List<ServiceQuality> qoss = qosMap.get(endpointInfo);
            if (qoss == null) {
                return;
            }
            for (ServiceQuality qos : qoss) {
                if (qos instanceof ThrottlingConfig) {
                    ThrottlingConfig throttleConfig = (ThrottlingConfig)qos;
                    httpbcEndpoint.setMaxConcurrencyLimit(throttleConfig.getMaxConcurrencyLimit());
                    continue;
                }
                if (!(qos instanceof RedeliveryConfig)) continue;
                RedeliveryConfig redeliveryConfig = (RedeliveryConfig)qos;
                httpbcEndpoint.setRedeliveryConfiguration(redeliveryConfig);
            }
        }
    }
}

