/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.management.message.JBITaskResult;
import java.util.logging.Logger;

public class JBITask
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(JBITask.class.getName());
    public static final String ELEMENT_NAME = "jbi-task";
    public static final String JBI_TASK_NAMESPACE_URI = "http://java.sun.com/xml/ns/jbi/management-message";
    private String version = "1.0";
    private JBITaskResult taskResult;

    protected String buildString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>\n");
        buffer.append("<");
        buffer.append(ELEMENT_NAME);
        buffer.append(" version='");
        buffer.append(this.version);
        buffer.append("'");
        buffer.append(" xmlns='");
        buffer.append(JBI_TASK_NAMESPACE_URI);
        buffer.append("'");
        buffer.append(">\n");
        buffer.append(this.getTaskResult().getString());
        buffer.append("</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.taskResult == null) {
            logger.warning("Task result not set");
        }
    }

    public JBITaskResult getTaskResult() {
        if (this.taskResult == null) {
            this.taskResult = new JBITaskResult();
        }
        return this.taskResult;
    }

    public void setTaskResult(JBITaskResult taskResult) throws JBIMessageException {
        if (taskResult == null) {
            throw new JBIMessageException("Task result cannot be null");
        }
        this.taskResult = taskResult;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) throws JBIMessageException {
        if (version == null) {
            throw new JBIMessageException("Version cannot be null");
        }
        try {
            double d = Double.parseDouble(version);
            if (d <= 0.0) {
                throw new JBIMessageException("Version cannot be zero nor negative: " + version);
            }
        }
        catch (NumberFormatException nbe) {
            throw new JBIMessageException("Invalid version decimal number: " + version);
        }
        if (!version.equals(new Double(version).toString())) {
            throw new JBIMessageException("Invalid decimal representation: " + version);
        }
        this.version = version;
    }
}

