/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.ComponentTaskResultDetails;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.management.message.JBITaskMessageBuilder;
import com.sun.jbi.management.message.MessageLocalizationInfo;
import com.sun.jbi.management.message.TaskResultDetails;
import javax.jbi.management.DeploymentException;

public abstract class AbstractJBITaskMessageBuilder
implements JBITaskMessageBuilder {
    private String componentName;

    public final void setComponentName(String componentName) {
        if (componentName == null) {
            throw new NullPointerException("Component name cannot be null");
        }
        if (componentName.trim().length() == 0) {
            throw new IllegalArgumentException("Component name cannot be blank");
        }
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public final String createSuccessMessage(String taskId) {
        return this.createComponentMessage(taskId, true, 0, null, null, null, null);
    }

    public final String createSuccessMessage(String taskId, String locToken, String locMessage, Object[] locParam) {
        return this.createComponentMessage(taskId, true, 0, locToken, locMessage, locParam, null);
    }

    public final String createSuccessMessage(String taskId, String locToken, String locMessage, Object locParam) {
        Object[] param = null;
        if (locParam != null) {
            param = new Object[]{locParam};
        }
        return this.createSuccessMessage(taskId, locToken, locMessage, param);
    }

    public final String createExceptionMessage(String taskId, String locToken, String locMessage, Object locParam) {
        return this.createExceptionMessage(taskId, locToken, locMessage, locParam, null);
    }

    public final String createExceptionMessage(String taskId, String locToken, String locMessage, Object locParam, Throwable throwable) {
        Object[] param = null;
        if (locParam != null) {
            param = new Object[]{locParam};
        }
        return this.createComponentMessage(taskId, false, 3, locToken, locMessage, param, throwable);
    }

    public final String createExceptionMessage(String taskId, String locToken, String locMessage, Object[] locParam, Throwable throwable) {
        return this.createComponentMessage(taskId, false, 3, locToken, locMessage, locParam, throwable);
    }

    public final String createExceptionMessage(String taskId, String locToken, String locMessage, Object[] locParam) {
        return this.createExceptionMessage(taskId, locToken, locMessage, locParam, (Throwable)null);
    }

    public void throwException(String taskId, String locToken, String locMessage, Object locParam, Throwable throwable) throws DeploymentException {
        String extMsg = this.createExceptionMessage(taskId, locToken, locMessage, locParam, throwable);
        throw new DeploymentException(extMsg, throwable);
    }

    public void throwException(String taskId, String locToken, String locMessage, Object locParam) throws DeploymentException {
        String extMsg = this.createExceptionMessage(taskId, locToken, locMessage, locParam);
        throw new DeploymentException(extMsg);
    }

    public void throwException(String taskId, String locToken, String locMessage, Object[] locParam, Throwable throwable) throws DeploymentException {
        String extMsg = this.createExceptionMessage(taskId, locToken, locMessage, locParam, throwable);
        throw new DeploymentException(extMsg, throwable);
    }

    public void throwException(String taskId, String locToken, String locMessage, Object[] locParam) throws DeploymentException {
        String extMsg = this.createExceptionMessage(taskId, locToken, locMessage, locParam);
        throw new DeploymentException(extMsg);
    }

    public final String createComponentMessage(String taskId, boolean success, int messageType, String locToken, String locMessage, Object[] locParam, Throwable throwable) throws JBIMessageException {
        return this.createComponentMessage(this.createComponentTaskResult(taskId, success, messageType, locToken, locMessage, locParam, throwable));
    }

    public final ComponentTaskResult createComponentTaskResult(String taskId, boolean success, int messageType, String locToken, String locMessage, Object[] locParam, Throwable throwable) throws JBIMessageException {
        String componentName = this.getComponentName();
        if (componentName == null) {
            throw new IllegalStateException("Component name has not been set");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Task id cannot be null");
        }
        switch (messageType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid message type (" + messageType + "). Must be one of INFO, WARNING or ERROR");
            }
        }
        if (success) {
            if (messageType != 0 && messageType != 1 && messageType != 2) {
                throw new IllegalArgumentException("Successful operation can only report INFO or WARNING");
            }
        } else if (messageType != 2 && messageType != 3) {
            throw new IllegalArgumentException("Unsuccessful operation can only report WARNING or ERROR");
        }
        TaskResultDetails trd = new TaskResultDetails();
        trd.setTaskId(taskId);
        trd.setSuccessfulResult(success);
        trd.setMessageType(messageType);
        locMessage = this.escapeChars(locMessage);
        if (throwable != null) {
            if (locToken == null) {
                throw new IllegalArgumentException("Localization token cannot be null");
            }
            if (locMessage == null) {
                throw new IllegalArgumentException("Localization message cannot be null");
            }
            MessageLocalizationInfo messageLocalizationInfo = new MessageLocalizationInfo(locToken, locMessage, locParam);
            trd.newExceptionInfo(throwable, messageLocalizationInfo);
        } else if (locMessage != null) {
            if (locToken == null) {
                throw new IllegalArgumentException("Localization token cannot be null");
            }
            trd.newMessageLocalizationInfo(locToken, locMessage, locParam);
        }
        ComponentTaskResultDetails ctrd = new ComponentTaskResultDetails(trd);
        return new ComponentTaskResult(this.getComponentName(), ctrd);
    }

    private String escapeChars(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = text.toCharArray();
        int I = chars.length;
        block4: for (int i = 0; i < I; ++i) {
            switch (chars[i]) {
                case '{': {
                    if (i + 1 < I && Character.isDigit(chars[i + 1])) {
                        buffer.append("{");
                        continue block4;
                    }
                    buffer.append("'{'");
                    continue block4;
                }
                case '\'': {
                    buffer.append("''");
                    continue block4;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        return buffer.toString();
    }

    protected abstract String createComponentMessage(ComponentTaskResult var1) throws JBIMessageException;
}

