/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.bootstrap;

import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.httpsoapbc.bootstrap.InstallerExtMBean;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InvalidAttributeValueException;

public class InstallerExt
implements InstallerExtMBean {
    private static final Messages mMessages = Messages.getMessages(InstallerExt.class);
    private static final Logger mLogger = Messages.getLogger(InstallerExt.class);
    private static long MIN_OUTBOUND_THREADS = 5L;
    private static long MAX_OUTBOUND_THREADS = Integer.MAX_VALUE;
    private static String PROXY_TYPE_SOCKS = "SOCKS";
    private static String PROXY_TYPE_HTTP = "HTTP";
    private static String PROXY_TYPE_DIRECT = "DIRECT";
    private ComponentConfig mConfigProps;
    private Integer mOutboundThreads;
    private Integer mHttpDefaultPort;
    private Integer mHttpsDefaultPort;
    private String mAMConfigDir;
    private String mProxyType;
    private String mProxyHost;
    private Integer mProxyPort;
    private String mNonProxyHosts;
    private String mProxyUserName;
    private String mProxyPassword;
    private Boolean mUseJVMProxySettings;

    public Integer getOutboundThreads() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Number of outbound threads set at install time is: " + this.mOutboundThreads);
        }
        return this.mOutboundThreads;
    }

    public void setOutboundThreads(Integer val) throws InvalidAttributeValueException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00112.Invalid_argument_for_setting_attribute", new Object[]{"OutboundThreads", "null"}));
        }
        if ((long)val.intValue() < MIN_OUTBOUND_THREADS || (long)val.intValue() > MAX_OUTBOUND_THREADS) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00114.Invalid_value_for_attribute", new Object[]{val, "OutboundThreads", new Long(MIN_OUTBOUND_THREADS), new Long(MAX_OUTBOUND_THREADS)}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting number of outbound threads to: " + val);
        }
        this.mOutboundThreads = val;
    }

    public Integer getHttpDefaultPort() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "HTTP Port: " + this.mHttpDefaultPort);
        }
        return this.mHttpDefaultPort;
    }

    public void setHttpDefaultPort(Integer val) throws InvalidAttributeValueException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00112.Invalid_argument_for_setting_attribute", new Object[]{"HttpDefaultPort", "null"}));
        }
        Integer httpPortVal = this.getHttpDefaultPort();
        if (httpPortVal != null && val.equals(httpPortVal)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00113.Invalid_http_port_same_as_https_port", new Object[]{"HttpDefaultPort", val}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting HTTP Port to: " + val);
        }
        this.mHttpDefaultPort = val;
    }

    public Integer getHttpsDefaultPort() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "HTTPS Port: " + this.mHttpsDefaultPort);
        }
        return this.mHttpsDefaultPort;
    }

    public void setHttpsDefaultPort(Integer val) throws InvalidAttributeValueException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00112.Invalid_argument_for_setting_attribute", new Object[]{"HttpsDefaultPort", "null"}));
        }
        Integer httpPortVal = this.getHttpDefaultPort();
        if (httpPortVal != null && val.equals(httpPortVal)) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00115.Invalid_https_port_same_as_http_port", new Object[]{"HttpsDefaultPort", val}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting HTTPS Port to: " + val);
        }
        this.mHttpsDefaultPort = val;
    }

    public String getAMConfigDirectory() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Access Manager Configuration Directory: " + this.mAMConfigDir);
        }
        return this.mAMConfigDir;
    }

    public void setAMConfigDirectory(String val) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Access Manager Configuration Directory to: " + val);
        }
        this.mAMConfigDir = val;
    }

    public Boolean getUseJVMProxySettings() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "JVM Proxy Settings flag: " + this.mUseJVMProxySettings);
        }
        return this.mUseJVMProxySettings;
    }

    public void setUseJVMProxySettings(Boolean val) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Settng JVM Proxy Settings flag to: " + val);
        }
        this.mUseJVMProxySettings = val;
    }

    public String getProxyType() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Proxy type: " + this.mProxyType);
        }
        return this.mProxyType;
    }

    public void setProxyType(String val) throws InvalidAttributeValueException {
        if (!(val == null || val.equals(PROXY_TYPE_SOCKS) || val.equals(PROXY_TYPE_HTTP) || val.equals(PROXY_TYPE_DIRECT))) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00112.Invalid_argument_for_setting_attribute", new Object[]{"ProxyType", val}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Proxy type to: " + val);
        }
        this.mProxyType = val;
    }

    public String getProxyHost() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Proxy Host: " + this.mProxyHost);
        }
        return this.mProxyHost;
    }

    public void setProxyHost(String val) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Proxy Host to: " + val);
        }
        this.mProxyHost = val;
    }

    public Integer getProxyPort() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Proxy Port: " + this.mProxyPort);
        }
        return this.mProxyPort;
    }

    public void setProxyPort(Integer val) throws InvalidAttributeValueException {
        if (val == null) {
            throw new InvalidAttributeValueException(mMessages.getString("HTTPBC-E00112.Invalid_argument_for_setting_attribute", new Object[]{"ProxyPort", "null"}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Proxy Port to: " + val);
        }
        this.mProxyPort = val;
    }

    public String getNonProxyHosts() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Non-Proxy Hosts: " + this.mNonProxyHosts);
        }
        return this.mNonProxyHosts;
    }

    public void setNonProxyHosts(String val) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Non-Proxy Hosts to: " + val);
        }
        this.mNonProxyHosts = val;
    }

    public String getProxyUserName() {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Proxy User Name: " + this.mProxyUserName);
        }
        return this.mProxyUserName;
    }

    public void setProxyUserName(String val) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Setting Proxy User Name to: " + val);
        }
        this.mProxyUserName = val;
    }

    public String getProxyPassword() {
        return this.mProxyPassword;
    }

    public void setProxyPassword(String val) {
        this.mProxyPassword = val;
    }

    public void setInitialConfigurations(ComponentConfig props) {
        this.mConfigProps = props;
        this.mOutboundThreads = Integer.valueOf(props.getProperty("OutboundThreads").getValue());
        this.mHttpDefaultPort = Integer.valueOf(props.getProperty("HttpDefaultPort").getValue());
        this.mHttpsDefaultPort = Integer.valueOf(props.getProperty("HttpsDefaultPort").getValue());
        this.mAMConfigDir = props.getProperty("AMConfigDirectory").getValue();
        this.mProxyType = props.getProperty("ProxyType").getValue();
        this.mProxyHost = props.getProperty("ProxyHost").getValue();
        this.mProxyPort = Integer.valueOf(props.getProperty("ProxyPort").getValue());
        this.mNonProxyHosts = props.getProperty("NonProxyHosts").getValue();
        this.mProxyUserName = props.getProperty("ProxyUserName").getValue();
        this.mProxyPassword = props.getProperty("ProxyPassword").getValue();
        this.mUseJVMProxySettings = Boolean.valueOf(props.getProperty("UseJVMProxySettings").getValue());
    }

    public ComponentConfig getInstallationConfigurationProperties() {
        this.mConfigProps.getProperty("OutboundThreads").setValue(this.mOutboundThreads.toString());
        this.mConfigProps.getProperty("HttpDefaultPort").setValue(this.mHttpDefaultPort.toString());
        this.mConfigProps.getProperty("HttpsDefaultPort").setValue(this.mHttpsDefaultPort.toString());
        this.mConfigProps.getProperty("AMConfigDirectory").setValue(this.mAMConfigDir);
        this.mConfigProps.getProperty("ProxyType").setValue(this.mProxyType);
        this.mConfigProps.getProperty("ProxyHost").setValue(this.mProxyHost);
        this.mConfigProps.getProperty("ProxyPort").setValue(this.mProxyPort.toString());
        this.mConfigProps.getProperty("NonProxyHosts").setValue(this.mNonProxyHosts);
        this.mConfigProps.getProperty("ProxyUserName").setValue(this.mProxyUserName);
        this.mConfigProps.getProperty("ProxyPassword").setValue(this.mProxyPassword);
        this.mConfigProps.getProperty("UseJVMProxySettings").setValue(this.mUseJVMProxySettings.toString());
        return this.mConfigProps;
    }
}

