/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OutboundMessageProcessor;
import com.sun.jbi.httpsoapbc.OutboundMessageProcessorPool;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;

public class OutboundAction
implements Runnable {
    private final OutboundMessageProcessorPool mPool;
    private final MessageExchange mExchange;
    private static final Messages mMessages = Messages.getMessages(OutboundAction.class);
    private static final Logger mLog = Messages.getLogger(OutboundAction.class);

    public OutboundAction(OutboundMessageProcessorPool pool, MessageExchange exchange) {
        this.mPool = pool;
        this.mExchange = exchange;
    }

    public void run() {
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "Processing started for message exchange " + this.mExchange.getExchangeId());
        }
        try {
            OutboundMessageProcessor processor = this.mPool.retrieve();
            processor.processMessage(this.mExchange);
            this.mPool.relinquish(processor);
        }
        catch (Exception ex) {
            String text = mMessages.getString("HTTPBC-E00775.Exception_during_exchange_processing", (Object)this.mExchange.getExchangeId());
            mLog.log(Level.SEVERE, text, ex);
        }
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "Processing completed for message exchange " + this.mExchange.getExchangeId());
        }
    }
}

