/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import com.sun.jbi.httpsoapbc.util.TransformerPool;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class Util {
    private static final TransformerPool cTransformerPool = new TransformerPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node messageAsDom(NormalizedMessage normal) throws TransformerFactoryConfigurationError, TransformerException {
        DOMResult result = new DOMResult();
        Source src = normal.getContent();
        if (src != null) {
            if (src instanceof DOMSource) {
                return ((DOMSource)src).getNode();
            }
            Transformer transformer = cTransformerPool.retrieve();
            try {
                transformer.transform(src, result);
            }
            finally {
                cTransformerPool.relinquish(transformer);
            }
        }
        return result.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toXml(Node node, String encoding, boolean omitXMLDeclaration) throws Exception {
        String ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer trans = cTransformerPool.retrieve();
        try {
            trans.setOutputProperty("encoding", encoding);
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
            trans.transform(new DOMSource(node), new StreamResult(baos));
            ret = baos.toString(encoding);
        }
        finally {
            cTransformerPool.relinquish(trans);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node textAsDom(String text) throws TransformerConfigurationException {
        if (text == null || "".equals(text)) {
            return null;
        }
        StringReader reader = new StringReader(text);
        DOMResult result = new DOMResult();
        StreamSource src = new StreamSource(reader);
        Transformer transformer = cTransformerPool.retrieve();
        try {
            transformer.transform(src, result);
        }
        catch (TransformerException e) {
            result = null;
        }
        finally {
            cTransformerPool.relinquish(transformer);
        }
        return result != null ? result.getNode() : null;
    }
}

