/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.MessageExchangeSupport;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.OperationResolveException;
import com.sun.jbi.httpsoapbc.OperationResolver;
import com.sun.jbi.httpsoapbc.OperationResolver2;
import com.sun.jbi.httpsoapbc.RedeliveryListener;
import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.GUIDUtil;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.api.WSIValidationException;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api.SOAPMsgValidator;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api.SOAPValidatorFactory;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.exchange.ExchangePattern;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import net.java.hulp.measure.Probe;

public class InboundMessageProcessor
implements RedeliveryListener {
    private static final Messages mMessages = Messages.getMessages(InboundMessageProcessor.class);
    private static final Logger mLog = Messages.getLogger(InboundMessageProcessor.class);
    private MessagingChannel mChannel;
    private ComponentContext mContext;
    private MessageExchangeFactory mMessageExchangeFactory;
    private Endpoint mEndpointBean;
    private ServiceEndpoint mEndpointReference;
    private ReplyListener mReplyListener;
    private Normalizer mNormalizer;
    private Object mInput;
    private Transaction mTransaction;
    private SOAPMsgValidator mSoapValidator;
    private MessageContext mMessageContext;
    private Probe mSoapToNMRMeasurement;
    private static Map mInboundExchanges = Collections.synchronizedMap(new HashMap());
    private static Map mExchangeIDToMeta = Collections.synchronizedMap(new HashMap());

    public InboundMessageProcessor(Normalizer normalizer, ReplyListener replyListener) throws MessagingException {
        block4: {
            this.mSoapToNMRMeasurement = null;
            this.mNormalizer = normalizer;
            this.mReplyListener = replyListener;
            try {
                this.ensureInitialized(false);
            }
            catch (Exception ex) {
                if (!mLog.isLoggable(Level.WARNING)) break block4;
                String text = mMessages.getString("HTTPBC-E00741.Initialization_error", (Object)ex.getLocalizedMessage());
                mLog.log(Level.WARNING, text, ex);
                AlertsUtil.getAlerter().critical(text, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00741");
            }
        }
        try {
            this.mSoapValidator = SOAPValidatorFactory.getInstance().createSOAPMsgValidator("1.0", "Error");
        }
        catch (WSIValidationException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    public void setInput(Object input) {
        this.mInput = input;
    }

    public void setTransaction(Transaction transaction) {
        this.mTransaction = transaction;
    }

    public void setTargetEndpoint(Endpoint targetEndpoint) {
        this.mEndpointBean = targetEndpoint;
        this.mEndpointReference = null;
    }

    public void setMessageContext(MessageContext context) {
        this.mMessageContext = context;
    }

    public static Map getInboundExchanges() {
        return mInboundExchanges;
    }

    boolean ensureInitialized(boolean failIfNotReady) throws MessagingException {
        String endpointName = null;
        if (this.mEndpointReference == null) {
            if (this.mContext == null) {
                this.mContext = HttpSoapComponentContext.getInstance().getContext();
            }
            if (this.mContext != null) {
                if (this.mChannel == null) {
                    this.mChannel = HttpSoapComponentContext.getInstance().getBindingChannel();
                }
                if (this.mChannel != null) {
                    if (this.mMessageExchangeFactory == null) {
                        this.mMessageExchangeFactory = this.mChannel.createExchangeFactory();
                    }
                    if (this.mEndpointBean != null) {
                        QName fullServiceName = this.mEndpointBean.getServiceName();
                        endpointName = this.mEndpointBean.getEndpointName();
                        this.mEndpointReference = this.mContext.getEndpoint(fullServiceName, endpointName);
                    } else if (failIfNotReady) {
                        throw new MessagingException("Cannot initialize, no target endpoint has yet been provided");
                    }
                } else if (failIfNotReady) {
                    throw new MessagingException("Cannot initialize, failed to acquire binding channel from component context");
                }
            } else if (failIfNotReady) {
                throw new MessagingException("Cannot initialize, failed to acquire componnt context");
            }
        }
        if (failIfNotReady && this.mEndpointReference == null) {
            String msg = mMessages.getString("HTTPBC-E00151.Provisioner_not_found", endpointName);
            AlertsUtil.getAlerter().warning(msg, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00151");
            throw new MessagingException(msg);
        }
        return this.mEndpointReference != null;
    }

    public String execute(Object clientContext) throws MessagingException {
        try {
            this.ensureInitialized(true);
        }
        catch (MessagingException ex) {
            mLog.log(Level.SEVERE, ex.getMessage(), ex);
            throw ex;
        }
        if (SOAPMessage.class.isInstance(this.mInput)) {
            return this.executeSOAP(clientContext);
        }
        if (DataSource.class.isInstance(this.mInput) || this.mInput == null) {
            String verb = String.valueOf(this.mMessageContext.get((Object)"javax.xml.ws.http.request.method"));
            if ("GET".equals(verb)) {
                return this.executeGet(clientContext);
            }
            if ("POST".equals(verb)) {
                return this.executePost(clientContext);
            }
            String error = mMessages.getString("HTTPBC-E00749.Invalid_HTTP_verb", (Object)verb);
            AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00749");
            throw new MessagingException(error);
        }
        String error = mMessages.getString("HTTPBC-E00750.Unsupported_message_type", (Object)this.mInput.getClass().toString());
        AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00750");
        throw new MessagingException(error);
    }

    void sendInOnly(InOnly inonly, NormalizedMessage inMsg, OperationMetaData operationMetaData) throws MessagingException {
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "Sending message " + inonly.getExchangeId());
        }
        this.checkAndGenerateInMemoryCRMP((MessageExchange)inonly);
        String exchangeId = null;
        inonly.setEndpoint(this.mEndpointReference);
        inonly.setOperation(this.mEndpointBean.createOperationAddress(operationMetaData));
        try {
            inonly.setInMessage(inMsg);
            exchangeId = inonly.getExchangeId();
            mInboundExchanges.put(exchangeId, new Long(System.currentTimeMillis()));
            this.mChannel.send((MessageExchange)inonly);
            this.mEndpointBean.getEndpointStatus().incrementSentRequests();
        }
        catch (MessagingException ex) {
            String error = mMessages.getString("HTTPBC-E00771.Failed_send_inonly");
            mLog.log(Level.SEVERE, error, ex);
            AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00771");
            if (exchangeId != null) {
                mInboundExchanges.remove(exchangeId);
                MessageExchangeSupport.removeRedeliveryListener(exchangeId);
            }
            throw ex;
        }
    }

    void sendInOut(InOut inout, NormalizedMessage inMsg, OperationMetaData operationMetaData) throws MessagingException {
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "Sending message " + inout.getExchangeId());
        }
        this.checkAndGenerateInMemoryCRMP((MessageExchange)inout);
        String exchangeId = null;
        inout.setEndpoint(this.mEndpointReference);
        inout.setOperation(this.mEndpointBean.createOperationAddress(operationMetaData));
        Probe deliverInOutToNMRMeasurement = null;
        try {
            inout.setInMessage(inMsg);
            exchangeId = inout.getExchangeId();
            mInboundExchanges.put(exchangeId, System.currentTimeMillis());
            deliverInOutToNMRMeasurement = Probe.fine(this.getClass(), (String)"deliverInOutToNMR");
            this.mChannel.send((MessageExchange)inout);
            this.mEndpointBean.getEndpointStatus().incrementSentRequests();
            if (this.mSoapToNMRMeasurement != null) {
                this.mSoapToNMRMeasurement.end();
            }
        }
        catch (MessagingException ex) {
            String error = mMessages.getString("HTTPBC-E00772.Failed_send_inout");
            mLog.log(Level.SEVERE, error, ex);
            AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00772");
            if (exchangeId != null) {
                mInboundExchanges.remove(exchangeId);
                MessageExchangeSupport.removeRedeliveryListener(exchangeId);
            }
            throw ex;
        }
        finally {
            if (deliverInOutToNMRMeasurement != null) {
                deliverInOutToNMRMeasurement.end();
            }
        }
    }

    private String executePost(Object clientContext) throws MessagingException {
        String exchangeID;
        block26: {
            exchangeID = null;
            DataSource input = (DataSource)this.mInput;
            OperationMetaData operationMetaData = null;
            String mep = null;
            Map nameToMeta = this.mEndpointBean.getOperationNameToMetaData();
            MessageContext msgContext = this.mMessageContext;
            if (nameToMeta == null || nameToMeta.size() == 0) {
                String error = mMessages.getString("HTTPBC-E00773.Endpoint_as_no_operations", (Object)this.mEndpointBean.getUniqueName());
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00773");
                throw new MessagingException(error);
            }
            try {
                operationMetaData = OperationResolver2.resolveOperation(msgContext, this.mEndpointBean.getUrlContext(), nameToMeta);
            }
            catch (OperationResolveException e) {
                String error = mMessages.getString("HTTPBC-E00701.Operation_not_defined", (Object)this.mEndpointBean.getUniqueName());
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00701");
                throw new MessagingException(error, (Throwable)e);
            }
            mep = operationMetaData.getMessageExchangePattern();
            try {
                if (mep.equalsIgnoreCase("inout")) {
                    InOut inout = this.mMessageExchangeFactory.createInOutExchange();
                    exchangeID = inout.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inout.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inout)) {
                        MessageExchangeSupport.addRedeliveryListener(inout.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(input, (MessageExchange)inout, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    this.sendInOut(inout, inMsg, operationMetaData);
                    break block26;
                }
                if (mep.equalsIgnoreCase("inonly")) {
                    InOnly inonly = this.mMessageExchangeFactory.createInOnlyExchange();
                    exchangeID = inonly.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inonly.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inonly)) {
                        MessageExchangeSupport.addRedeliveryListener(inonly.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(input, (MessageExchange)inonly, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    this.sendInOnly(inonly, inMsg, operationMetaData);
                    if (!operationMetaData.getOneWayReplyAfterProcessing()) {
                        MessageExchangeSupport.notifyOfReply((MessageExchange)inonly);
                    }
                    break block26;
                }
                if (mep.equalsIgnoreCase("robustinonly")) {
                    String error = mMessages.getString("HTTPBC-E00751.MEP_robust_inonly_not_supported", (Object)"");
                    AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00751");
                    mLog.log(Level.SEVERE, error);
                    throw new MessagingException(error);
                }
                String error = mMessages.getString("HTTPBC-E00774.Invalid_pattern", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00774");
                mLog.log(Level.SEVERE, error);
                throw new MessagingException(error);
            }
            catch (MessagingException ex) {
                String error = mMessages.getString("HTTPBC-E00748.Exception_during_exchange_processing", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00748");
                mLog.log(Level.SEVERE, error, ex);
                throw ex;
            }
        }
        return exchangeID;
    }

    private String executeGet(Object clientContext) throws MessagingException {
        String exchangeID;
        block26: {
            exchangeID = null;
            DataSource input = (DataSource)this.mInput;
            OperationMetaData operationMetaData = null;
            String mep = null;
            MessageContext msgContext = this.mMessageContext;
            Map nameToMeta = this.mEndpointBean.getOperationNameToMetaData();
            if (nameToMeta == null || nameToMeta.size() == 0) {
                String error = mMessages.getString("HTTPBC-E00773.Endpoint_as_no_operations", (Object)this.mEndpointBean.getUniqueName());
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00773");
                throw new MessagingException(error);
            }
            MessageContext context = this.mMessageContext;
            try {
                operationMetaData = OperationResolver2.resolveOperation(msgContext, this.mEndpointBean.getUrlContext(), nameToMeta);
            }
            catch (OperationResolveException e) {
                String error = mMessages.getString("HTTPBC-E00701.Operation_not_defined", (Object)this.mEndpointBean.getUniqueName());
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00701");
                throw new MessagingException(error, (Throwable)e);
            }
            mep = operationMetaData.getMessageExchangePattern();
            try {
                String error;
                if (mep.equalsIgnoreCase("inout")) {
                    InOut inout = this.mMessageExchangeFactory.createInOutExchange();
                    exchangeID = inout.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inout.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inout)) {
                        MessageExchangeSupport.addRedeliveryListener(inout.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(msgContext, (MessageExchange)inout, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    this.sendInOut(inout, inMsg, operationMetaData);
                    break block26;
                }
                if (mep.equalsIgnoreCase("inonly")) {
                    InOnly inonly = this.mMessageExchangeFactory.createInOnlyExchange();
                    exchangeID = inonly.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inonly.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inonly)) {
                        MessageExchangeSupport.addRedeliveryListener(inonly.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(msgContext, (MessageExchange)inonly, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    this.sendInOnly(inonly, inMsg, operationMetaData);
                    if (!operationMetaData.getOneWayReplyAfterProcessing()) {
                        MessageExchangeSupport.notifyOfReply((MessageExchange)inonly);
                    }
                    break block26;
                }
                if (mep.equalsIgnoreCase("robustinonly")) {
                    error = mMessages.getString("HTTPBC-E00751.MEP_robust_inonly_not_supported", (Object)"");
                    AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00751");
                    mLog.log(Level.SEVERE, error);
                    throw new MessagingException(error);
                }
                error = mMessages.getString("HTTPBC-E00774.Invalid_pattern", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00774");
                mLog.log(Level.SEVERE, error);
                throw new MessagingException(error);
            }
            catch (MessagingException ex) {
                String error = mMessages.getString("HTTPBC-E00748.Exception_during_exchange_processing", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00748");
                mLog.log(Level.SEVERE, error, ex);
                throw ex;
            }
        }
        return exchangeID;
    }

    private String executeSOAP(Object clientContext) throws MessagingException {
        String exchangeID;
        block38: {
            Map nameToMeta;
            String errorMsg;
            exchangeID = null;
            OperationMetaData operationMetaData = null;
            String mep = null;
            SOAPMessage soapMsg = this.mNormalizer.toSOAPMessage(this.mInput);
            try {
                this.mSoapValidator.validate(soapMsg);
            }
            catch (WSIValidationException e) {
                throw new MessagingException(e.getMessage(), (Throwable)e);
            }
            String warnMsg = this.mSoapValidator.getWarningMsg();
            if (warnMsg != null && mLog.isLoggable(Level.WARNING)) {
                String error = mMessages.getString("HTTPBC-E00741.Soap_validator_error", (Object)warnMsg);
                mLog.log(Level.WARNING, error);
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00741");
            }
            if ((errorMsg = this.mSoapValidator.getErrorMsg()) != null) {
                throw new MessagingException(errorMsg);
            }
            Subject subject = this.mEndpointBean.getSubject();
            if (subject == null) {
                subject = this.mEndpointBean.getEndpointSecurityManager().getSubject();
            }
            if ((nameToMeta = this.mEndpointBean.getOperationNameToMetaData()) == null || nameToMeta.size() == 0) {
                String error = mMessages.getString("HTTPBC-E00773.Endpoint_as_no_operations", (Object)this.mEndpointBean.getUniqueName());
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00773");
                throw new MessagingException(error);
            }
            if (nameToMeta.size() == 1) {
                Map.Entry firstEntry = nameToMeta.entrySet().iterator().next();
                operationMetaData = (OperationMetaData)firstEntry.getValue();
            } else {
                operationMetaData = OperationResolver.resolveOperation(soapMsg, nameToMeta);
                if (operationMetaData == null) {
                    String error = mMessages.getString("HTTPBC-E00701.Operation_not_defined", (Object)this.mEndpointBean.getUniqueName());
                    AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00701");
                    throw new MessagingException(error);
                }
            }
            mep = operationMetaData.getMessageExchangePattern();
            try {
                String error;
                if (mep.equalsIgnoreCase("inout")) {
                    InOut inout = this.mMessageExchangeFactory.createInOutExchange();
                    exchangeID = inout.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inout.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inout)) {
                        MessageExchangeSupport.addRedeliveryListener(inout.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(soapMsg, (MessageExchange)inout, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (subject != null) {
                        inMsg.setSecuritySubject(subject);
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    if (this.mTransaction != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            mLog.log(Level.FINE, "Transaction context present in the inbound request, about to set the transaction property in the InOut Message exchange...");
                        }
                        inout.setProperty("javax.jbi.transaction.jta", (Object)this.mTransaction);
                    }
                    this.sendInOut(inout, inMsg, operationMetaData);
                    break block38;
                }
                if (mep.equalsIgnoreCase("inonly")) {
                    InOnly inonly = this.mMessageExchangeFactory.createInOnlyExchange();
                    exchangeID = inonly.getExchangeId();
                    MessageExchangeSupport.addReplyListener(inonly.getExchangeId(), this.mReplyListener, clientContext);
                    if (this.isRetryEnabled((MessageExchange)inonly)) {
                        MessageExchangeSupport.addRedeliveryListener(inonly.getExchangeId(), this, operationMetaData, clientContext);
                    }
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)this.mEndpointBean.getUniqueName(), (String)"Normalization");
                    NormalizedMessage inMsg = null;
                    try {
                        inMsg = this.mNormalizer.normalize(soapMsg, (MessageExchange)inonly, operationMetaData, this.mMessageContext);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    if (subject != null) {
                        inMsg.setSecuritySubject(subject);
                    }
                    if (mLog.isLoggable(Level.FINE)) {
                        DebugLog.debugLog(mLog, Level.FINE, "Sending to component this normalized message", inMsg.getContent());
                    }
                    if (this.mTransaction != null) {
                        if (mLog.isLoggable(Level.FINE)) {
                            mLog.log(Level.FINE, "Transaction context present in the inbound request, about to set the transaction property in the InOnly Message exchange...");
                        }
                        inonly.setProperty("javax.jbi.transaction.jta", (Object)this.mTransaction);
                    }
                    this.sendInOnly(inonly, inMsg, operationMetaData);
                    if (!operationMetaData.getOneWayReplyAfterProcessing()) {
                        MessageExchangeSupport.notifyOfReply((MessageExchange)inonly);
                    }
                    break block38;
                }
                if (mep.equalsIgnoreCase("robustinonly")) {
                    error = mMessages.getString("HTTPBC-E00751.MEP_robust_inonly_not_supported", (Object)"");
                    AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00751");
                    mLog.log(Level.SEVERE, error);
                    throw new MessagingException(error);
                }
                error = mMessages.getString("HTTPBC-E00774.Invalid_pattern", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00774");
                mLog.log(Level.SEVERE, error);
                throw new MessagingException(error);
            }
            catch (MessagingException ex) {
                String error = mMessages.getString("HTTPBC-E00748.Exception_during_exchange_processing", new Object[]{mep, this.mEndpointBean.getUniqueName()});
                AlertsUtil.getAlerter().warning(error, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00748");
                mLog.log(Level.SEVERE, error, ex);
                throw ex;
            }
        }
        return exchangeID;
    }

    public void setMeasurement(Probe m) {
        this.mSoapToNMRMeasurement = m;
    }

    public void setMessageExchangeId(String messageExchangeId, OperationMetaData retryMetaData, Object clientContext) {
        mExchangeIDToMeta.put(messageExchangeId, new Object[]{retryMetaData, clientContext});
    }

    public void onRedelivery(MessageExchange exchange) throws MessagingException {
        Object[] metadata = (Object[])mExchangeIDToMeta.remove(exchange.getExchangeId());
        if (metadata.length != 2 && metadata[0] instanceof OperationMetaData) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00803.Cannot_find_metadata_for_retry", (Object)exchange.getExchangeId()));
        }
        OperationMetaData operationMetaData = (OperationMetaData)metadata[0];
        Object clientContext = metadata[1];
        if (clientContext == null) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00804.Cannot-find_callback_context", (Object)exchange.getExchangeId()));
        }
        String groupId = (String)exchange.getProperty("com.sun.jbi.messaging.groupid");
        String messageId = (String)exchange.getProperty("com.sun.jbi.messaging.messageid");
        MessageExchangeSupport.removeRedeliveryListener(exchange.getExchangeId());
        MessageExchangeSupport.removeReplyListener(exchange.getExchangeId(), true);
        switch (ExchangePattern.valueOf((MessageExchange)exchange)) {
            case IN_OUT: {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Resending the InOut exchange with group ID '" + groupId + "' and message ID '" + messageId + "'...");
                }
                NormalizedMessage inMsg = ((InOut)exchange).getInMessage();
                InOut inout = this.mMessageExchangeFactory.createInOutExchange();
                inout.setProperty("com.sun.jbi.messaging.groupid", (Object)groupId);
                inout.setProperty("com.sun.jbi.messaging.messageid", (Object)messageId);
                if (this.mTransaction != null) {
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.log(Level.FINE, "Transaction context present in the inbound request, about to set the transaction property in the InOut Message exchange for the resend...");
                    }
                    inout.setProperty("javax.jbi.transaction.jta", (Object)this.mTransaction);
                }
                MessageExchangeSupport.addReplyListener(inout.getExchangeId(), this.mReplyListener, clientContext);
                MessageExchangeSupport.addRedeliveryListener(inout.getExchangeId(), this, operationMetaData, clientContext);
                this.sendInOut(inout, inMsg, operationMetaData);
                break;
            }
            case IN_ONLY: {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Resending the InOnly exchange with group ID '" + groupId + "' and message ID '" + messageId + "'...");
                }
                NormalizedMessage inMsg = ((InOnly)exchange).getInMessage();
                InOnly inonly = this.mMessageExchangeFactory.createInOnlyExchange();
                inonly.setProperty("com.sun.jbi.messaging.groupid", (Object)groupId);
                inonly.setProperty("com.sun.jbi.messaging.messageid", (Object)messageId);
                if (this.mTransaction != null) {
                    if (mLog.isLoggable(Level.FINE)) {
                        mLog.log(Level.FINE, "Transaction context present in the inbound request, about to set the transaction property in the InOnly Message exchange for the resend...");
                    }
                    inonly.setProperty("javax.jbi.transaction.jta", (Object)this.mTransaction);
                }
                MessageExchangeSupport.addReplyListener(inonly.getExchangeId(), this.mReplyListener, clientContext);
                MessageExchangeSupport.addRedeliveryListener(inonly.getExchangeId(), this, operationMetaData, clientContext);
                this.sendInOnly(inonly, inMsg, operationMetaData);
                break;
            }
            default: {
                if (!mLog.isLoggable(Level.FINE)) break;
                mLog.log(Level.FINE, "Retry handler receives an unsupported exchange pattern: " + ExchangePattern.valueOf((MessageExchange)exchange) + ". Ignoring the retry attempt...");
            }
        }
    }

    private String getServiceUnitID() {
        return this.mEndpointBean != null ? this.mEndpointBean.getServiceUnitID() : null;
    }

    private void checkAndGenerateInMemoryCRMP(MessageExchange mex) {
        if (mex.getProperty("com.sun.jbi.messaging.groupid") == null || mex.getProperty("com.sun.jbi.messaging.messageid") == null) {
            String groupId = GUIDUtil.generateGUID();
            String messageId = Long.toString(this.mEndpointBean.getCRMPMessageId());
            mex.setProperty("com.sun.jbi.messaging.groupid", (Object)groupId);
            mex.setProperty("com.sun.jbi.messaging.messageid", (Object)messageId);
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "The request received is not a ws-rm enabled message; generated com.sun.jbi.messaging.groupid with value [" + groupId + "] and " + "com.sun.jbi.messaging.messageid" + " with value [" + messageId + "] for message exchange with ID [" + mex.getExchangeId() + "]");
            }
        }
    }

    private boolean isRetryEnabled(MessageExchange exchange) {
        boolean shouldRetry = false;
        EndpointInfo info = new EndpointInfo(false, this.mEndpointBean.getEndpointName(), null, this.mEndpointBean.getServiceName(), null);
        RedeliveryConfig retryConfig = (RedeliveryConfig)this.mChannel.getServiceQuality(info, RedeliveryConfig.class);
        if (retryConfig == null) {
            return shouldRetry;
        }
        RedeliveryConfig.Failure onFailureOption = retryConfig.getFailure();
        switch (ExchangePattern.valueOf((MessageExchange)exchange)) {
            case IN_OUT: {
                if (onFailureOption == RedeliveryConfig.Failure.redirect || onFailureOption == RedeliveryConfig.Failure.delete) {
                    String option = onFailureOption == RedeliveryConfig.Failure.redirect ? "redirect" : "delete";
                    String warningMsg = mMessages.getString("HTTPBC-W00807.Unsupported_onfailure_option", (Object)option);
                    if (mLog.isLoggable(Level.WARNING)) {
                        mLog.log(Level.WARNING, warningMsg);
                    }
                    AlertsUtil.getAlerter().warning(warningMsg, "sun-http-binding", this.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00805");
                }
                shouldRetry = retryConfig != null && retryConfig.getMaxRetries() > 0 && (onFailureOption == RedeliveryConfig.Failure.suspend || onFailureOption == RedeliveryConfig.Failure.error);
                break;
            }
            case IN_ONLY: {
                shouldRetry = retryConfig != null && retryConfig.getMaxRetries() > 0;
                break;
            }
        }
        return shouldRetry;
    }
}

