/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.jaxwssupport;

import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.FaultException;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.SoapDenormalizer;
import com.sun.jbi.httpsoapbc.util.StringUtil;
import com.sun.jbi.internationalization.Messages;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.http.HTTPException;

public class JAXWSDenormalizer
implements Denormalizer {
    private static final Messages mMessages = Messages.getMessages(JAXWSDenormalizer.class);
    private static final Logger mLogger = Messages.getLogger(JAXWSDenormalizer.class);
    private static final QName FAULT_DETAIL_ENTRY_QNAME = new QName("detailText");
    private static final String COMPONENT_NAME = "sun-http-bc";
    static MessageFactory factory = null;
    SoapDenormalizer denormalizer = new SoapDenormalizer();

    public Object denormalize(NormalizedMessage messageToDenormalize, MessageExchange exchange, Object targetToNormalizeTo, OperationMetaData operationMetaData) throws MessagingException {
        SOAPMessage denormalizedMsg = null;
        try {
            denormalizedMsg = this.denormalizer.denormalize(messageToDenormalize, exchange, operationMetaData, factory, false);
        }
        catch (Exception ex) {
            throw new MessagingException((Throwable)ex);
        }
        return denormalizedMsg;
    }

    public Object denormalizeException(Throwable exceptionToHandle, Object targetToNormalizeTo) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Populating SOAP reply with a fault for the following exception.", exceptionToHandle);
        }
        SOAPMessage denormalizedMsg = null;
        try {
            String faultCode = "Server";
            String faultActor = "";
            String faultString = "";
            String faultDetail = "";
            if (exceptionToHandle instanceof FaultException) {
                FaultException faultException = (FaultException)exceptionToHandle;
                faultCode = this.sanitize(faultException.getFaultCode());
                faultActor = this.sanitize(faultException.getFaultActor());
                faultString = this.sanitize(faultException.getFaultString());
                faultDetail = this.sanitize(faultException.getDetail());
            } else {
                faultString = this.sanitize(exceptionToHandle.getMessage());
            }
            if ("".equals(faultString)) {
                faultString = this.sanitize(exceptionToHandle.getClass().getName());
            }
            denormalizedMsg = factory.createMessage();
            if (faultCode.indexOf(58) == -1) {
                String prefix = denormalizedMsg.getSOAPPart().getEnvelope().getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                faultCode = prefix + ":" + faultCode;
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Populating fault with code: " + faultCode + ", string: " + faultString);
            }
            SOAPBody body = denormalizedMsg.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultCode(faultCode);
            fault.setFaultString(faultString);
            if (faultActor != null) {
                fault.setFaultActor(faultActor);
            }
            if (faultDetail != null) {
                this.addFaultDetail(fault, faultDetail);
            }
            if (denormalizedMsg.saveRequired()) {
                denormalizedMsg.saveChanges();
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.WARNING, "HTTPBC-W00639.Failed_to_populate_SOAP_fault_with_exception", ex);
            throw new HTTPException(500);
        }
        return denormalizedMsg;
    }

    public Object denormalizeError(MessageExchange exchange, Object outlet) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Populating SOAP reply with a fault for exchange " + exchange.getExchangeId() + " with error status.");
        }
        SOAPMessage denormalizedMsg = null;
        try {
            String faultString;
            String faultActor;
            String faultCode = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultcode"));
            if ("".equals(faultCode)) {
                faultCode = "Server";
            }
            if ("".equals(faultActor = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultactor")))) {
                faultActor = COMPONENT_NAME;
            }
            if ("".equals(faultString = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultstring")))) {
                String name = exchange.getError().getClass().getName();
                String message = exchange.getError().getLocalizedMessage();
                faultString = message == null || "".equals(message) ? name : name + ": " + message;
            }
            String faultDetail = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultdetail"));
            denormalizedMsg = factory.createMessage();
            if (faultCode.indexOf(58) == -1) {
                String prefix = denormalizedMsg.getSOAPPart().getEnvelope().getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                faultCode = prefix + ":" + faultCode;
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Populating fault with code: " + faultCode + ", string: " + faultString);
            }
            SOAPBody body = denormalizedMsg.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultCode(faultCode);
            fault.setFaultString(faultString);
            fault.setFaultActor(faultActor);
            if (!"".equals(faultDetail)) {
                this.addFaultDetail(fault, faultDetail);
            }
            if (denormalizedMsg.saveRequired()) {
                denormalizedMsg.saveChanges();
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.WARNING, "HTTPBC-W00639.Failed_to_populate_SOAP_fault_with_exception", ex);
            throw new HTTPException(500);
        }
        return denormalizedMsg;
    }

    public Object denormalizeError(MessageExchange exchange, String faultDetail) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Populating SOAP reply with a fault for exchange " + exchange.getExchangeId() + " with error status.");
        }
        SOAPMessage denormalizedMsg = null;
        try {
            String faultString;
            String faultActor;
            String faultCode = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultcode"));
            if ("".equals(faultCode)) {
                faultCode = "Server";
            }
            if ("".equals(faultActor = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultactor")))) {
                faultActor = COMPONENT_NAME;
            }
            if ("".equals(faultString = this.sanitize(exchange.getProperty("com.sun.jbi.crl.faultstring")))) {
                String name = exchange.getError().getClass().getName();
                String message = exchange.getError().getLocalizedMessage();
                faultString = message == null || "".equals(message) ? name : name + ": " + message;
            }
            denormalizedMsg = factory.createMessage();
            if (faultCode.indexOf(58) == -1) {
                String prefix = denormalizedMsg.getSOAPPart().getEnvelope().getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                faultCode = prefix + ":" + faultCode;
            }
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Populating fault with code: " + faultCode + ", string: " + faultString);
            }
            SOAPBody body = denormalizedMsg.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultCode(faultCode);
            fault.setFaultString(faultString);
            fault.setFaultActor(faultActor);
            if (faultDetail != null && !"".equals(faultDetail)) {
                this.addFaultDetail(fault, faultDetail);
            }
            if (denormalizedMsg.saveRequired()) {
                denormalizedMsg.saveChanges();
            }
        }
        catch (Exception ex) {
            mLogger.log(Level.WARNING, "HTTPBC-W00639.Failed_to_populate_SOAP_fault_with_exception", ex);
            throw new HTTPException(500);
        }
        return denormalizedMsg;
    }

    private void addFaultDetail(SOAPFault fault, String faultDetail) throws SOAPException {
        Detail detail = fault.getDetail();
        if (detail == null) {
            detail = fault.addDetail();
        }
        DetailEntry entry = null;
        Iterator detailEntries = detail.getDetailEntries();
        while (detailEntries.hasNext()) {
            DetailEntry e = (DetailEntry)detailEntries.next();
            QName entryName = e.getElementQName();
            if (!FAULT_DETAIL_ENTRY_QNAME.equals(entryName)) continue;
            entry = e;
            break;
        }
        if (entry == null) {
            entry = detail.addDetailEntry(FAULT_DETAIL_ENTRY_QNAME);
        }
        entry.addTextNode(faultDetail);
    }

    private String sanitize(Object val) {
        String result = "";
        if (val != null) {
            result = StringUtil.escapeXML(val.toString());
        }
        return result;
    }

    static {
        try {
            factory = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            mLogger.log(Level.SEVERE, "HTTPBC-E00631.Failed_to_initialize_SOAP_message_factory", ex);
        }
    }
}

