/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.nms.wsdl11wrapper.util;

import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WrapperUtil {
    public static final String WRAPPER_DEFAULT_NAMESPACE_PREFIX = "jbi";
    public static final String WRAPPER_DEFAULT_NAMESPACE = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    public static final String WRAPPER_MESSAGE = "jbi:message";
    public static final String WRAPPER_ATTRIBUTE_VERSION = "version";
    public static final String WRAPPER_ATTRIBUTE_VERSION_VALUE = "1.0";
    public static final String WRAPPER_ATTRIBUTE_TYPE = "type";
    public static final String WRAPPER_ATTRIBUTE_NAME = "name";
    public static final String WRAPPER_PART = "jbi:part";

    public static Element createJBIMessageWrapper(Document normalDoc, QName type, String name) {
        Element msgWrapper = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_MESSAGE);
        msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_VERSION, WRAPPER_ATTRIBUTE_VERSION_VALUE);
        String prefix = type.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            prefix = "msgns";
        }
        msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_TYPE, prefix + ":" + type.getLocalPart());
        msgWrapper.setAttribute("xmlns:" + prefix, type.getNamespaceURI());
        if (name != null) {
            msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_NAME, name);
        }
        return msgWrapper;
    }

    public static Element createJBIWrappedPart(Document normalDoc, NodeList part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            int noOfNodes = part.getLength();
            for (int nodeCount = 0; nodeCount < noOfNodes; ++nodeCount) {
                wrapperElem.appendChild(part.item(nodeCount));
            }
        }
        return wrapperElem;
    }

    public static Element createJBIWrappedPart(Document normalDoc, Node part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            wrapperElem.appendChild(part);
        }
        return wrapperElem;
    }

    public static Map extractNamespaceDeclarations(Element elem) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (elem != null) {
            NamedNodeMap attr = elem.getAttributes();
            int len = attr.getLength();
            for (int i = 0; i < len; ++i) {
                Attr a;
                String name;
                Node n = attr.item(i);
                if (!(n instanceof Attr) || !(name = (a = (Attr)n).getName()).startsWith("xmlns:")) continue;
                map.put(name, a.getValue());
            }
        }
        return map;
    }

    public static Element importJBIWrappedPart(Document normalDoc, NodeList part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            int noOfNodes = part.getLength();
            for (int nodeCount = 0; nodeCount < noOfNodes; ++nodeCount) {
                Node aNode = part.item(nodeCount - (noOfNodes - part.getLength()));
                if (aNode == null) continue;
                if (!aNode.getOwnerDocument().isSameNode(normalDoc)) {
                    aNode = normalDoc.importNode(aNode, true);
                }
                wrapperElem.appendChild(aNode);
            }
        }
        return wrapperElem;
    }

    public static Element importJBIWrappedPart(Document normalDoc, Node part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            if (!part.getOwnerDocument().isSameNode(normalDoc)) {
                part = normalDoc.importNode(part, true);
            }
            wrapperElem.appendChild(part);
        }
        return wrapperElem;
    }

    public static Element getPartElement(Document wrappedDoc) throws WrapperProcessingException {
        Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
        if (jbiMessageWrapper.getTagName().equalsIgnoreCase(WRAPPER_MESSAGE)) {
            NodeList childNodesI = jbiMessageWrapper.getChildNodes();
            int I = childNodesI.getLength();
            for (int i = 0; i < I; ++i) {
                Element jbiPartWrapper;
                Node nodeI = childNodesI.item(i);
                if (nodeI.getNodeType() != 1 || !(jbiPartWrapper = (Element)nodeI).getTagName().equalsIgnoreCase(WRAPPER_PART)) continue;
                NodeList childNodesJ = jbiPartWrapper.getChildNodes();
                int J = childNodesJ.getLength();
                for (int j = 0; j < J; ++j) {
                    Node nodeJ = childNodesJ.item(j);
                    if (nodeJ.getNodeType() != 1) continue;
                    return (Element)nodeJ;
                }
            }
        }
        return null;
    }

    public static Element getPartElement(Element jbiMessageWrapper) throws WrapperProcessingException {
        if (jbiMessageWrapper.getTagName().equalsIgnoreCase(WRAPPER_MESSAGE)) {
            NodeList childNodesI = jbiMessageWrapper.getChildNodes();
            int I = childNodesI.getLength();
            for (int i = 0; i < I; ++i) {
                Element jbiPartWrapper;
                Node nodeI = childNodesI.item(i);
                if (nodeI.getNodeType() != 1 || !(jbiPartWrapper = (Element)nodeI).getTagName().equalsIgnoreCase(WRAPPER_PART)) continue;
                NodeList childNodesJ = jbiPartWrapper.getChildNodes();
                int J = childNodesJ.getLength();
                for (int j = 0; j < J; ++j) {
                    Node nodeJ = childNodesJ.item(j);
                    if (nodeJ.getNodeType() != 1) continue;
                    return (Element)nodeJ;
                }
            }
        }
        return null;
    }

    public static List getPartTextList(Document wrappedDoc) throws WrapperProcessingException {
        ArrayList<String> list = new ArrayList<String>();
        Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
        if (jbiMessageWrapper.getTagName().equalsIgnoreCase(WRAPPER_MESSAGE)) {
            NodeList childNodesI = jbiMessageWrapper.getChildNodes();
            int I = childNodesI.getLength();
            block0: for (int i = 0; i < I; ++i) {
                Element jbiPartWrapper;
                Node nodeI = childNodesI.item(i);
                if (nodeI.getNodeType() != 1 || !(jbiPartWrapper = (Element)nodeI).getTagName().equalsIgnoreCase(WRAPPER_PART)) continue;
                NodeList childNodesJ = jbiPartWrapper.getChildNodes();
                int J = childNodesJ.getLength();
                for (int j = 0; j < J; ++j) {
                    Node nodeJ = childNodesJ.item(j);
                    if (nodeJ.getNodeType() != 3) continue;
                    list.add(nodeJ.getTextContent());
                    continue block0;
                }
            }
        }
        return list;
    }

    public static boolean isMessageWrapped(Document doc) {
        String nsURI;
        Element jbiMessageWrapper;
        boolean wrapperDetected = false;
        if (doc != null && (jbiMessageWrapper = doc.getDocumentElement()) != null && (nsURI = jbiMessageWrapper.getNamespaceURI()) != null && nsURI.equals(WRAPPER_DEFAULT_NAMESPACE)) {
            wrapperDetected = true;
        }
        return wrapperDetected;
    }
}

