/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.util;

import net.sf.hulp.util.Markup;

public class MarkupHtml
extends Markup {
    private static final int MAXTABLES = 20;
    private Table[] mTableStack = new Table[20];
    private int m_iTable = -1;
    static int hideRandom = 0;

    public String beginHide(String link) {
        return this.beginHide(link, "showhideid" + Integer.toString(++hideRandom));
    }

    public String beginHide(String link, String id) {
        return "<a href=\"javascript:nothing()\" onclick=\"javascript:showit('" + id + "')\">" + link + "</a>\n" + "<div ID=\"" + id + "\" style=\"display: 'none'\">\n";
    }

    public String endHide() {
        return "</div>";
    }

    public String beginTable(int style) {
        switch (style) {
            case 0: {
                this.mTableStack[++this.m_iTable] = new SimpleTable();
                break;
            }
            case 1: {
                this.mTableStack[++this.m_iTable] = new BannerTableEgal();
                break;
            }
            case 2: {
                this.mTableStack[++this.m_iTable] = new BannerTableEgal();
                break;
            }
            case 3: {
                this.mTableStack[++this.m_iTable] = new TableBare();
                break;
            }
            default: {
                this.mTableStack[++this.m_iTable] = new SimpleTable();
            }
        }
        return this.mTableStack[this.m_iTable].beginTable();
    }

    public String endTable() {
        return this.mTableStack[this.m_iTable--].endTable();
    }

    public String beginRow() {
        return this.mTableStack[this.m_iTable].beginRow();
    }

    public String beginRow(int span) {
        return this.mTableStack[this.m_iTable].beginRow(span);
    }

    public String beginHRow() {
        return this.mTableStack[this.m_iTable].beginHRow();
    }

    public String beginHRow(int span) {
        return this.mTableStack[this.m_iTable].beginHRow(span);
    }

    public String endRow() {
        return this.mTableStack[this.m_iTable].endRow();
    }

    public String tab() {
        return this.mTableStack[this.m_iTable].tab();
    }

    public String tab(int span) {
        return this.mTableStack[this.m_iTable].tab(span);
    }

    public String br() {
        return "<BR>\r\n";
    }

    public String beginArea() {
        return "<Table Border=1 CELLSPACING=0 bordercolor=#6699CC bordercolordark=#6699CC bordercolorlight=#6699CC BGCOLOR=#6699CC><TR><TD>\r\n";
    }

    public String endArea() {
        return "</TD></TR></Table>\r\n";
    }

    public String caption(String str) {
        return "<br><font size=+1><b>" + str + "</b></font><br>";
    }

    public String bold(String str) {
        return "<b>" + str + "</b>";
    }

    public String strong(String str) {
        return "<font color=red><b>" + str + "</b></font>";
    }

    public String fine(String str) {
        return "<small>" + str + "</small>";
    }

    public String beginPage() {
        return "<html><head>\n<SCRIPT LANGUAGE=\"JavaScript\"><!--\nfunction showit(w) {\n  if ( document.all[w].style.display == 'none') document.all[w].style.display = \"\"\n  else document.all[w].style.display = \"none\";\n}\nfunction nothing() {}\n--></script>\n<STYLE TYPE='text/css'>\nA         { TEXT-DECORATION: none }\nA:link    { color:maroon; font-style: normal; } \nA:visited { color:maroon; font-style: normal; } \nA:hover   { COLOR: blue; }\n.tblh1    {color:#FFFFFF;text-decoration:none;font: 12px verdana background-color: #055F9D; color: #FFFFFF\"}\n.tbrwlt   {color:#FFFFFF;text-decoration:none;font: 12px verdana}\n\n</STYLE>\n</head><body>\n<BASEFONT FACE=\"Verdana, Arial, Helvetica\" SIZE=\"2\">\n";
    }

    public String endPage() {
        return "</body></html>";
    }

    public String makeSafe(String val) {
        return MarkupHtml.xmlNormalize(val);
    }

    public String beginPre() {
        return "<pre>";
    }

    public String endPre() {
        return "</pre>";
    }

    public String pageFrame() {
        return "<HTML><HEAD></HEAD><FRAMESET ROWS='22,*' FRAMEBORDER=0 FRAMESPACING=0 BORDER=0>\r\n<FRAME NAME='menu' SCROLLING='NO' NORESIZE TARGET='body' SRC='?menu' marginwidth='2' marginheight='2'>\r\n<FRAME NAME='body' SRC='?body'>\r\n</FRAMESET>\r\n</HTML>";
    }

    public String link(String url) {
        return "<A HREF='" + url + "'>";
    }

    public String link() {
        return "</A>";
    }

    public static String xmlNormalize(String s) {
        StringBuffer ret = new StringBuffer(s.length());
        String esc = null;
        int end = s.length();
        for (int i = 0; i < end; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    esc = "&lt;";
                    break;
                }
                case '>': {
                    esc = "&gt;";
                    break;
                }
                case '&': {
                    esc = "&amp;";
                    break;
                }
                case '\"': {
                    esc = "&quot;";
                    break;
                }
                case '\'': {
                    esc = "&apos;";
                    break;
                }
                default: {
                    if (' ' <= ch && ch <= '~') break;
                    esc = "&#x";
                    for (int n = 12; n >= 0; n -= 4) {
                        esc = esc + "0123456789ABCDEF".charAt(ch >> n & 0xF);
                    }
                    esc = esc + ";";
                }
            }
            if (esc != null) {
                ret.append(esc);
                esc = null;
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    private class TableBare
    extends Table {
        private boolean m_headerRowDone;

        private TableBare() {
            this.m_headerRowDone = false;
        }

        String beginTable() {
            return "<Table Border=0 CELLSPACING=0 width='100%'>";
        }

        String beginRow() {
            return this.m_headerRowDone ? "<TR VALIGN=\"TOP\"><TD>" : "<TR VALIGN=\"TOP\"><TD>";
        }

        String beginRow(int span) {
            return this.m_headerRowDone ? "<TR VALIGN=\"TOP\"><TD COLSPAN=\"" + Integer.toString(span) + "\">" : "<TR VALIGN=\"TOP\"><TD COLSPAN=\"" + Integer.toString(span) + "\">";
        }

        String beginHRow() {
            this.m_headerRowDone = false;
            return this.beginRow();
        }

        String beginHRow(int span) {
            this.m_headerRowDone = false;
            return this.beginRow(span);
        }

        String tab() {
            return this.m_headerRowDone ? "&nbsp; </TD><TD>" : "&nbsp; </TD><TD>";
        }

        String tab(int span) {
            return this.m_headerRowDone ? "&nbsp; </TD><TD COLSPAN=\"" + Integer.toString(span) + "\">" : "&nbsp; </TD><TD COLSPAN=\"" + Integer.toString(span) + "\">";
        }

        String endRow() {
            this.m_headerRowDone = true;
            return super.endRow();
        }
    }

    private class BannerTableEgal
    extends Table {
        private boolean mHeaderRowDone;

        private BannerTableEgal() {
            this.mHeaderRowDone = false;
        }

        String beginTable() {
            return "<table border=\"1\" cellpadding=\"2\"  Border=1 CELLSPACING=0 bordercolor=#C0C0C0 bordercolordark=#FFFFFF bordercolorlight=#FFFFFF>\n";
        }

        String beginRow() {
            if (!this.mHeaderRowDone) {
                return "  <tr valign=\"top\">\n    <td style=\"background-color: #055F9D; color: #FFFFFF\" class=\"tblh1\" valign=\"top\">";
            }
            return "  <tr>\n    <td style=\"color: #000000\" class=\"tbrwlt\" bgcolor=\"#E5EAED\" valign=\"top\">";
        }

        String beginRow(int span) {
            if (!this.mHeaderRowDone) {
                return "  <tr valign=\"top\">\n    <td style=\"background-color: #055F9D; color: #FFFFFF\" class=\"tblh1\" valign=\"top\" COLSPAN=\"" + Integer.toString(span) + "\">";
            }
            return "  <tr>\n    <td style=\"color: #000000\" class=\"tbrwlt\" bgcolor=\"#E5EAED\" valign=\"top\" COLSPAN=\"" + Integer.toString(span) + "\">";
        }

        String beginHRow() {
            this.mHeaderRowDone = false;
            return this.beginRow();
        }

        String beginHRow(int span) {
            this.mHeaderRowDone = false;
            return this.beginRow(span);
        }

        String tab() {
            if (!this.mHeaderRowDone) {
                return "&nbsp; </td>\n    <td style=\"background-color: #055F9D; color: #FFFFFF\" class=\"tblh1\" valign=\"top\">";
            }
            return "&nbsp; </td>\n    <td style=\"color: #000000\" class=\"tbrwlt\" bgcolor=\"#E5EAED\" valign=\"top\">";
        }

        String tab(int span) {
            if (!this.mHeaderRowDone) {
                return "&nbsp; </td>\n    <td style=\"background-color: #055F9D; color: #FFFFFF\" class=\"tblh1\" valign=\"top\" COLSPAN=\"" + Integer.toString(span) + "\">";
            }
            return "&nbsp; </td>\n    <td style=\"color: #000000\" class=\"tbrwlt\" bgcolor=\"#E5EAED\" valign=\"top\" COLSPAN=\"" + Integer.toString(span) + "\">";
        }

        String endRow() {
            this.mHeaderRowDone = true;
            return "</TD></TR>";
        }
    }

    private static class SimpleTable
    extends Table {
        private SimpleTable() {
        }

        String beginTable() {
            return "<Table Border=1 CELLSPACING=0 bordercolor=#C0C0C0 bordercolordark=#FFFFFF bordercolorlight=#C0C0C0>\r\n";
        }

        String beginRow() {
            return "<TR VALIGN=\"TOP\"><TD><TT>";
        }

        String beginRow(int span) {
            return "<TR VALIGN=\"TOP\"><TD COLSPAN=\"" + Integer.toString(span) + "\"><TT>";
        }

        String beginHRow() {
            return this.beginRow();
        }

        String beginHRow(int span) {
            return this.beginHRow(span);
        }

        String tab() {
            return "</TT></TD><TD><TT>";
        }

        String tab(int span) {
            return "</TT></TD><TD COLSPAN=\"" + Integer.toString(span) + "\"><TT>";
        }
    }

    private static abstract class Table {
        private Table() {
        }

        abstract String beginTable();

        abstract String beginRow();

        abstract String beginRow(int var1);

        abstract String beginHRow();

        abstract String beginHRow(int var1);

        abstract String tab();

        abstract String tab(int var1);

        String endRow() {
            return "</TT></TD></TR>\r\n";
        }

        String endTable() {
            return "</Table>";
        }
    }

    public static class Menu {
        StringBuffer m_data = new StringBuffer(200);
        boolean m_added;

        public Menu(String name) {
            String top = "<html>\n\n<head>\n<base target=\"body\">\n<title>" + name + "</title>\n" + "<STYLE TYPE=\"text/css\">\n" + ".hd1{font:bold 14px verdana;color:#787878}\n" + ".mnu1{color:#FFFFFF;text-decoration:none;font:bold 12px verdana}\n" + ".mnu2{color:#000000;text-decoration:none;font:bold 12px verdana}\n" + ".pd1{padding-left:15px}\n" + "A:link{color:#003399}\n" + "A:visited{color:#800080}\n" + "A:hover{color:#FF3300}\n" + "TD{font-family: Verdana,Arial,Helvetica; font-size: xx-small;}\n" + "</STYLE>\n" + "\n" + "</head>\n" + "\n" + "<body bgcolor=\"#6699CC\" topmargin=\"0\" leftmargin=\"15\" link=\"#FFFFFF\" vlink=\"#FFFFFF\" text=\"#FFFFFF\">\n" + "<BASEFONT FACE=\"Verdana, Arial, Helvetica\" SIZE=\"3\">\n" + "\n" + "<a class=\"mnu2\">" + name + ":&nbsp;&nbsp; </a>\n" + "";
            this.m_data.append(top);
        }

        public Menu add(String link, String name) {
            if (this.m_added) {
                this.m_data.append("&nbsp;&nbsp;<FONT COLOR='#FFFFFF'>|</FONT>&nbsp;&nbsp;\n");
            } else {
                this.m_added = true;
            }
            String item = "<A CLASS=\"mnu1\" \nSTYLE=\"color:#FFFFFF;\" \nHREF=\"" + link + "\" \n" + "TARGET=\"body\" \n" + "onmouseover=\"this.style.color='#FFCC00';\" \n" + "onmouseout=\"this.style.color='#FFFFFF';\">" + name + "</A>\n" + "";
            this.m_data.append(item);
            return this;
        }

        public String toString() {
            return this.m_data + "</span></font></body></html>";
        }
    }
}

