/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.ExceptionInfo;
import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.management.message.MessageLocalizationInfo;
import com.sun.jbi.util.JBIUtils;
import java.util.List;
import java.util.logging.Logger;

public class TaskResultDetails
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(TaskResultDetails.class.getName());
    public static final String ELEMENT_NAME = "task-result-details";
    public static final String TASK_ID_NAME = "task-id";
    public static final String TASK_RESULT_NAME = "task-result";
    public static final String MESSAGE_TYPE_NAME = "message-type";
    public static final String TASK_STATUS_MESSAGE_NAME = "task-status-msg";
    private String taskId;
    private boolean successfulResult = true;
    private int messageType = 0;
    private List messages;
    private List exceptions;

    protected String buildString() throws JBIMessageException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t\t\t<");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t<");
        buffer.append(TASK_ID_NAME);
        buffer.append(">");
        buffer.append(this.taskId);
        buffer.append("</");
        buffer.append(TASK_ID_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t<");
        buffer.append(TASK_RESULT_NAME);
        buffer.append(">");
        buffer.append(this.successfulResult ? "SUCCESS" : "FAILED");
        buffer.append("</");
        buffer.append(TASK_RESULT_NAME);
        buffer.append(">\n");
        if (this.messageType != 0) {
            buffer.append("\t\t\t\t\t<");
            buffer.append(MESSAGE_TYPE_NAME);
            buffer.append(">");
            buffer.append(this.getMessageTypeString());
            buffer.append("</");
            buffer.append(MESSAGE_TYPE_NAME);
            buffer.append(">\n");
        }
        if (this.messages != null && this.messages.size() != 0) {
            buffer.append("\t\t\t\t\t<");
            buffer.append(TASK_STATUS_MESSAGE_NAME);
            buffer.append(">\n");
            for (MessageLocalizationInfo messageLocalization : this.messages) {
                buffer.append(messageLocalization.getString());
            }
            buffer.append("\t\t\t\t\t</");
            buffer.append(TASK_STATUS_MESSAGE_NAME);
            buffer.append(">\n");
        }
        if (this.exceptions != null && this.exceptions.size() != 0) {
            for (ExceptionInfo exceptionInfo : this.exceptions) {
                buffer.append(exceptionInfo.getString());
            }
        }
        buffer.append("\t\t\t\t</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.taskId == null) {
            logger.warning("Task id not set in task result details");
        }
        if (this.successfulResult && this.messageType == 3) {
            logger.warning("Inconsistent message type: cannot use error message for successful result");
        }
    }

    public String getMessageTypeString() {
        switch (this.messageType) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "ERROR";
            }
        }
        throw new IllegalStateException("Invalid message type: " + this.messageType);
    }

    public List getExceptions() {
        if (this.exceptions == null) {
            this.exceptions = JBIUtils.createSafeList(ExceptionInfo.class, false, false);
        }
        return this.exceptions;
    }

    public ExceptionInfo newExceptionInfo(Throwable throwable, MessageLocalizationInfo messageLocalization) throws JBIMessageException {
        ExceptionInfo exceptionInfo = new ExceptionInfo(throwable, messageLocalization);
        this.getExceptions().add(exceptionInfo);
        return exceptionInfo;
    }

    public void addExceptionInfo(ExceptionInfo exceptionInfo) throws JBIMessageException {
        if (exceptionInfo == null) {
            throw new JBIMessageException("Exception info cannot be null");
        }
        this.getExceptions().add(exceptionInfo);
    }

    public void removeExceptionInfo(ExceptionInfo exceptionInfo) throws JBIMessageException {
        if (exceptionInfo == null) {
            throw new JBIMessageException("Cannot remove null exception");
        }
        if (this.exceptions == null) {
            throw new JBIMessageException("Empty exception list, cannot remove");
        }
        if (!this.exceptions.remove(exceptionInfo)) {
            throw new JBIMessageException("Exception not in list, cannot remove");
        }
    }

    public void setExceptions(List exceptions) throws JBIMessageException {
        JBIUtils.validateCollection(exceptions, ExceptionInfo.class);
        this.exceptions = exceptions;
    }

    public List getMessages() {
        if (this.messages == null) {
            this.messages = JBIUtils.createSafeList(MessageLocalizationInfo.class, false, false);
        }
        return this.messages;
    }

    public MessageLocalizationInfo newMessageLocalizationInfo(String token, String message, Object[] parameters) throws JBIMessageException {
        MessageLocalizationInfo messageLocalization = new MessageLocalizationInfo(token, message, parameters);
        this.getMessages().add(messageLocalization);
        return messageLocalization;
    }

    public void addMessageLocalizationInfo(MessageLocalizationInfo messageLocalization) throws JBIMessageException {
        if (messageLocalization == null) {
            throw new JBIMessageException("Message localization info cannot be null");
        }
        this.getMessages().add(messageLocalization);
    }

    public void removeMessageLocalizationInfo(MessageLocalizationInfo messageLocalization) throws JBIMessageException {
        if (messageLocalization == null) {
            throw new JBIMessageException("Cannot remove null exception");
        }
        if (this.messages == null) {
            throw new JBIMessageException("Empty message localization list, cannot remove");
        }
        if (!this.messages.remove(messageLocalization)) {
            throw new JBIMessageException("Message localization not in list, cannot remove");
        }
    }

    public void setMessages(List messages) throws JBIMessageException {
        JBIUtils.validateCollection(messages, MessageLocalizationInfo.class);
        this.messages = messages;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) throws JBIMessageException {
        switch (messageType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.messageType = messageType;
                break;
            }
            default: {
                throw new JBIMessageException("Invalid message type: " + messageType);
            }
        }
    }

    public boolean isSuccessfulResult() {
        return this.successfulResult;
    }

    public void setSuccessfulResult(boolean successfulResult) {
        this.successfulResult = successfulResult;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) throws JBIMessageException {
        if (taskId == null) {
            throw new JBIMessageException("Task id cannot be null");
        }
        this.taskId = taskId;
    }
}

