/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import com.sun.enterprise.jbi.serviceengine.bridge.EndpointLifecycleListenerImpl;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.EndpointLifecycleListener;
import com.sun.enterprise.webservice.monitoring.WebServiceEngine;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

public class EndpointHelper {
    private WebServiceEngine engine = WebServiceEngineFactory.getInstance().getEngine();
    private ComponentContext context;
    private EndpointRegistry registry;
    private Map uriToDetailsMap;
    private static EndpointHelper helper = new EndpointHelper();
    private EndpointLifecycleListener epLifecycleListener = new EndpointLifecycleListenerImpl();
    private static final String auto_enabled = System.getProperty("com.sun.enterprise.jbi.se.autoendpointenabling");
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    private EndpointHelper() {
        this.engine.addLifecycleListener(this.epLifecycleListener);
        this.context = JavaEEServiceEngineContext.getInstance().getJBIContext();
        this.registry = EndpointRegistry.getInstance();
        this.uriToDetailsMap = new HashMap();
    }

    public static EndpointHelper getInstance() {
        return helper;
    }

    public void initialize() {
        Iterator endpoints = this.engine.getEndpoints();
        while (endpoints.hasNext()) {
            this.registerEndpoint((Endpoint)endpoints.next());
        }
    }

    public void enableEndpoint(QName service, String endpointName) {
        ServiceEngineEndpoint endpoint;
        if (endpointName != null && (endpoint = this.registry.get(service, endpointName)) != null && !endpoint.isEnabled()) {
            try {
                ServiceEndpoint jbiEndpoint = this.activateEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
                endpoint.setServiceEndpoint(jbiEndpoint);
                endpoint.setEnabled(true);
                this.debug(Level.INFO, "serviceengine.enable_endpoint", new Object[]{service.getLocalPart(), endpointName});
            }
            catch (Exception e) {
                this.debug(Level.SEVERE, "serviceengine.error_enable", new Object[]{service.getLocalPart(), endpointName});
            }
        }
    }

    public void registerEndpoint(Endpoint endpoint) {
        this.registerEndpoint(endpoint.getDescriptor());
    }

    public void registerEndpoint(com.sun.enterprise.deployment.WebServiceEndpoint webServiceDesc) {
        if (webServiceDesc != null) {
            String endpointName = webServiceDesc.hasWsdlPort() ? webServiceDesc.getWsdlPort().getLocalPart() : webServiceDesc.getEndpointName();
            this.debug(Level.FINE, "serviceengine.start_registration", new Object[]{webServiceDesc.getServiceName(), endpointName});
            try {
                boolean ejbType = webServiceDesc.implementedByEjbComponent();
                String relativeURI = webServiceDesc.getEndpointAddressUri();
                String implClass = ejbType ? webServiceDesc.getTieClassName() : webServiceDesc.getServletImplClass();
                String contextRoot = null;
                if (!ejbType) {
                    contextRoot = webServiceDesc.getWebComponentImpl().getWebBundleDescriptor().getContextRoot();
                    relativeURI = contextRoot + relativeURI;
                }
                ServiceEngineEndpoint seEndpoint = new ServiceEngineEndpoint(webServiceDesc, webServiceDesc.getServiceName(), endpointName, implClass, contextRoot, true);
                if (this.isJBIEnabled(webServiceDesc) || this.registry.hasProviderEP(seEndpoint)) {
                    ServiceEndpoint endpoint = this.activateEndpoint(webServiceDesc.getServiceName(), endpointName);
                    seEndpoint.setServiceEndpoint(endpoint);
                    this.debug(Level.FINE, "serviceengine.success_registration", new Object[]{webServiceDesc.getServiceName(), endpointName});
                } else {
                    seEndpoint.setEnabled(false);
                }
                this.registry.put(webServiceDesc.getServiceName(), endpointName, seEndpoint);
                this.uriToDetailsMap.put(relativeURI, new Object[]{webServiceDesc.getServiceName(), endpointName});
            }
            catch (Exception e) {
                this.debug(Level.SEVERE, "serviceengine.error_registration", new Object[]{webServiceDesc.getServiceName(), endpointName});
            }
        }
    }

    public void disableEndpoint(QName service, String endpointName) {
        ServiceEngineEndpoint endpoint = this.registry.get(service, endpointName);
        if (endpoint != null) {
            try {
                ServiceEndpoint endpt = endpoint.getServiceEndpoint();
                if (endpt != null) {
                    this.context.deactivateEndpoint(endpt);
                    endpoint.setEnabled(false);
                    this.debug(Level.INFO, "serviceengine.disable_endpoint", new Object[]{service.getLocalPart(), endpointName});
                }
            }
            catch (Exception e) {
                this.debug(Level.SEVERE, "serviceengine.error_disable", new Object[]{service.getLocalPart(), endpointName});
            }
        }
    }

    public void unregisterEndpoint(QName service, String endpointName) {
        ServiceEngineEndpoint endpoint;
        if (endpointName != null && (endpoint = this.registry.get(service, endpointName)) != null) {
            String endpointURI = endpoint.getURI();
            this.disableEndpoint(service, endpointName);
            this.registry.delete(service, endpointName);
            this.uriToDetailsMap.remove(endpointURI);
            this.debug(Level.INFO, "serviceengine.success_removal", new Object[]{service.getLocalPart(), endpointName});
        }
    }

    public void toggleEndpointStatus(String uri, boolean flag) {
        Object[] endpointInfo = (Object[])this.uriToDetailsMap.get(uri);
        if (endpointInfo != null) {
            if (flag) {
                this.enableEndpoint((QName)endpointInfo[0], (String)endpointInfo[1]);
            } else {
                this.disableEndpoint((QName)endpointInfo[0], (String)endpointInfo[1]);
            }
        }
    }

    public void destroy() {
        this.engine.removeLifecycleListener(this.epLifecycleListener);
    }

    private ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        String key = DescriptorEndpointInfo.getDEIKey(serviceName, endpointName);
        DescriptorEndpointInfo dei = this.registry.getJBIEndpts().get(key);
        if (dei != null) {
            serviceName = dei.getServiceName();
            endpointName = dei.getEndpointName();
        }
        return this.context.activateEndpoint(serviceName, endpointName);
    }

    private void debug(Level logLevel, String msgID, Object[] params) {
        logger.log(logLevel, msgID, params);
    }

    private boolean isJBIEnabled(com.sun.enterprise.deployment.WebServiceEndpoint endpoint) {
        try {
            WebServiceEndpoint endpointBean;
            String applicationName = endpoint.getWebService().getBundleDescriptor().getApplication().getRegistrationName();
            ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
            ConfigBean app = ApplicationHelper.findApplication((ConfigContext)configContext, (String)applicationName);
            String type = ApplicationHelper.getApplicationType((ConfigContext)configContext, (String)applicationName);
            String endpointName = endpoint.getEndpointName();
            if (type.equals("J2eeApplication")) {
                WebServiceEndpoint endpointBean2 = ((J2eeApplication)app).getWebServiceEndpointByName(endpointName);
                if (endpointBean2 != null) {
                    return endpointBean2.isJbiEnabled();
                }
            } else if (type.equals("EjbModule")) {
                WebServiceEndpoint endpointBean3 = ((EjbModule)app).getWebServiceEndpointByName(endpointName);
                if (endpointBean3 != null) {
                    return endpointBean3.isJbiEnabled();
                }
            } else if (type.equals("WebModule") && (endpointBean = ((WebModule)app).getWebServiceEndpointByName(endpointName)) != null) {
                return endpointBean.isJbiEnabled();
            }
        }
        catch (Throwable ce) {
            this.debug(Level.SEVERE, "serviceengine.config_not_found", new Object[]{endpoint.getServiceName(), endpoint.getEndpointName()});
        }
        return "true".equalsIgnoreCase(auto_enabled);
    }
}

