/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.ComponentTaskResultDetails;
import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import java.util.logging.Logger;

public class ComponentTaskResult
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(ComponentTaskResult.class.getName());
    public static final String ELEMENT_NAME = "component-task-result";
    public static final String COMPONENT_NAME_NAME = "component-name";
    private String componentName;
    private ComponentTaskResultDetails details;

    public ComponentTaskResult() {
    }

    public ComponentTaskResult(String componentName, ComponentTaskResultDetails details) {
        this.setComponentName(componentName);
        this.setDetails(details);
    }

    protected String buildString() throws JBIMessageException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t<");
        buffer.append(COMPONENT_NAME_NAME);
        buffer.append(">");
        buffer.append(this.componentName);
        buffer.append("</");
        buffer.append(COMPONENT_NAME_NAME);
        buffer.append(">\n");
        buffer.append(this.details.getString());
        buffer.append("\t\t</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.componentName == null) {
            logger.warning("Component name not set in component task result");
        }
        if (this.details == null) {
            logger.warning("Details not set in component task result");
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) throws JBIMessageException {
        if (componentName == null) {
            throw new JBIMessageException("Component name cannot be null");
        }
        this.componentName = componentName;
    }

    public ComponentTaskResultDetails getDetails() {
        if (this.details == null) {
            this.details = new ComponentTaskResultDetails();
        }
        return this.details;
    }

    public void setDetails(ComponentTaskResultDetails details) throws JBIMessageException {
        if (details == null) {
            throw new JBIMessageException("Component task result details cannot be null");
        }
        this.details = details;
    }
}

