/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.OutboundAction;
import com.sun.jbi.httpsoapbc.OutboundMessageProcessorPool;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfiguration;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBean;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.internationalization.Messages;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;

public class OutboundReceiver
implements Runnable {
    private static final Messages mMessages = Messages.getMessages(OutboundReceiver.class);
    int mOutboundCorePoolSize = 5;
    int mOutboundKeepAliveTime = 600;
    TimeUnit mOutboundTimeUnit = TimeUnit.SECONDS;
    int mOutboundMaxPoolSize = Integer.MAX_VALUE;
    ThreadPoolExecutor mOutboundPooledExecutor;
    private MessagingChannel mChannel;
    private Logger mLog;
    private Object mMonitor;
    private Map mEndpoints;
    private Map mInboundExchanges;
    OutboundMessageProcessorPool mProcessorPool;
    private NotificationListener listener = new NotificationListener(){

        public void handleNotification(Notification notification, Object obj) {
            AttributeChangeNotification attrNotif;
            String attrName;
            if (notification instanceof AttributeChangeNotification && (attrName = (attrNotif = (AttributeChangeNotification)notification).getAttributeName()).equals("OutboundThreads")) {
                Integer newVal = (Integer)attrNotif.getNewValue();
                OutboundReceiver.this.setThreads(newVal);
            }
        }
    };

    public OutboundReceiver(MessagingChannel bc, Map endpoints, RuntimeConfiguration runtimeConfig, HTTPManagementMBean managementMBean) {
        this.mLog = Messages.getLogger(OutboundReceiver.class);
        this.mChannel = bc;
        Integer threadCount = runtimeConfig.getOutboundThreads();
        if (threadCount != null) {
            this.setThreads(threadCount);
        }
        runtimeConfig.addNotificationListener(this.listener, null, null);
        this.mOutboundPooledExecutor = new ThreadPoolExecutor(this.mOutboundCorePoolSize, this.mOutboundMaxPoolSize, (long)this.mOutboundKeepAliveTime, this.mOutboundTimeUnit, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
        this.mOutboundPooledExecutor.prestartAllCoreThreads();
        this.mMonitor = new Object();
        this.mEndpoints = endpoints;
        this.mInboundExchanges = InboundMessageProcessor.getInboundExchanges();
        this.mProcessorPool = new OutboundMessageProcessorPool(5, this.mOutboundMaxPoolSize, this.mChannel, this.mEndpoints, this.mInboundExchanges, managementMBean);
    }

    public void run() {
        MessageExchange exchange = null;
        if (this.mLog.isLoggable(Level.FINE)) {
            this.mLog.log(Level.FINE, "Receiver started");
        }
        try {
            do {
                if ((exchange = this.mChannel.accept(5000L)) == null) continue;
                if (this.mLog.isLoggable(Level.FINE)) {
                    this.mLog.log(Level.FINE, "Got a message with SOAP binding; id: " + exchange.getExchangeId());
                }
                try {
                    OutboundAction action = new OutboundAction(this.mProcessorPool, exchange);
                    exchange = null;
                    this.mOutboundPooledExecutor.execute(action);
                }
                catch (Exception e) {
                    String error = mMessages.getString("HTTPBC-S00800.Failed_to_process_message_exchange");
                    this.mLog.log(Level.SEVERE, error, e);
                    AlertsUtil.getAlerter().critical(error, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-S00800");
                }
            } while (this.mMonitor != null);
        }
        catch (Exception e) {
            String error = mMessages.getString("HTTPBC-S00801.Failed_to_accept_from_NMR");
            this.mLog.log(Level.SEVERE, error, e);
            AlertsUtil.getAlerter().critical(error, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-S00801");
        }
    }

    public void setThreads(int threadCount) {
        this.mOutboundMaxPoolSize = threadCount;
        if (this.mOutboundPooledExecutor != null) {
            this.mOutboundPooledExecutor.setMaximumPoolSize(this.mOutboundMaxPoolSize);
        }
        if (this.mProcessorPool != null) {
            this.mProcessorPool.setSize(threadCount);
        }
    }

    public void stopReceiving() {
        if (this.mLog.isLoggable(Level.FINE)) {
            this.mLog.log(Level.FINE, "Stopping the receiver thread");
        }
        this.mMonitor = null;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r, "HTTPBC-OutboundReceiver-" + this.threadNumber.getAndIncrement());
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

