/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.descriptor;

import com.sun.jbi.common.descriptor.EndpointInfo;
import com.sun.jbi.common.qos.ServiceQuality;
import com.sun.jbi.common.qos.descriptor.QosConfig;
import com.sun.jbi.common.qos.descriptor.parsers.QosConnectionParser;
import com.sun.jbi.common.qos.descriptor.parsers.RedeliveryParser;
import com.sun.jbi.common.qos.descriptor.parsers.ThrottlingParser;
import com.sun.jbi.common.util.I18n;
import com.sun.jbi.common.xml.StackableParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QosAssemblyDescriptor {
    private static SAXParserFactory mFactory = SAXParserFactory.newInstance();
    private static Logger mLogger = Logger.getLogger(QosAssemblyDescriptor.class.getName());
    private Map<EndpointInfo, List<ServiceQuality>> mQosMap;

    public Map<EndpointInfo, List<ServiceQuality>> getServiceQualities() {
        return new HashMap<EndpointInfo, List<ServiceQuality>>(this.mQosMap);
    }

    public static QosConfig parse(InputSource source) throws DeploymentException {
        try {
            StackableParser root = StackableParser.createRootParser();
            QosConnectionParser qosParser = new QosConnectionParser();
            root.declareStackableParser((StackableParser)qosParser, "http://www.sun.com/jbi/qos", new String[]{"connection", "consumer", "provider"});
            root.declareStackableParser((StackableParser)new RedeliveryParser(), "http://www.sun.com/jbi/qos/redelivery", new String[]{"redelivery", "error", "delete", "suspend", "redirect"});
            root.declareStackableParser((StackableParser)new ThrottlingParser(), "http://www.sun.com/jbi/qos/throttling", new String[]{"throttling"});
            SAXParser parser = mFactory.newSAXParser();
            parser.parse(source, (DefaultHandler)root);
            return new QosConfig(qosParser.getConnections(), qosParser.getServiceQualities());
        }
        catch (ParserConfigurationException pce) {
            throw QosAssemblyDescriptor.error(I18n.loc((String)"QOS-6003: Failed to obtain SAX parser: {0}", (Object[])new Object[]{pce.getMessage()}), pce);
        }
        catch (SAXException se) {
            throw QosAssemblyDescriptor.error(I18n.loc((String)"QOS-6004: Failed to parse service unit descriptor: {0}", (Object[])new Object[]{se.getMessage()}), se);
        }
        catch (IOException ioe) {
            throw QosAssemblyDescriptor.error(I18n.loc((String)"QOS-6005: Unexpected I/O error parsing service unit descriptor: {0}", (Object[])new Object[]{ioe.getMessage()}), ioe);
        }
    }

    private static DeploymentException error(String message, Exception thrown) {
        if (thrown == null) {
            mLogger.warning(message);
            return new DeploymentException(message);
        }
        mLogger.log(Level.WARNING, message, thrown);
        return new DeploymentException(message, (Throwable)thrown);
    }
}

