/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator.httpvalidators;

import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.validator.AbstractValidator;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;

public class HttpAddressValidator
extends AbstractValidator
implements Validator {
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private static final Messages mMessages = Messages.getMessages(HttpAddressValidator.class);

    public HttpAddressValidator() {
    }

    public HttpAddressValidator(RuntimeConfigurationMBean runtimeConfig, boolean resolveTokens) {
        super(runtimeConfig, resolveTokens);
    }

    public void validate(ExtensibilityElement element) throws ValidationException {
        int contextStartIndex;
        int colonIndex;
        HTTPAddress address = (HTTPAddress)element;
        String location = address.getLocationURI();
        if (location == null || "".equals(location)) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00273.Address_required"));
        }
        if (location.equals("REPLACE_WITH_ACTUAL_URL")) {
            return;
        }
        if (location.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("https://")) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00276.Http_var_protocol_mismatch", new Object[]{HTTP_DEFAULT_PORT_TOKEN, "https"}));
            }
            if (location.startsWith("http://") && !HTTP_DEFAULT_PORT_TOKEN.equals(location.substring((colonIndex = location.indexOf(":", 6)) + 1, contextStartIndex = location.indexOf("/", 7)))) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00277.Http_var_invalid", new Object[]{HTTP_DEFAULT_PORT_TOKEN, location}));
            }
        }
        if (location.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0) {
            colonIndex = -1;
            contextStartIndex = -1;
            if (location.startsWith("http://")) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00276.Http_var_protocol_mismatch", new Object[]{HTTPS_DEFAULT_PORT_TOKEN, "http"}));
            }
            if (location.startsWith("https://") && !HTTPS_DEFAULT_PORT_TOKEN.equals(location.substring((colonIndex = location.indexOf(":", 7)) + 1, contextStartIndex = location.indexOf("/", 8)))) {
                throw new ValidationException(mMessages.getString("HTTPBC-E00277.Http_var_invalid", new Object[]{HTTPS_DEFAULT_PORT_TOKEN, location}));
            }
        }
        try {
            if (!this.mResolveTokens) {
                this.updateAppVariableMap(location, "STRING");
            } else {
                String newLocation = this.resolveEmbeddedTokensInURL(location);
                newLocation = this.resolveHostNameInUrl(newLocation);
                this.validateLocationURI(newLocation);
                address.setLocationURI(newLocation);
            }
        }
        catch (Exception ex) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00275.Address_unsupported", new Object[]{location, ex.getLocalizedMessage()}));
        }
    }
}

