/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.GrizzlyHttpProtocol;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.async.DefaultAsyncHandler;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.embedded.BCCoyoteConnector;
import com.sun.jbi.httpsoapbc.embedded.GrizzlyEmbeddedWebContainer;
import com.sun.jbi.httpsoapbc.embedded.JAXWSGrizzlyRequestProcessor;
import com.sun.jbi.httpsoapbc.embedded.JBIGrizzlyAsyncFilter;
import com.sun.jbi.httpsoapbc.embedded.LinkedListThrottlePipeline;
import com.sun.jbi.internationalization.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.coyote.ProtocolHandler;

public class EmbeddedServerController {
    private static final Messages mMessages = Messages.getMessages(EmbeddedServerController.class);
    private static final Logger mLogger = Messages.getLogger(EmbeddedServerController.class);
    private Map mStartedServers = new HashMap();
    private HttpSoapBindingLifeCycle mLifeCycle;

    public EmbeddedServerController(HttpSoapBindingLifeCycle httpBCLifeCycle) {
        this.mLifeCycle = httpBCLifeCycle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startServer(int port, String protocol) throws Throwable {
        if (!this.mStartedServers.containsKey(new Integer(port))) {
            try {
                String address = null;
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Attempting to create Grizzly connector at port " + new Integer(port));
                }
                Connector connector = new GrizzlyEmbeddedWebContainer().createConnector(address, port, protocol, this.mLifeCycle);
                BCCoyoteConnector peCon = (BCCoyoteConnector)connector;
                JAXWSGrizzlyRequestProcessor adapter = new JAXWSGrizzlyRequestProcessor(peCon);
                peCon.setAdapter(adapter);
                boolean secure = connector.getSecure();
                boolean blocking = false;
                GrizzlyHttpProtocol protocolHandler = new GrizzlyHttpProtocol(secure, blocking, null);
                if (secure) {
                    protocolHandler.setAttribute("keystoreType", (Object)"JKS");
                    protocolHandler.setAttribute("truststoreType", (Object)"JKS");
                    if (System.getProperty("javax.net.ssl.keyStore") == null) {
                        throw new Exception(mMessages.getString("HTTPBC-E00673.keystore_config_not_available", (Object)port));
                    }
                    protocolHandler.setAttribute("keystore", (Object)System.getProperty("javax.net.ssl.keyStore"));
                    if (System.getProperty("javax.net.ssl.trustStore") == null) {
                        throw new Exception(mMessages.getString("HTTPBC-E00674.trustore_config_not_available", (Object)port));
                    }
                    protocolHandler.setAttribute("truststore", (Object)System.getProperty("javax.net.ssl.trustStore"));
                    if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
                        throw new Exception(mMessages.getString("HTTPBC-E00675.keypass_config_not_available", (Object)port));
                    }
                    protocolHandler.setAttribute("keypass", (Object)System.getProperty("javax.net.ssl.keyStorePassword"));
                }
                peCon.setProtocolHandler((ProtocolHandler)protocolHandler);
                SelectorThread selThread = protocolHandler.selectorThread();
                DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
                selThread.setAsyncHandler((AsyncHandler)asyncHandler);
                selThread.setEnableAsyncExecution(true);
                JBIGrizzlyAsyncFilter filter = new JBIGrizzlyAsyncFilter();
                asyncHandler.addAsyncFilter((AsyncFilter)filter);
                selThread.setClassLoader(this.getClass().getClassLoader());
                selThread.setPipelineClassName(LinkedListThrottlePipeline.class.getName());
                peCon.setChunkingDisabled(true);
                peCon.setProperty("reuseAddress", false);
                peCon.start();
                this.mStartedServers.put(new Integer(port), connector);
                if (!mLogger.isLoggable(Level.FINE)) return;
                mLogger.log(Level.FINE, "Grizzly connector created at port " + new Integer(port));
                return;
            }
            catch (RuntimeException ex) {
                mLogger.log(Level.SEVERE, "HTTPBC-E00656.Exception_during_grizzly_start", ex);
                throw ex;
            }
            catch (Throwable ex) {
                mLogger.log(Level.SEVERE, "HTTPBC-E00656.Exception_during_grizzly_start", ex);
                throw ex;
            }
        } else {
            Connector connector = (Connector)this.mStartedServers.get(new Integer(port));
            String currentProtocol = connector.getScheme();
            if (currentProtocol.equalsIgnoreCase(protocol)) return;
            throw new Exception(mMessages.getString("HTTPBC-E00672.Same_port_no_matching_protocol", new Object[]{new Integer(port), currentProtocol, protocol}));
        }
    }

    public void stopAll() {
        for (BCCoyoteConnector connector : this.mStartedServers.values()) {
            try {
                connector.stop();
                if (!mLogger.isLoggable(Level.FINE)) continue;
                mLogger.log(Level.FINE, "Stopped Grizzly connector for port " + new Integer(connector.getPort()));
            }
            catch (Exception ex) {
                if (!mLogger.isLoggable(Level.WARNING)) continue;
                String text = mMessages.getString("HTTPBC-W00655.Exception_during_grizzly_stop", new Object[]{new Integer(connector.getPort()), ex.getLocalizedMessage()});
                mLogger.log(Level.WARNING, text, ex);
            }
        }
        this.mStartedServers.clear();
    }

    public void stopServer(int port) {
        block4: {
            Integer aPort = port;
            BCCoyoteConnector connector = (BCCoyoteConnector)((Object)this.mStartedServers.remove(aPort));
            if (connector != null) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Stopping embedded HTTP server at port " + aPort);
                }
                try {
                    connector.stop();
                }
                catch (Exception ex) {
                    if (!mLogger.isLoggable(Level.WARNING)) break block4;
                    String text = mMessages.getString("HTTPBC-W00655.Exception_during_grizzly_stop", new Object[]{aPort, ex.getLocalizedMessage()});
                    mLogger.log(Level.WARNING, text, ex);
                }
            }
        }
    }
}

