/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class MessageLocalizationInfo
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(MessageLocalizationInfo.class.getName());
    public static final String ELEMENT_NAME = "msg-loc-info";
    public static final String LOCALIZATION_TOKEN_NAME = "loc-token";
    public static final String LOCALIZATION_MESSAGE_NAME = "loc-message";
    public static final String LOCALIZATION_PARAMETER_NAME = "loc-param";
    private String token;
    private String message;
    private Object[] parameters;

    public MessageLocalizationInfo() {
    }

    public MessageLocalizationInfo(String tkn, String msg, Object[] params) throws JBIMessageException {
        this.setToken(tkn);
        this.setMessage(msg);
        this.setParameters(params);
    }

    protected String buildString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t\t\t\t<");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t\t<");
        buffer.append(LOCALIZATION_TOKEN_NAME);
        buffer.append(">");
        buffer.append(this.token);
        buffer.append("</");
        buffer.append(LOCALIZATION_TOKEN_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t\t<");
        buffer.append(LOCALIZATION_MESSAGE_NAME);
        buffer.append(">");
        buffer.append(this.message);
        buffer.append("</");
        buffer.append(LOCALIZATION_MESSAGE_NAME);
        buffer.append(">\n");
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                String parameter = "null";
                if (this.parameters[i] != null) {
                    parameter = this.parameters[i].toString();
                }
                buffer.append("\t\t\t\t\t\t<");
                buffer.append(LOCALIZATION_PARAMETER_NAME);
                buffer.append(">");
                buffer.append(parameter);
                buffer.append("</");
                buffer.append(LOCALIZATION_PARAMETER_NAME);
                buffer.append(">\n");
            }
        }
        buffer.append("\t\t\t\t\t</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.token == null) {
            logger.warning("Token not set in message localization");
        }
        if (this.message == null) {
            logger.warning("Message not set in message localization");
        }
        int actualParameterCount = 0;
        if (this.parameters != null) {
            actualParameterCount = this.parameters.length;
        }
        MessageFormat messageFormat = null;
        try {
            messageFormat = new MessageFormat(this.message);
        }
        catch (Exception e) {
            logger.warning("Error in pattern '" + this.message + "': " + e);
        }
        int expectedParameterCount = -1;
        try {
            expectedParameterCount = messageFormat.getFormatsByArgumentIndex().length;
        }
        catch (Exception e) {
            logger.warning("validate() failed to tally message formats: " + e);
        }
        if (expectedParameterCount != actualParameterCount && expectedParameterCount > -1) {
            logger.warning("Parameter count mismatch, expected " + expectedParameterCount + ", actual " + actualParameterCount);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) throws JBIMessageException {
        if (msg == null) {
            throw new JBIMessageException("Localized message text cannot be null");
        }
        this.message = msg;
    }

    public Object[] getParameters() {
        return this.copy(this.parameters);
    }

    public void setParameters(Object[] params) {
        this.parameters = this.copy(params);
    }

    private Object[] copy(Object[] src) {
        if (src == null) {
            return null;
        }
        int len = src.length;
        Object[] dest = new Object[len];
        System.arraycopy(src, 0, dest, 0, len);
        return dest;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String tkn) throws JBIMessageException {
        if (tkn == null) {
            throw new JBIMessageException("Localization token cannot be null");
        }
        this.token = tkn;
    }
}

