/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.config.AbstractConfigMBean;
import com.sun.jbi.common.qos.config.AppConfig;
import com.sun.jbi.common.qos.config.AppVar;
import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.Property;
import com.sun.jbi.common.qos.config.RuntimeConfigurationMBean;
import java.util.Iterator;
import java.util.logging.Level;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.namespace.QName;

public class RuntimeConfiguration
extends AbstractConfigMBean
implements RuntimeConfigurationMBean {
    private TabularType mAppConfigTabularType;
    private TabularType mAppVarTabularType;
    private CompositeType mAppConfigRowType;
    private CompositeType mAppVarRowType;

    public RuntimeConfiguration(ComponentContext ctx) throws DeploymentException {
        this(ctx, null);
    }

    public RuntimeConfiguration(ComponentContext ctx, ComponentConfig config) throws DeploymentException {
        super(ctx, config);
        this.initAppConfig(config.getAppConfigDefs());
        this.initAppVars();
    }

    public void addApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        if (this.getConfig().getAppConfig(name) != null) {
            throw this.mbeanError(null, "QOS-6030: Add Application Configuration Failed: Configuration {0} already exists!", name);
        }
        CompositeType rowType = appConfig.getCompositeType();
        Property[] configProps = this.getConfig().getAppConfigDefs();
        if (configProps.length != rowType.keySet().size()) {
            throw this.mbeanError(null, "QOS-6031: Add Application Configuration Failed: Configuration should have {0} fields, not {1}!", String.valueOf(configProps.length), String.valueOf(rowType.keySet().size()));
        }
        if (!appConfig.containsKey("configurationName")) {
            throw this.mbeanError(null, "QOS-6032: Add Application Configuration Failed: Configuration missing {0} key!", "configurationName");
        }
        try {
            AppConfig config = this.validateAppConfig(name, appConfig);
            this.getConfig().putAppConfig(config);
            if (this.log().isLoggable(Level.CONFIG)) {
                this.log().config(I18n.loc("QOS-4001: Successfully added new Application Configuration: {0}", config.getName()));
            }
        }
        catch (InvalidAttributeValueException iave) {
            throw this.mbeanError(iave, "QOS-6033: Add Application Configuration Failed: {0} value is invalid!", name);
        }
        this.persistApplicationConfig();
    }

    public void addApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        if (appVar == null) {
            return;
        }
        if (this.getConfig().getAppVar(name) != null) {
            throw this.mbeanError(null, "QOS-6034: Add Application Variable Failed: Variable {0} already exists!", name);
        }
        try {
            AppVar var = this.validateAppVar(name, appVar);
            this.getConfig().putAppVar(var);
            if (this.log().isLoggable(Level.CONFIG)) {
                this.log().config(I18n.loc("QOS-4002: Successfully added new Application Variable: {0} - Value = {1}", var.getName(), var.getValue()));
            }
        }
        catch (InvalidAttributeValueException iave) {
            throw this.mbeanError(iave, "QOS-6035: Add Application Variable Failed: {0} value is invalid!", name);
        }
        this.persistApplicationConfig();
    }

    public void deleteApplicationConfiguration(String name) throws MBeanException {
        if (this.getConfig().getAppConfig(name) == null) {
            throw this.mbeanError(null, "QOS-6036: Delete Application Configuration Failed: Configuration {0} does not exist!", name);
        }
        this.getConfig().removeAppConfig(name);
        if (this.log().isLoggable(Level.CONFIG)) {
            this.log().config(I18n.loc("QOS-4003: Successfully deleted Application Configuration: {0}", name));
        }
        this.persistApplicationConfig();
    }

    public void deleteApplicationVariable(String name) throws MBeanException {
        if (this.getConfig().getAppVar(name) == null) {
            throw this.mbeanError(null, "QOS-6037: Application Variable Delete Failed: Variable {0} does not exist!", name);
        }
        this.getConfig().removeAppVar(name);
        if (this.log().isLoggable(Level.CONFIG)) {
            this.log().config(I18n.loc("QOS-4004: Successfully deleted Application Variable: {0}", name));
        }
        this.persistApplicationConfig();
    }

    public TabularData getApplicationConfigurations() {
        TabularDataSupport tabularData = new TabularDataSupport(this.mAppConfigTabularType);
        Property[] props = this.getConfig().getAppConfigDefs();
        if (props != null && props.length > 0) {
            String[] rowNames = this.getNames(props);
            Iterator<String> iter = this.getConfig().appConfigNames();
            while (iter.hasNext()) {
                String name = iter.next();
                AppConfig ac = this.getConfig().getAppConfig(name);
                try {
                    Object[] vals = this.getValues(props, ac);
                    tabularData.put(new CompositeDataSupport(this.mAppConfigRowType, rowNames, vals));
                }
                catch (OpenDataException ode) {
                    throw new RuntimeException(ode);
                }
            }
        }
        return tabularData;
    }

    public TabularData getApplicationVariables() {
        try {
            TabularDataSupport data = new TabularDataSupport(this.mAppVarTabularType);
            Iterator<String> iter = this.getConfig().appVarNames();
            while (iter.hasNext()) {
                String name = iter.next();
                AppVar var = this.getConfig().getAppVar(name);
                Object[] values = new Object[]{name, var.getType() == AppVar.VarType.Password ? "********" : var.getValue(), String.valueOf((Object)var.getType())};
                data.put(new CompositeDataSupport(this.mAppVarRowType, new String[]{"name", "value", "type"}, values));
            }
            return data;
        }
        catch (OpenDataException ode) {
            throw new RuntimeException(ode);
        }
    }

    public CompositeType queryApplicationConfigurationType() {
        return this.mAppConfigRowType;
    }

    public void setApplicationConfiguration(String name, CompositeData appConfig) throws MBeanException {
        if (this.getConfig().getAppConfig(name) == null) {
            throw this.mbeanError(null, "QOS-6038: Set Application Configuration Failed: Configuration {0} does not exist!", name);
        }
        CompositeType rowType = appConfig.getCompositeType();
        Property[] configProps = this.getConfig().getAppConfigDefs();
        if (configProps.length != rowType.keySet().size()) {
            throw this.mbeanError(null, "QOS-6039: Set Application Configuration Failed: Configuration should have {0} fields, not {1}!", String.valueOf(configProps.length), String.valueOf(rowType.keySet().size()));
        }
        if (!appConfig.containsKey("configurationName")) {
            throw this.mbeanError(null, "QOS-6040: Set Application Configuration Failed: Configuration missing {0} key!", "configurationName");
        }
        try {
            AppConfig config = this.validateAppConfig(name, appConfig);
            this.getConfig().putAppConfig(config);
            if (this.log().isLoggable(Level.CONFIG)) {
                this.log().config(I18n.loc("QOS-4005: Successfully set Application Configuration: {0}", config.getName()));
            }
        }
        catch (InvalidAttributeValueException iave) {
            throw this.mbeanError(iave, "QOS-6041: Set Application Configuration Failed: {0} value is invalid!", name);
        }
        this.persistApplicationConfig();
    }

    public void setApplicationVariable(String name, CompositeData appVar) throws MBeanException {
        if (appVar == null) {
            return;
        }
        if (this.getConfig().getAppVar(name) == null) {
            throw this.mbeanError(null, "QOS-6042: Set Application Variable Failed: Variable {0} does not exist!", name);
        }
        try {
            AppVar var = this.validateAppVar(name, appVar);
            this.getConfig().putAppVar(var);
            if (this.log().isLoggable(Level.CONFIG)) {
                this.log().config(I18n.loc("QOS-4006: Successfully set Application Variable: {0} - Value = {1}", var.getName(), var.getValue()));
            }
        }
        catch (InvalidAttributeValueException iave) {
            throw this.mbeanError(iave, "QOS-6043: Set Application Variable Failed: {0} value is invalid!", name);
        }
        this.persistApplicationConfig();
    }

    protected AppConfig validateAppConfig(String name, CompositeData data) throws InvalidAttributeValueException {
        Property[] props = this.getConfig().getAppConfigDefs();
        AppConfig config = new AppConfig(name, props);
        for (Property metadataProp : props) {
            if (!data.containsKey(metadataProp.getName())) {
                throw this.invalidAttr("QOS-6025: Application Configuration is missing field: {0}", metadataProp.getName());
            }
            Object value = data.get(metadataProp.getName());
            if (metadataProp.isRequired() && value == null) {
                throw this.invalidAttr("QOS-6026: Application Configuration is missing value for field: {0}", metadataProp.getName());
            }
            config.addProperty(new Property(metadataProp.getName()));
            if (metadataProp.isRepeating()) {
                try {
                    String[] strs = (String[])value;
                    Property p = config.getProperty(metadataProp.getName());
                    for (String s : strs) {
                        p.addValue(s);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.log().log(Level.WARNING, e.getMessage(), e);
                    throw this.invalidAttr("QOS-6044: Application Configuration {0} - Value Invalid: {1}", metadataProp.getName(), e.getMessage());
                }
            }
            config.getProperty(metadataProp.getName()).setValue((String)value);
        }
        return config;
    }

    protected AppVar validateAppVar(String name, CompositeData appVar) throws InvalidAttributeValueException {
        CompositeType rowType = appVar.getCompositeType();
        if (rowType.keySet().size() != 3) {
            throw this.invalidAttr("QOS-6021: Invalid Application Variable Item Size: {0}", String.valueOf(rowType.keySet().size()));
        }
        if (!appVar.containsKey("name")) {
            throw this.invalidAttr("QOS-6022: Invalid Application Variable - Missing Name Field: {0}", name);
        }
        String value = (String)appVar.get("value");
        String type = (String)appVar.get("type");
        if (value == null) {
            throw this.invalidAttr("QOS-6023: Invalid Application Variable - Missing Value Field: {0}", name);
        }
        if (type == null) {
            throw this.invalidAttr("QOS-6024: Invalid Application Variable - Missing Type Field: {0}", name);
        }
        return new AppVar(name, value, AppVar.VarType.valueOf(type));
    }

    protected OpenType convertType(QName type) throws DeploymentException {
        if (type == null) {
            throw this.deployError(null, "QOS-6045: Failed to convert NULL Property type!", new Object[0]);
        }
        if (type.getNamespaceURI() != null && type.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            String name = type.getLocalPart();
            if (name.equals("string")) {
                return SimpleType.STRING;
            }
            if (name.equals("int")) {
                return SimpleType.INTEGER;
            }
            if (name.equals("boolean")) {
                return SimpleType.BOOLEAN;
            }
            if (name.equals("positiveInteger")) {
                return SimpleType.BIGINTEGER;
            }
        }
        throw this.deployError(null, "QOS-6046: Component Configuration does not support the type: {0}", type);
    }

    protected void initAppConfig(Property[] props) throws DeploymentException {
        try {
            int len;
            int n = len = props == null ? 0 : props.length;
            if (len > 0) {
                String[] attrNames = new String[len];
                String[] attrDesc = new String[len];
                OpenType[] attrTypes = new OpenType[len];
                for (int i = 0; i < len; ++i) {
                    attrNames[i] = attrDesc[i] = props[i].getName();
                    attrTypes[i] = this.convertType(props[i].getType());
                }
                this.mAppConfigRowType = new CompositeType("ApplicationConfigurationObject", "Application Configuration Composite Data", attrNames, attrDesc, attrTypes);
                this.mAppConfigTabularType = new TabularType("ApplicationConfigurationObjectList", "List of Application Configuration Objects", this.mAppConfigRowType, new String[]{"configurationName"});
            }
        }
        catch (OpenDataException ode) {
            throw this.deployError(ode, "QOS-6047: Failed to initialize Application Configuration: {0}", ode.getMessage());
        }
    }

    protected void initAppVars() throws DeploymentException {
        try {
            this.mAppVarRowType = new CompositeType("ApplicationVariables", "Application Variable Composite Data", new String[]{"name", "value", "type"}, new String[]{"Application Variable Name", "Application Variable Value", "Application Variable Type"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            this.mAppVarTabularType = new TabularType("ApplicationVariableList", "List of Application Variables", this.mAppVarRowType, new String[]{"name"});
        }
        catch (OpenDataException ode) {
            throw this.deployError(ode, "QOS-6048: Failed to initialize Application Variables: {0}", ode.getMessage());
        }
    }

    private String[] getNames(Property[] props) {
        int len = props.length;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = props[i].getName();
        }
        return names;
    }

    private Object[] getValues(Property[] props, AppConfig ac) {
        int len = props.length;
        Object[] vals = new Object[len];
        for (int i = 0; i < len; ++i) {
            Property p = props[i];
            if (p.isRepeating()) {
                int ct = p.count();
                String[] strs = new String[ct];
                for (int j = 0; j < ct; ++j) {
                    strs[j] = ac.getProperty(p.getName()).getValueAt(j);
                }
                vals[i] = strs;
                continue;
            }
            vals[i] = ac.getProperty(p.getName()).getValue();
        }
        return vals;
    }
}

